/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.Iterator;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.guvnor.server.builder.PackageAssemblerBase;
import org.drools.guvnor.server.builder.PackageAssemblerConfiguration;
import org.drools.guvnor.server.selector.AssetSelector;
import org.drools.guvnor.server.selector.BuiltInSelector;
import org.drools.guvnor.server.selector.SelectorManager;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.rule.Package;

public class PackageAssembler
extends PackageAssemblerBase {
    private static final LoggingHelper log = LoggingHelper.getLogger(PackageAssembler.class);
    private final PackageAssemblerConfiguration configuration;
    private AssetSelector selector;

    public PackageAssembler(PackageItem packageItem) {
        this(packageItem, new PackageAssemblerConfiguration());
    }

    public PackageAssembler(PackageItem packageItem, PackageAssemblerConfiguration packageAssemblerConfiguration) {
        super(packageItem);
        this.configuration = packageAssemblerConfiguration;
    }

    public void compile() {
        if (this.setUpPackage()) {
            this.buildPackage();
        }
    }

    private void buildPackage() {
        if (this.setUpSelector()) {
            this.loadAssets();
        }
    }

    private void loadAssets() {
        StringBuilder includedAssets = new StringBuilder("Following assets have been included in package build: ");
        this.loadDRLAssets(includedAssets);
        this.loadAllButDRLAssets(includedAssets);
        log.info(includedAssets.toString());
    }

    private void loadAllButDRLAssets(StringBuilder includedAssets) {
        Iterator iterator = this.getAllAssets();
        while (iterator.hasNext()) {
            AssetItem asset = (AssetItem)iterator.next();
            if (asset.getFormat().equals("drl") || !this.assetCanBeAdded(asset)) continue;
            this.addAsset(includedAssets, asset);
        }
    }

    private void loadDRLAssets(StringBuilder includedAssets) {
        Iterator drlAssetItemIterator = this.getAssetItemIterator(new String[]{"drl"});
        while (drlAssetItemIterator.hasNext()) {
            AssetItem asset = (AssetItem)drlAssetItemIterator.next();
            if (!this.assetCanBeAdded(asset)) continue;
            this.addAsset(includedAssets, asset);
        }
    }

    private void addAsset(StringBuilder includedAssets, AssetItem asset) {
        this.buildAsset(asset);
        includedAssets.append(asset.getName()).append(", ");
    }

    private boolean assetCanBeAdded(AssetItem asset) {
        return !asset.isArchived() && this.selector.isAssetAllowed(asset);
    }

    private boolean setUpSelector() {
        this.selector = "customSelector".equals(this.configuration.getBuildMode()) ? SelectorManager.getInstance().getSelector(this.configuration.getCustomSelectorConfigName()) : ("BuiltInSelector".equals(this.configuration.getBuildMode()) ? this.setUpBuiltInSelector() : SelectorManager.getInstance().getSelector(null));
        if (this.selector == null) {
            this.errorLogger.addError(this.packageItem, "The selector named " + this.configuration.getCustomSelectorConfigName() + " is not available.");
            return false;
        }
        return true;
    }

    private AssetSelector setUpBuiltInSelector() {
        BuiltInSelector builtInSelector = (BuiltInSelector)SelectorManager.getInstance().getSelector("BuiltInSelector");
        builtInSelector.setStatusOperator(this.configuration.getStatusOperator());
        builtInSelector.setStatus(this.configuration.getStatusDescriptionValue());
        builtInSelector.setEnableStatusSelector(this.configuration.isEnableStatusSelector());
        builtInSelector.setCategory(this.configuration.getCategoryValue());
        builtInSelector.setCategoryOperator(this.configuration.getCategoryOperator());
        builtInSelector.setEnableCategorySelector(this.configuration.isEnableCategorySelector());
        return builtInSelector;
    }

    public boolean isPackageConfigurationInError() {
        if (this.errorLogger.hasErrors()) {
            return ((ContentAssemblyError)this.errorLogger.getErrors().get(0)).isPackageItem();
        }
        return false;
    }

    public Package[] getBinaryPackage() {
        if (this.hasErrors()) {
            throw new IllegalStateException("There is no package available, as there were errors.");
        }
        return this.builder.getPackages();
    }

    public BRMSPackageBuilder getBuilder() {
        return this.builder;
    }
}

