/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.server.builder.AssemblerBase;
import org.drools.guvnor.server.builder.DeclaredTypesSorter;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;

public class PackageDRLAssembler
extends AssemblerBase {
    private StringBuilder src;

    public PackageDRLAssembler(PackageItem packageItem) {
        super(packageItem);
    }

    public String getDRL() {
        this.src = new StringBuilder();
        this.loadHeader();
        this.loadDSLFiles();
        this.loadFunctions();
        this.loadRuleAssets();
        return this.src.toString();
    }

    private void loadHeader() {
        this.src.append("package ").append(this.packageItem.getName()).append("\n");
        String packageHeader = DroolsHeader.getDroolsHeader((PackageItem)this.packageItem);
        this.src.append(DroolsHeader.getPackageHeaderImports((String)packageHeader));
        this.loadDeclaredTypes();
        this.src.append(DroolsHeader.getPackageHeaderGlobals((String)packageHeader));
        this.src.append(DroolsHeader.getPackageHeaderMiscellaneous((String)packageHeader));
    }

    private void loadDeclaredTypes() {
        ArrayList<AssetItem> assets = new ArrayList<AssetItem>();
        DeclaredTypesSorter sorter = new DeclaredTypesSorter();
        Iterator assetItemIterator = this.getAssetItemIterator(new String[]{"model.drl"});
        while (assetItemIterator.hasNext()) {
            AssetItem assetItem = (AssetItem)assetItemIterator.next();
            if (assetItem.isArchived() || assetItem.getDisabled()) continue;
            assets.add(assetItem);
        }
        List sortedAssets = sorter.sort(assets);
        for (DeclaredTypesSorter.DeclaredTypeAssetInheritanceInformation dt : sortedAssets) {
            this.src.append(dt.getDrl()).append("\n\n");
        }
    }

    private void loadFunctions() {
        Iterator assetItemIterator = this.getAssetItemIterator(new String[]{"function"});
        while (assetItemIterator.hasNext()) {
            this.addAsset((AssetItem)assetItemIterator.next());
        }
    }

    private void loadRuleAssets() {
        Iterator assetItemIterator = this.getAllAssets();
        while (assetItemIterator.hasNext()) {
            this.addRuleAsset((AssetItem)assetItemIterator.next());
        }
    }

    private void addRuleAsset(AssetItem asset) {
        if (!asset.isArchived() && !asset.getDisabled()) {
            ContentHandler handler = ContentManager.getHandler((String)asset.getFormat());
            if (handler.isRuleAsset()) {
                IRuleAsset ruleAsset = (IRuleAsset)handler;
                ruleAsset.assembleDRL(this.builder, asset, this.src);
            }
            this.src.append("\n\n");
        }
    }

    private void addAsset(AssetItem assetItem) {
        if (!assetItem.isArchived() && !assetItem.getDisabled()) {
            this.src.append(assetItem.getContent()).append("\n\n");
        }
    }
}

