/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.server.security.AdminType;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.security.PackageNameType;
import org.drools.guvnor.server.security.PackageUUIDType;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.security.WebDavPackageNameType;
import org.drools.guvnor.server.security.rules.CategoryPathTypePermissionRule;
import org.drools.guvnor.server.security.rules.PackageNameTypeConverter;
import org.drools.guvnor.server.security.rules.PackagePermissionRule;
import org.drools.guvnor.server.security.rules.PackageUUIDTypePermissionRule;
import org.drools.guvnor.server.security.rules.PermissionRule;
import org.drools.guvnor.server.security.rules.PermissionRuleObjectConverter;
import org.drools.guvnor.server.util.LoggingHelper;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.security.permission.PermissionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.security.roleBasedPermissionResolver")
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(precedence=20)
@Startup
public class RoleBasedPermissionResolver
implements PermissionResolver,
Serializable {
    private static final LoggingHelper log = LoggingHelper.getLogger(RoleBasedPermissionResolver.class);
    private boolean enableRoleBasedAuthorization = false;
    private final Map<Class<?>, PermissionRule> permissionRules = new HashMap();
    private final Map<Class<?>, PermissionRuleObjectConverter> permissionRuleObjectConverters = new HashMap();

    public RoleBasedPermissionResolver() {
        this.permissionRules.put(CategoryPathType.class, new CategoryPathTypePermissionRule());
        this.permissionRules.put(PackageUUIDType.class, new PackageUUIDTypePermissionRule());
        this.permissionRules.put(PackageNameType.class, new PackagePermissionRule());
        this.permissionRules.put(WebDavPackageNameType.class, new PackagePermissionRule());
        this.permissionRuleObjectConverters.put(PackageNameType.class, new PackageNameTypeConverter());
        this.permissionRuleObjectConverters.put(WebDavPackageNameType.class, new PackageNameTypeConverter());
    }

    @Create
    public void create() {
    }

    public boolean hasPermission(Object requestedObject, String requestedPermission) {
        if (this.isInvalidInstance(requestedObject)) {
            log.debug("Requested permission is not an instance of CategoryPathType|PackageNameType|WebDavPackageNameType|AdminType|PackageUUIDType");
            return false;
        }
        if (!this.enableRoleBasedAuthorization) {
            return true;
        }
        List permissions = this.fetchAllRoleBasedPermissionsForCurrentUser();
        if (this.hasAdminPermission(permissions) || RoleType.ADMIN.getName().equals(requestedPermission)) {
            return this.hasAdminPermission(permissions);
        }
        return this.getPermissionRuleFor(requestedObject).hasPermission(this.convertFor(requestedObject), requestedPermission, permissions);
    }

    private PermissionRule getPermissionRuleFor(Object requestedObject) {
        return (PermissionRule)this.permissionRules.get(requestedObject.getClass());
    }

    private Object convertFor(Object requestedObject) {
        PermissionRuleObjectConverter permissionRuleObjectConverter = (PermissionRuleObjectConverter)this.permissionRuleObjectConverters.get(requestedObject.getClass());
        return permissionRuleObjectConverter == null ? requestedObject : permissionRuleObjectConverter.convert(requestedObject);
    }

    private List<RoleBasedPermission> fetchAllRoleBasedPermissionsForCurrentUser() {
        return ((RoleBasedPermissionManager)Component.getInstance((String)"roleBasedPermissionManager")).getRoleBasedPermission();
    }

    private boolean isInvalidInstance(Object requestedObject) {
        return !(requestedObject instanceof CategoryPathType) && !(requestedObject instanceof PackageNameType) && !(requestedObject instanceof WebDavPackageNameType) && !(requestedObject instanceof AdminType) && !(requestedObject instanceof PackageUUIDType);
    }

    private boolean hasAdminPermission(List<RoleBasedPermission> permissions) {
        for (RoleBasedPermission p : permissions) {
            if (!RoleType.ADMIN.getName().equalsIgnoreCase(p.getRole())) continue;
            log.debug("Requested permission: unknown, Permission granted: Yes");
            return true;
        }
        log.debug("Requested permission: admin, Permission granted: No");
        return false;
    }

    public void filterSetByAction(Set<Object> targets, String action) {
    }

    public boolean isEnableRoleBasedAuthorization() {
        return this.enableRoleBasedAuthorization;
    }

    public void setEnableRoleBasedAuthorization(boolean enableRoleBasedAuthorization) {
        this.enableRoleBasedAuthorization = enableRoleBasedAuthorization;
    }
}

