/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.place.shared.PlaceHistoryHandler;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import com.google.gwt.user.client.Command;
import org.drools.guvnor.client.common.AssetEditorFactory;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.GuvnorActivityMapper;
import org.drools.guvnor.client.explorer.GuvnorPlaceHistoryMapper;
import org.drools.guvnor.client.explorer.ModuleEditorActivityView;
import org.drools.guvnor.client.explorer.ModuleEditorActivityViewImpl;
import org.drools.guvnor.client.explorer.MultiActivityManager;
import org.drools.guvnor.client.explorer.navigation.NavigationViewFactory;
import org.drools.guvnor.client.explorer.navigation.NavigationViewFactoryImpl;
import org.drools.guvnor.client.packages.AbstractModuleEditor;
import org.drools.guvnor.client.packages.PackageEditor;
import org.drools.guvnor.client.packages.SOAServiceEditor;
import org.drools.guvnor.client.perspectives.PerspectiveFactory;
import org.drools.guvnor.client.perspectives.PerspectivesPanelView;
import org.drools.guvnor.client.perspectives.PerspectivesPanelViewImpl;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.CategoryServiceAsync;
import org.drools.guvnor.client.rpc.ConfigurationService;
import org.drools.guvnor.client.rpc.ConfigurationServiceAsync;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.PackageServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.util.ActivityMapper;
import org.drools.guvnor.client.widgets.assetviewer.AssetViewerActivityView;
import org.drools.guvnor.client.widgets.assetviewer.AssetViewerActivityViewImpl;
import org.drools.guvnor.client.widgets.wizards.WizardFactory;
import org.drools.guvnor.client.widgets.wizards.WizardFactoryImpl;

public class ClientFactoryImpl
implements ClientFactory {
    private final PlaceController placeController;
    private PerspectivesPanelView perspectivesPanelView;
    private NavigationViewFactoryImpl navigationViewFactory;
    private AssetEditorFactory assetEditorFactory;
    private PerspectiveFactory perspectiveFactory;
    private PlaceHistoryHandler placeHistoryHandler;
    private GuvnorPlaceHistoryMapper guvnorPlaceHistoryMapper;
    private final EventBus eventBus;
    private WizardFactory wizardFactory;

    public ClientFactoryImpl(EventBus eventBus) {
        this.eventBus = eventBus;
        this.placeController = new PlaceController(eventBus);
    }

    public PlaceController getPlaceController() {
        return this.placeController;
    }

    public PerspectivesPanelView getPerspectivesPanelView() {
        if (this.perspectivesPanelView == null) {
            this.perspectivesPanelView = new PerspectivesPanelViewImpl((ClientFactory)this, this.eventBus);
        }
        return this.perspectivesPanelView;
    }

    public NavigationViewFactory getNavigationViewFactory() {
        if (this.navigationViewFactory == null) {
            this.navigationViewFactory = new NavigationViewFactoryImpl((ClientFactory)this, this.eventBus);
        }
        return this.navigationViewFactory;
    }

    public ConfigurationServiceAsync getConfigurationService() {
        return (ConfigurationServiceAsync)GWT.create(ConfigurationService.class);
    }

    public MultiActivityManager getActivityManager() {
        return new MultiActivityManager((ActivityMapper)this.getActivityMapper(), this.eventBus);
    }

    public GuvnorActivityMapper getActivityMapper() {
        return new GuvnorActivityMapper((ClientFactory)this);
    }

    public PlaceHistoryHandler getPlaceHistoryHandler() {
        if (this.placeHistoryHandler == null) {
            this.placeHistoryHandler = new PlaceHistoryHandler((PlaceHistoryMapper)this.getPlaceHistoryMapper());
        }
        return this.placeHistoryHandler;
    }

    public GuvnorPlaceHistoryMapper getPlaceHistoryMapper() {
        if (this.guvnorPlaceHistoryMapper == null) {
            this.guvnorPlaceHistoryMapper = (GuvnorPlaceHistoryMapper)GWT.create(GuvnorPlaceHistoryMapper.class);
        }
        return this.guvnorPlaceHistoryMapper;
    }

    public ModuleEditorActivityView getModuleEditorActivityView() {
        return new ModuleEditorActivityViewImpl();
    }

    public AssetViewerActivityView getAssetViewerActivityView() {
        return new AssetViewerActivityViewImpl();
    }

    public PackageServiceAsync getPackageService() {
        return RepositoryServiceFactory.getPackageService();
    }

    public AssetEditorFactory getAssetEditorFactory() {
        if (this.assetEditorFactory == null) {
            this.assetEditorFactory = (AssetEditorFactory)GWT.create(AssetEditorFactory.class);
        }
        return this.assetEditorFactory;
    }

    public PerspectiveFactory getPerspectiveFactory() {
        if (this.perspectiveFactory == null) {
            this.perspectiveFactory = (PerspectiveFactory)GWT.create(PerspectiveFactory.class);
        }
        return this.perspectiveFactory;
    }

    public RepositoryServiceAsync getRepositoryService() {
        return RepositoryServiceFactory.getService();
    }

    public CategoryServiceAsync getCategoryService() {
        return RepositoryServiceFactory.getCategoryService();
    }

    public AssetServiceAsync getAssetService() {
        return RepositoryServiceFactory.getAssetService();
    }

    public AbstractModuleEditor getModuleEditor(PackageConfigData packageConfigData, ClientFactory clientFactory, EventBus eventBus, boolean historicalReadOnly, Command refreshCommand) {
        if (packageConfigData.getFormat().equals("package")) {
            return new PackageEditor(packageConfigData, clientFactory, eventBus, historicalReadOnly, refreshCommand);
        }
        if (packageConfigData.getFormat().equals("soaservice")) {
            return new SOAServiceEditor(packageConfigData, clientFactory, eventBus, historicalReadOnly, refreshCommand);
        }
        return new PackageEditor(packageConfigData, clientFactory, eventBus, historicalReadOnly, refreshCommand);
    }

    public WizardFactory getWizardFactory() {
        if (this.wizardFactory == null) {
            this.wizardFactory = new WizardFactoryImpl((ClientFactory)this, this.eventBus);
        }
        return this.wizardFactory;
    }
}

