/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.DirtyableVerticalPane;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.CompositeFactPatternWidget;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;

public class CompositeFactPatternWidget
extends RuleModellerWidget {
    protected final SuggestionCompletionEngine completions;
    protected Constants constants = (Constants)GWT.create(Constants.class);
    protected DirtyableFlexTable layout;
    protected CompositeFactPattern pattern;
    protected boolean readOnly;
    protected boolean isFactTypeKnown;

    public CompositeFactPatternWidget(RuleModeller modeller, CompositeFactPattern pattern) {
        this(modeller, pattern, null);
    }

    public CompositeFactPatternWidget(RuleModeller modeller, CompositeFactPattern pattern, Boolean readOnly) {
        super(modeller);
        this.completions = modeller.getSuggestionCompletions();
        this.pattern = pattern;
        this.layout = new DirtyableFlexTable();
        this.layout.setStyleName("model-builderInner-Background");
        if (readOnly != null) {
            this.readOnly = readOnly;
            this.isFactTypeKnown = true;
        } else {
            this.readOnly = false;
            this.isFactTypeKnown = true;
            if (this.pattern != null && this.pattern.getPatterns() != null) {
                IFactPattern[] patterns = this.pattern.getPatterns();
                for (int i = 0; i < patterns.length; ++i) {
                    IFactPattern p = patterns[i];
                    if (p.getFactType() == null || this.completions.containsFactType(p.getFactType())) continue;
                    this.readOnly = true;
                    this.isFactTypeKnown = false;
                    break;
                }
            }
        }
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isFactTypeKnown() {
        return this.isFactTypeKnown;
    }

    private HTML spacerWidget() {
        HTML h = new HTML("&nbsp;");
        h.setHeight("2px");
        return h;
    }

    private Widget wrapLHSWidget(CompositeFactPattern model, int i, RuleModellerWidget w) {
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        Image remove = GuvnorImages.INSTANCE.DeleteItemSmall();
        remove.setTitle(this.constants.RemoveThisENTIREConditionAndAllTheFieldConstraintsThatBelongToIt());
        int idx = i;
        remove.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        horiz.setWidth("100%");
        w.setWidth("100%");
        horiz.add((Widget)w);
        if (!this.getModeller().lockLHS() && !w.isReadOnly()) {
            horiz.add((Widget)remove);
        }
        return horiz;
    }

    protected void doLayout() {
        this.layout.setWidget(0, 0, this.getCompositeLabel());
        this.layout.getFlexCellFormatter().setColSpan(0, 0, 2);
        this.layout.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        if (this.pattern.getPatterns() != null) {
            DirtyableVerticalPane vert = new DirtyableVerticalPane();
            IFactPattern[] facts = this.pattern.getPatterns();
            for (int i = 0; i < facts.length; ++i) {
                RuleModellerWidget widget = this.getModeller().getWidgetFactory().getWidget(this.getModeller(), (IPattern)facts[i], Boolean.valueOf(this.readOnly));
                widget.addOnModifiedCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
                vert.add(this.wrapLHSWidget(this.pattern, i, widget));
                vert.add((Widget)this.spacerWidget());
            }
            this.layout.setWidget(1, 1, (Widget)vert);
        }
    }

    protected Widget getCompositeLabel() {
        3 click = new /* Unavailable Anonymous Inner Class!! */;
        String lbl = HumanReadable.getCEDisplayName((String)this.pattern.type);
        if (this.pattern.getPatterns() == null || this.pattern.getPatterns().length == 0) {
            lbl = lbl + " <font color='red'>" + this.constants.clickToAddPatterns() + "</font>";
        }
        return new ClickableLabel(lbl + ":", (ClickHandler)click, !this.readOnly);
    }

    protected void showFactTypeSelector(Widget w) {
        ListBox box = new ListBox();
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        String[] facts = completions.getFactTypes();
        box.addItem(this.constants.Choose());
        for (int i = 0; i < facts.length; ++i) {
            box.addItem(facts[i]);
        }
        box.setSelectedIndex(0);
        FormStylePopup popup = new FormStylePopup();
        popup.setTitle(this.constants.NewFactPattern());
        popup.addAttribute(this.constants.chooseFactType(), (Widget)box);
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Button fromBtn = new Button(this.constants.From());
        Button fromAccumulateBtn = new Button(this.constants.FromAccumulate());
        Button fromCollectBtn = new Button(this.constants.FromCollect());
        5 btnsClickHandler = new /* Unavailable Anonymous Inner Class!! */;
        fromBtn.addClickHandler((ClickHandler)btnsClickHandler);
        fromAccumulateBtn.addClickHandler((ClickHandler)btnsClickHandler);
        fromCollectBtn.addClickHandler((ClickHandler)btnsClickHandler);
        popup.addAttribute("", (Widget)fromBtn);
        popup.addAttribute("", (Widget)fromAccumulateBtn);
        popup.addAttribute("", (Widget)fromCollectBtn);
        popup.show();
    }
}

