/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.EnumDropDown;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;

public class EnumDropDownLabel
extends Composite {
    protected Constants constants = (Constants)GWT.create(Constants.class);
    protected final Label textWidget;
    protected final EnumDropDown enumDropDown;
    protected final Button okButton;
    protected final Panel panel = new HorizontalPanel();
    protected final PopupPanel popup;
    protected Command onValueChangeCommand;
    private String factType;
    private CompositeFieldConstraint constraintList;
    protected SuggestionCompletionEngine sce;
    protected BaseSingleFieldConstraint constraint;
    protected boolean enabled;

    public EnumDropDownLabel(String factType, CompositeFieldConstraint constraintList, SuggestionCompletionEngine sce, BaseSingleFieldConstraint constraint, boolean enabled) {
        this.factType = factType;
        this.constraintList = constraintList;
        this.constraint = constraint;
        this.sce = sce;
        this.enabled = enabled;
        this.textWidget = this.createTextLabel();
        this.enumDropDown = this.createEnumDropDown();
        this.okButton = new Button(this.constants.OK());
        this.panel.add((Widget)this.textWidget);
        this.updateTextWidget();
        this.updateModel();
        this.popup = this.createPopup();
        this.initWidget((Widget)this.panel);
    }

    private void showPopup() {
        this.popup.setPopupPosition(this.getAbsoluteLeft(), this.getAbsoluteTop());
        this.enumDropDown.setDropDownData(this.constraint.getValue(), this.getDropDownData());
        this.popup.show();
    }

    private DropDownData getDropDownData() {
        String valueType;
        String fieldName;
        if (this.constraint instanceof SingleFieldConstraintEBLeftSide) {
            SingleFieldConstraintEBLeftSide sfexp = (SingleFieldConstraintEBLeftSide)this.constraint;
            fieldName = sfexp.getExpressionLeftSide().getFieldName();
            valueType = sfexp.getExpressionLeftSide().getGenericType();
        } else if (this.constraint instanceof ConnectiveConstraint) {
            ConnectiveConstraint cc = (ConnectiveConstraint)this.constraint;
            fieldName = cc.getFieldName();
            valueType = cc.getFieldType();
        } else if (this.constraint instanceof SingleFieldConstraint) {
            SingleFieldConstraint sfc = (SingleFieldConstraint)this.constraint;
            fieldName = sfc.getFieldName();
            valueType = this.sce.getFieldType(this.factType, fieldName);
        } else {
            throw new IllegalArgumentException("That should not have happened!");
        }
        DropDownData dropDownData = "Boolean".equals(valueType) ? DropDownData.create((String[])new String[]{"true", "false"}) : this.sce.getEnums(this.factType, this.constraintList, fieldName);
        return dropDownData;
    }

    private EnumDropDown createEnumDropDown() {
        EnumDropDown box = new EnumDropDown(this.constraint.getValue(), (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, this.getDropDownData());
        if (box.getItemCount() > 6) {
            box.setVisibleItemCount(6);
        } else {
            box.setVisibleItemCount(box.getItemCount());
        }
        box.setEnabled(this.enabled);
        return box;
    }

    private Label createTextLabel() {
        String currentValue = this.constraint.getValue();
        Label label = new Label(currentValue == null ? "" : currentValue);
        label.setStyleName("form-field");
        if (this.enabled) {
            label.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return label;
    }

    private PopupPanel createPopup() {
        PopupPanel popup = new PopupPanel();
        popup.setGlassEnabled(true);
        this.okButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.add((Widget)this.enumDropDown);
        horizontalPanel.add((Widget)this.okButton);
        popup.add((Widget)horizontalPanel);
        return popup;
    }

    private void executeOnValueChangeCommand() {
        if (this.onValueChangeCommand != null) {
            this.onValueChangeCommand.execute();
        }
    }

    public void setOnValueChangeCommand(Command onValueChangeCommand) {
        this.onValueChangeCommand = onValueChangeCommand;
    }

    public void refreshDropDownData() {
        this.enumDropDown.setDropDownData(this.constraint.getValue(), this.getDropDownData());
        this.updateTextWidget();
        this.updateModel();
    }

    private void updateTextWidget() {
        int index = this.enumDropDown.getSelectedIndex();
        if (index >= 0) {
            this.textWidget.setText(this.enumDropDown.getItemText(index));
        }
    }

    private void updateModel() {
        int index = this.enumDropDown.getSelectedIndex();
        if (index >= 0) {
            this.constraint.setValue(this.enumDropDown.getValue(index));
        }
    }

    static /* synthetic */ void access$000(EnumDropDownLabel x0) {
        x0.showPopup();
    }

    static /* synthetic */ void access$100(EnumDropDownLabel x0) {
        x0.executeOnValueChangeCommand();
    }
}

