/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.configurations.UserCapabilities;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.Artifact;
import org.drools.guvnor.client.rpc.DiscussionRecord;
import org.drools.guvnor.client.rpc.PushClient;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.ServerPushNotification;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;
import org.drools.guvnor.client.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscussionWidget
extends Composite {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private VerticalPanel commentList = new VerticalPanel();
    private VerticalPanel newCommentLayout = new VerticalPanel();
    private Artifact artifact;
    private ServerPushNotification pushNotify;
    private int lastCount = 0;
    private boolean readOnly;

    protected void onUnload() {
        super.onUnload();
        PushClient.instance().unsubscribe(this.pushNotify);
    }

    public DiscussionWidget(Artifact artifact, boolean readOnly) {
        this.artifact = artifact;
        this.readOnly = readOnly;
        DecoratedDisclosurePanel discussionPanel = new DecoratedDisclosurePanel(constants.Discussion());
        discussionPanel.setWidth("100%");
        this.commentList.setWidth("100%");
        VerticalPanel discussionLayout = new VerticalPanel();
        discussionLayout.setWidth("90%");
        discussionLayout.add((Widget)this.commentList);
        this.newCommentLayout.setWidth("100%");
        this.refreshDiscussion();
        discussionLayout.add((Widget)this.newCommentLayout);
        this.showNewCommentButton();
        discussionPanel.setContent((Widget)discussionLayout);
        this.pushNotify = new /* Unavailable Anonymous Inner Class!! */;
        PushClient.instance().subscribe(this.pushNotify);
        this.initWidget((Widget)discussionPanel);
    }

    public void refreshDiscussion() {
        RepositoryServiceFactory.getAssetService().loadDiscussionForAsset(this.artifact.getUuid(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateCommentList(List<DiscussionRecord> ls) {
        if (ls.size() == this.lastCount) {
            return;
        }
        this.commentList.clear();
        for (DiscussionRecord dr : ls) {
            this.appendComment(dr);
        }
        this.lastCount = ls.size();
    }

    private Widget appendComment(DiscussionRecord r) {
        SmallLabel hrd = new SmallLabel(constants.smallCommentBy0On1Small(r.author, new Date(r.timestamp)));
        hrd.addStyleName("discussion-header");
        this.commentList.add((Widget)hrd);
        String[] parts = r.note.split("\n");
        if (parts.length > 0) {
            StringBuilder txtBuilder = new StringBuilder();
            for (int i = 0; i < parts.length; ++i) {
                txtBuilder.append(parts[i]);
                if (i == parts.length - 1) continue;
                txtBuilder.append("<br/>");
            }
            HTML hth = new HTML(txtBuilder.toString());
            hth.setStyleName("form-field");
            this.commentList.add((Widget)hth);
        } else {
            Label lbl = new Label(r.note);
            lbl.setStyleName("form-field");
            this.commentList.add((Widget)lbl);
        }
        this.commentList.add((Widget)new HTML("<br/>"));
        return hrd;
    }

    private void showNewCommentButton() {
        this.newCommentLayout.clear();
        HorizontalPanel hp = new HorizontalPanel();
        Button createNewComment = new Button(constants.AddADiscussionComment());
        createNewComment.setEnabled(!this.readOnly);
        hp.add((Widget)createNewComment);
        if (UserCapabilities.INSTANCE.hasCapability(new Capability[]{Capability.SHOW_ADMIN})) {
            Button adminClearAll = new Button(constants.EraseAllComments());
            adminClearAll.setEnabled(!this.readOnly);
            hp.add((Widget)adminClearAll);
            adminClearAll.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        String feedURL = GWT.getModuleBaseURL() + "feed/discussion?package=" + ((RuleAsset)this.artifact).getMetaData().getPackageName() + "&assetName=" + URL.encode((String)this.artifact.getName()) + "&viewUrl=" + Util.getSelfURL();
        Image image = GuvnorImages.INSTANCE.Feed();
        image.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        hp.add((Widget)image);
        this.newCommentLayout.add((Widget)hp);
        this.newCommentLayout.setCellHorizontalAlignment((Widget)hp, HasHorizontalAlignment.ALIGN_RIGHT);
        createNewComment.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showAddNewComment() {
        this.newCommentLayout.clear();
        TextArea comment = new TextArea();
        comment.setWidth("100%");
        this.newCommentLayout.add((Widget)comment);
        Button ok = new Button(constants.OK());
        Button cancel = new Button(constants.Cancel());
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        cancel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)ok);
        hp.add((Widget)cancel);
        this.newCommentLayout.add((Widget)hp);
        comment.setFocus(true);
    }

    private void sendNewComment(String text) {
        this.newCommentLayout.clear();
        this.newCommentLayout.add((Widget)new Image(images.spinner()));
        RepositoryServiceFactory.getAssetService().addToDiscussionForAsset(this.artifact.getUuid(), text, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$000(DiscussionWidget x0, List x1) {
        x0.updateCommentList(x1);
    }

    static /* synthetic */ Constants access$100() {
        return constants;
    }

    static /* synthetic */ Artifact access$200(DiscussionWidget x0) {
        return x0.artifact;
    }

    static /* synthetic */ void access$300(DiscussionWidget x0) {
        x0.showAddNewComment();
    }

    static /* synthetic */ void access$400(DiscussionWidget x0, String x1) {
        x0.sendNewComment(x1);
    }

    static /* synthetic */ void access$500(DiscussionWidget x0) {
        x0.showNewCommentButton();
    }
}

