/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.cellview.client.AbstractPager;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.Range;
import org.drools.guvnor.client.widgets.tables.GuvnorSimplePager;

/*
 * Exception performing whole class analysis ignored.
 */
public class GuvnorSimplePager
extends AbstractPager {
    private static int DEFAULT_FAST_FORWARD_ROWS = 1000;
    private static Resources DEFAULT_RESOURCES;
    private final ImageButton fastForward;
    private final int fastForwardRows;
    private final ImageButton firstPage;
    private final HTML label = new HTML();
    private final ImageButton lastPage;
    private final ImageButton nextPage;
    private final ImageButton prevPage;
    private final Resources resources;
    private final Style style;
    private int pageSize = 10;

    private static Resources getDefaultResources() {
        if (DEFAULT_RESOURCES == null) {
            DEFAULT_RESOURCES = (Resources)GWT.create(Resources.class);
        }
        return DEFAULT_RESOURCES;
    }

    public GuvnorSimplePager() {
        this(TextLocation.CENTER);
    }

    public GuvnorSimplePager(TextLocation location) {
        this(location, GuvnorSimplePager.getDefaultResources(), true, DEFAULT_FAST_FORWARD_ROWS, false);
    }

    public GuvnorSimplePager(TextLocation location, Resources resources, boolean showFastForwardButton, int fastForwardRows, boolean showLastPageButton) {
        this.resources = resources;
        this.fastForwardRows = fastForwardRows;
        this.style = resources.simplePagerStyle();
        this.style.ensureInjected();
        String disabledStyle = this.style.disabledButton();
        this.firstPage = new ImageButton(resources.simplePagerFirstPage(), resources.simplePagerFirstPageDisabled(), disabledStyle);
        this.firstPage.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.nextPage = new ImageButton(resources.simplePagerNextPage(), resources.simplePagerNextPageDisabled(), disabledStyle);
        this.nextPage.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.prevPage = new ImageButton(resources.simplePagerPreviousPage(), resources.simplePagerPreviousPageDisabled(), disabledStyle);
        this.prevPage.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (showLastPageButton) {
            this.lastPage = new ImageButton(resources.simplePagerLastPage(), resources.simplePagerLastPageDisabled(), disabledStyle);
            this.lastPage.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.lastPage = null;
        }
        if (showFastForwardButton) {
            this.fastForward = new ImageButton(resources.simplePagerFastForward(), resources.simplePagerFastForwardDisabled(), disabledStyle);
            this.fastForward.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.fastForward = null;
        }
        HorizontalPanel layout = new HorizontalPanel();
        layout.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.initWidget((Widget)layout);
        if (location == TextLocation.RIGHT) {
            layout.add((Widget)this.label);
        }
        layout.add((Widget)this.firstPage);
        layout.add((Widget)this.prevPage);
        if (location == TextLocation.CENTER) {
            layout.add((Widget)this.label);
        }
        layout.add((Widget)this.nextPage);
        if (showFastForwardButton) {
            layout.add((Widget)this.fastForward);
        }
        if (showLastPageButton) {
            layout.add((Widget)this.lastPage);
        }
        if (location == TextLocation.LEFT) {
            layout.add((Widget)this.label);
        }
        this.firstPage.getElement().getParentElement().addClassName(this.style.button());
        this.prevPage.getElement().getParentElement().addClassName(this.style.button());
        this.label.getElement().getParentElement().addClassName(this.style.pageDetails());
        this.nextPage.getElement().getParentElement().addClassName(this.style.button());
        if (showFastForwardButton) {
            this.fastForward.getElement().getParentElement().addClassName(this.style.button());
        }
        if (showLastPageButton) {
            this.lastPage.getElement().getParentElement().addClassName(this.style.button());
        }
        this.setDisplay(null);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void nextPage() {
        if (this.getDisplay() != null) {
            Range range = this.getDisplay().getVisibleRange();
            this.setPageStart(range.getStart() + this.getPageSize());
        }
    }

    public void previousPage() {
        if (this.getDisplay() != null) {
            Range range = this.getDisplay().getVisibleRange();
            this.setPageStart(range.getStart() - this.getPageSize());
        }
    }

    public void setDisplay(HasRows display) {
        boolean disableButtons = display == null;
        this.setFastForwardDisabled(disableButtons);
        this.setNextPageButtonsDisabled(disableButtons);
        this.setPrevPageButtonsDisabled(disableButtons);
        super.setDisplay(display);
    }

    public void setPage(int index) {
        super.setPage(index);
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        super.setPageSize(pageSize);
    }

    public void setPageStart(int index) {
        if (this.getDisplay() != null) {
            Range range = this.getDisplay().getVisibleRange();
            int displayPageSize = this.getPageSize();
            if (this.isRangeLimited() && this.getDisplay().isRowCountExact()) {
                displayPageSize = Math.min(this.getPageSize(), this.getDisplay().getRowCount() - index);
            }
            if ((index = Math.max(0, index)) != range.getStart()) {
                this.getDisplay().setVisibleRange(index, displayPageSize);
            }
        }
    }

    public void startLoading() {
        this.getDisplay().setRowCount(0, true);
        this.label.setHTML("");
    }

    private int getFastForwardPages() {
        int pageSize = this.getPageSize();
        return pageSize > 0 ? this.fastForwardRows / pageSize : 0;
    }

    private void setFastForwardDisabled(boolean disabled) {
        if (this.fastForward == null) {
            return;
        }
        if (disabled) {
            this.fastForward.setResource(this.resources.simplePagerFastForwardDisabled());
            this.fastForward.getElement().getParentElement().addClassName(this.style.disabledButton());
        } else {
            this.fastForward.setResource(this.resources.simplePagerFastForward());
            this.fastForward.getElement().getParentElement().removeClassName(this.style.disabledButton());
        }
        this.fastForward.setDisabled(disabled);
    }

    private void setNextPageButtonsDisabled(boolean disabled) {
        this.nextPage.setDisabled(disabled);
        if (this.lastPage != null) {
            this.lastPage.setDisabled(disabled);
        }
    }

    private void setPrevPageButtonsDisabled(boolean disabled) {
        this.firstPage.setDisabled(disabled);
        this.prevPage.setDisabled(disabled);
    }

    protected String createText() {
        NumberFormat formatter = NumberFormat.getFormat((String)"#,###");
        HasRows display = this.getDisplay();
        Range range = display.getVisibleRange();
        int pageStart = range.getStart() + 1;
        int pageSize = range.getLength();
        int dataSize = display.getRowCount();
        int endIndex = Math.min(dataSize, pageStart + pageSize - 1);
        endIndex = Math.max(pageStart, endIndex);
        boolean exact = display.isRowCountExact();
        if (dataSize == 0) {
            return "0 of 0";
        }
        if (pageStart == endIndex) {
            return formatter.format((double)pageStart) + " of " + formatter.format((double)dataSize);
        }
        return formatter.format((double)pageStart) + "-" + formatter.format((double)endIndex) + (exact ? " of " : " of over ") + formatter.format((double)dataSize);
    }

    protected void onRangeOrRowCountChanged() {
        HasRows display = this.getDisplay();
        this.label.setText(this.createText());
        this.setPrevPageButtonsDisabled(!this.hasPreviousPage());
        if (this.isRangeLimited() || !display.isRowCountExact()) {
            this.setNextPageButtonsDisabled(!this.hasNextPage());
            this.setFastForwardDisabled(!this.hasNextPages(this.getFastForwardPages()));
        }
    }

    boolean isNextButtonDisabled() {
        return this.nextPage.isDisabled();
    }

    boolean isPreviousButtonDisabled() {
        return this.prevPage.isDisabled();
    }

    static /* synthetic */ void access$000(GuvnorSimplePager x0) {
        x0.firstPage();
    }

    static /* synthetic */ void access$100(GuvnorSimplePager x0) {
        x0.lastPage();
    }

    static /* synthetic */ int access$200(GuvnorSimplePager x0) {
        return x0.getPage();
    }

    static /* synthetic */ int access$300(GuvnorSimplePager x0) {
        return x0.getFastForwardPages();
    }
}

