/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.Set;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.VerificationService;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryServiceServlet;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.verification.AssetVerifier;
import org.drools.guvnor.server.verification.PackageVerifier;
import org.drools.guvnor.server.verification.VerifierConfigurationFactory;
import org.drools.repository.AssetItem;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.security.Restrict;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerificationServiceImplementation
extends RemoteServiceServlet
implements VerificationService {
    private static final long serialVersionUID = 510L;
    private static final LoggingHelper log = LoggingHelper.getLogger(ServiceImplementation.class);
    private final Verifier defaultVerifier = VerifierBuilderFactory.newVerifierBuilder().newVerifier();
    private final ServiceSecurity serviceSecurity = new ServiceSecurity();

    protected RepositoryAssetService getAssetService() {
        return RepositoryServiceServlet.getAssetService();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public AnalysisReport analysePackage(String packageUUID) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(packageUUID);
        AnalysisReport report = new PackageVerifier(this.defaultVerifier, this.getAssetService().getRulesRepository().loadPackageByUUID(packageUUID)).verify();
        this.defaultVerifier.flushKnowledgeSession();
        return report;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public AnalysisReport verifyAsset(RuleAsset asset, Set<String> activeWorkingSetIds) throws SerializationException {
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        return this.verify(asset, VerifierConfigurationFactory.getDefaultConfigurationWithWorkingSetConstraints((RuleAsset[])this.loadWorkingSets(activeWorkingSetIds)));
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public AnalysisReport verifyAssetWithoutVerifiersRules(RuleAsset asset, Set<String> activeWorkingIds) throws SerializationException {
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        return this.verify(asset, VerifierConfigurationFactory.getPlainWorkingSetVerifierConfiguration((RuleAsset[])this.loadWorkingSets(activeWorkingIds)));
    }

    private RuleAsset[] loadWorkingSets(Set<String> activeWorkingSets) throws SerializationException {
        if (activeWorkingSets == null) {
            return new RuleAsset[0];
        }
        return this.getAssetService().loadRuleAssets(activeWorkingSets.toArray(new String[activeWorkingSets.size()]));
    }

    private AnalysisReport verify(RuleAsset asset, VerifierConfiguration verifierConfiguration) throws SerializationException {
        long startTime = System.currentTimeMillis();
        AnalysisReport report = this.getAssetVerifier(verifierConfiguration, this.getAssetItem(asset)).verify();
        log.debug("Asset verification took: " + (System.currentTimeMillis() - startTime));
        return report;
    }

    private AssetItem getAssetItem(RuleAsset asset) throws SerializationException {
        AssetItem assetItem = this.getAssetService().getRulesRepository().loadAssetByUUID(asset.getUuid());
        ContentHandler contentHandler = ContentManager.getHandler((String)asset.getFormat());
        contentHandler.storeAssetContent(asset, assetItem);
        return assetItem;
    }

    private AssetVerifier getAssetVerifier(VerifierConfiguration verifierConfiguration, AssetItem assetItem) throws SerializationException {
        return new AssetVerifier(VerifierBuilderFactory.newVerifierBuilder().newVerifier(verifierConfiguration), assetItem);
    }
}

