/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.guvnor.server.builder.DeclaredTypesSorter;
import org.drools.repository.AssetItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaredTypesSorter {
    private static final Pattern typeFinder = Pattern.compile("(declare\\s+((\\w+)).*?\\s+end+?)", 42);
    private static final Pattern superTypeFinder = Pattern.compile("(extends\\s+((\\w+)))", 42);

    public List<DeclaredTypeAssetInheritanceInformation> sort(List<AssetItem> assets) {
        ArrayList<DeclaredTypeAssetInheritanceInformation> sortedTypes = new ArrayList<DeclaredTypeAssetInheritanceInformation>();
        for (AssetItem assetItem : assets) {
            List individualTypes = this.parseIndividualTypes(assetItem.getContent());
            for (DeclaredTypeInheritanceInformation individualType : individualTypes) {
                sortedTypes.add(new DeclaredTypeAssetInheritanceInformation(assetItem, individualType.getType(), individualType.getSuperType(), individualType.getDrl(), null));
            }
        }
        HashMap<String, DeclaredTypeAssetInheritanceInformation> lookup = new HashMap<String, DeclaredTypeAssetInheritanceInformation>();
        for (DeclaredTypeAssetInheritanceInformation type : sortedTypes) {
            lookup.put(type.getType(), type);
        }
        for (DeclaredTypeAssetInheritanceInformation type : sortedTypes) {
            String superType = type.getSuperType();
            while (superType != null) {
                type.increaseDependencyScore();
                if (!lookup.containsKey(superType)) continue;
                superType = ((DeclaredTypeAssetInheritanceInformation)lookup.get(superType)).getSuperType();
            }
        }
        Collections.sort(sortedTypes, new /* Unavailable Anonymous Inner Class!! */);
        return sortedTypes;
    }

    List<DeclaredTypeInheritanceInformation> parseIndividualTypes(String typesDrl) {
        ArrayList<DeclaredTypeInheritanceInformation> individualTypes = new ArrayList<DeclaredTypeInheritanceInformation>();
        Matcher tm = typeFinder.matcher(typesDrl);
        while (tm.find()) {
            String type = tm.group(2);
            String typeDrl = tm.group(1);
            String superType = this.getSuperType(typeDrl);
            individualTypes.add(new DeclaredTypeInheritanceInformation(type, superType, typeDrl, null));
        }
        return individualTypes;
    }

    private String getSuperType(String typeDrl) {
        Matcher stm = superTypeFinder.matcher(typeDrl);
        if (stm.find()) {
            return stm.group(2);
        }
        return null;
    }
}

