/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.rpc.LogEntry;
import org.drools.guvnor.client.rpc.LogPageRow;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.server.builder.pagerow.PageRowBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogPageRowBuilder
implements PageRowBuilder<PageRequest, LogEntry[]> {
    private PageRequest pageRequest;
    private LogEntry[] logEntries;

    public List<LogPageRow> build() {
        this.validate();
        int rowNumber = 0;
        int rowMinNumber = this.pageRequest.getStartRowIndex();
        int rowMaxNumber = this.pageRequest.getPageSize() == null ? this.logEntries.length : Math.min(rowMinNumber + this.pageRequest.getPageSize(), this.logEntries.length);
        int resultsSize = this.pageRequest.getPageSize() == null ? this.logEntries.length : this.pageRequest.getPageSize();
        ArrayList<LogPageRow> rowList = new ArrayList<LogPageRow>(resultsSize);
        for (rowNumber = rowMinNumber; rowNumber < rowMaxNumber; ++rowNumber) {
            LogEntry e = this.logEntries[rowNumber];
            LogPageRow row = new LogPageRow();
            row.setSeverity(e.severity);
            row.setMessage(e.message);
            row.setTimestamp(e.timestamp);
            rowList.add(row);
        }
        return rowList;
    }

    public LogPageRowBuilder withPageRequest(PageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public LogPageRowBuilder withContent(LogEntry[] logEntries) {
        this.logEntries = logEntries;
        return this;
    }

    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.logEntries == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }
}

