/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.jaxrs;

import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Link;
import org.drools.guvnor.server.jaxrs.jaxb.Asset;
import org.drools.guvnor.server.jaxrs.jaxb.AssetMetadata;
import org.drools.guvnor.server.jaxrs.jaxb.Category;
import org.drools.guvnor.server.jaxrs.jaxb.Package;
import org.drools.guvnor.server.jaxrs.jaxb.PackageMetadata;
import org.drools.repository.AssetItem;
import org.drools.repository.CategoryItem;
import org.drools.repository.PackageItem;

/*
 * Exception performing whole class analysis ignored.
 */
public class Translator {
    public static final String NS = "";
    public static final QName METADATA = new QName("", "metadata");
    public static final QName VALUE = new QName("", "value");
    public static final QName ARCHIVED = new QName("", "archived");
    public static final QName UUID = new QName("", "uuid");
    public static final QName STATE = new QName("", "state");
    public static final QName FORMAT = new QName("", "format");
    public static final QName CATEGORIES = new QName("", "categories");
    public static final QName VERSION_NUMBER = new QName("", "versionNumber");
    public static final QName CHECKIN_COMMENT = new QName("", "checkinComment");

    public static Category toCategory(CategoryItem categoryItem, UriInfo uriInfo) {
        Category category = new Category();
        category.setPath(categoryItem.getFullPath());
        category.setRefLink(uriInfo.getBaseUriBuilder().path("/categories/{categoryPath}").build(new Object[]{categoryItem.getFullPath()}));
        return category;
    }

    public static Asset toAsset(AssetItem a, UriInfo uriInfo) {
        AssetMetadata metadata = new AssetMetadata();
        metadata.setUuid(a.getUUID());
        metadata.setTitle(a.getTitle());
        metadata.setLastModified(a.getLastModified().getTime());
        metadata.setCreated(a.getCreatedDate().getTime());
        metadata.setCreatedBy(a.getCreator());
        metadata.setDisabled(a.getDisabled());
        metadata.setFormat(a.getFormat());
        metadata.setBinaryContentAttachmentFileName(a.getBinaryContentAttachmentFileName());
        metadata.setNote("<![CDATA[ " + a.getCheckinComment() + " ]]>");
        List categories = a.getCategories();
        String[] cats = new String[categories.size()];
        int counter = 0;
        for (CategoryItem c : categories) {
            cats[counter++] = c.getName();
        }
        Asset ret = new Asset();
        ret.setMetadata(metadata);
        ret.setType(a.getType());
        ret.setCheckInComment(a.getCheckinComment());
        ret.setDescription(a.getDescription());
        ret.setRefLink(uriInfo.getBaseUriBuilder().path("/packages/{packageName}/assets/{assetName}").build(new Object[]{a.getPackage().getName(), a.getName()}));
        ret.setBinaryLink(uriInfo.getBaseUriBuilder().path("/packages/{packageName}/assets/{assetName}/binary").build(new Object[]{a.getPackage().getName(), a.getName()}));
        ret.setSourceLink(uriInfo.getBaseUriBuilder().path("/packages/{packageName}/assets/{assetName}/source").build(new Object[]{a.getPackage().getName(), a.getName()}));
        ret.setVersion(a.getVersionNumber());
        return ret;
    }

    public static Package toPackage(PackageItem p, UriInfo uriInfo) {
        PackageMetadata metadata = new PackageMetadata();
        metadata.setUuid(p.getUUID());
        metadata.setCreated(p.getCreatedDate().getTime());
        metadata.setLastModified(p.getLastModified().getTime());
        metadata.setLastContributor(p.getLastContributor());
        metadata.setState(p.getState() != null ? p.getState().getName() : "");
        metadata.setArchived(p.isArchived());
        Package ret = new Package();
        ret.setMetadata(metadata);
        ret.setVersion(p.getVersionNumber());
        ret.setTitle(p.getTitle());
        ret.setCheckInComment(p.getCheckinComment());
        ret.setDescription(p.getDescription());
        ret.setBinaryLink(uriInfo.getBaseUriBuilder().path("/packages/{packageName}/binary").build(new Object[]{p.getName()}));
        ret.setSourceLink(uriInfo.getBaseUriBuilder().path("/packages/{packageName}/source").build(new Object[]{p.getName()}));
        ret.setVersion(p.getVersionNumber());
        Iterator iter = p.getAssets();
        HashSet<URI> assets = new HashSet<URI>();
        while (iter.hasNext()) {
            AssetItem a = (AssetItem)iter.next();
            Asset asset = Translator.toAsset((AssetItem)a, (UriInfo)uriInfo);
            assets.add(asset.getRefLink());
        }
        ret.setAssets(assets);
        return ret;
    }

    public static Entry toPackageEntryAbdera(PackageItem p, UriInfo uriInfo) {
        URI baseURL = p.isHistoricalVersion() ? uriInfo.getBaseUriBuilder().path("packages/{packageName}/versions/{version}").build(new Object[]{p.getName(), Long.toString(p.getVersionNumber())}) : uriInfo.getBaseUriBuilder().path("packages/{packageName}").build(new Object[]{p.getName()});
        Factory factory = Abdera.getNewFactory();
        Entry e = factory.getAbdera().newEntry();
        e.setTitle(p.getTitle());
        e.setSummary(p.getDescription());
        e.setPublished(new Date(p.getLastModified().getTimeInMillis()));
        e.setBaseUri(baseURL.toString());
        e.addAuthor(p.getLastContributor());
        e.setId(baseURL.toString());
        Iterator i = p.getAssets();
        while (i.hasNext()) {
            AssetItem item = (AssetItem)i.next();
            Link l = factory.newLink();
            l.setHref(UriBuilder.fromUri((URI)baseURL).path("assets/{assetName}").build(new Object[]{item.getName()}).toString());
            l.setTitle(item.getTitle());
            l.setRel("asset");
            e.addLink(l);
        }
        ExtensibleElement extension = (ExtensibleElement)e.addExtension(METADATA);
        ExtensibleElement childExtension = (ExtensibleElement)extension.addExtension(ARCHIVED);
        childExtension.addSimpleExtension(VALUE, p.isArchived() ? "true" : "false");
        childExtension = (ExtensibleElement)extension.addExtension(UUID);
        childExtension.addSimpleExtension(VALUE, p.getUUID());
        childExtension = (ExtensibleElement)extension.addExtension(STATE);
        childExtension.addSimpleExtension(VALUE, p.getState() == null ? "" : p.getState().getName());
        childExtension = (ExtensibleElement)extension.addExtension(VERSION_NUMBER);
        childExtension.addSimpleExtension(VALUE, String.valueOf(p.getVersionNumber()));
        childExtension = (ExtensibleElement)extension.addExtension(CHECKIN_COMMENT);
        childExtension.addSimpleExtension(VALUE, p.getCheckinComment());
        Content content = factory.newContent();
        content.setSrc(UriBuilder.fromUri((URI)baseURL).path("binary").build(new Object[0]).toString());
        content.setMimeType("application/octet-stream");
        content.setContentType(Content.Type.MEDIA);
        e.setContentElement(content);
        return e;
    }

    public static Entry toAssetEntryAbdera(AssetItem a, UriInfo uriInfo) {
        URI baseURL = a.isHistoricalVersion() ? uriInfo.getBaseUriBuilder().path("packages/{packageName}/assets/{assetName}/versions/{version}").build(new Object[]{a.getPackageName(), a.getName(), Long.toString(a.getVersionNumber())}) : uriInfo.getBaseUriBuilder().path("packages/{packageName}/assets/{assetName}").build(new Object[]{a.getPackageName(), a.getName()});
        Factory factory = Abdera.getNewFactory();
        Entry e = factory.getAbdera().newEntry();
        e.setTitle(a.getTitle());
        e.setSummary(a.getDescription());
        e.setPublished(new Date(a.getLastModified().getTimeInMillis()));
        e.setBaseUri(baseURL.toString());
        e.addAuthor(a.getLastContributor());
        e.setId(baseURL.toString());
        ExtensibleElement extension = (ExtensibleElement)e.addExtension(METADATA);
        ExtensibleElement childExtension = (ExtensibleElement)extension.addExtension(ARCHIVED);
        childExtension.addSimpleExtension(VALUE, a.isArchived() ? "true" : "false");
        childExtension = (ExtensibleElement)extension.addExtension(UUID);
        childExtension.addSimpleExtension(VALUE, a.getUUID());
        childExtension = (ExtensibleElement)extension.addExtension(STATE);
        childExtension.addSimpleExtension(VALUE, a.getState() == null ? "" : a.getState().getName());
        childExtension = (ExtensibleElement)extension.addExtension(FORMAT);
        childExtension.addSimpleExtension(VALUE, a.getFormat());
        childExtension = (ExtensibleElement)extension.addExtension(VERSION_NUMBER);
        childExtension.addSimpleExtension(VALUE, String.valueOf(a.getVersionNumber()));
        childExtension = (ExtensibleElement)extension.addExtension(CHECKIN_COMMENT);
        childExtension.addSimpleExtension(VALUE, a.getCheckinComment());
        List categories = a.getCategories();
        childExtension = (ExtensibleElement)extension.addExtension(CATEGORIES);
        for (CategoryItem c : categories) {
            childExtension.addSimpleExtension(VALUE, c.getName());
        }
        Content content = factory.newContent();
        content.setSrc(UriBuilder.fromUri((URI)baseURL).path("binary").build(new Object[0]).toString());
        content.setMimeType("application/octet-stream");
        content.setContentType(Content.Type.MEDIA);
        e.setContentElement(content);
        return e;
    }
}

