/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security.rules;

import java.io.Serializable;
import java.util.List;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.RoleType;
import org.drools.guvnor.server.security.rules.PermissionRule;
import org.drools.guvnor.server.util.LoggingHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagePermissionRule
implements PermissionRule,
Serializable {
    private static final LoggingHelper log = LoggingHelper.getLogger(PackagePermissionRule.class);

    public boolean hasPermission(Object requestedObject, String requestedPermission, List<RoleBasedPermission> permissions) {
        String targetName = (String)requestedObject;
        for (RoleBasedPermission pbp : permissions) {
            if (!targetName.equalsIgnoreCase(pbp.getPackageName()) || !this.isPermittedPackage(requestedPermission, pbp.getRole())) continue;
            log.debug("Requested permission: " + requestedPermission + ", Requested object: " + targetName + " , Permission granted: Yes");
            return true;
        }
        log.debug("Requested permission: " + requestedPermission + ", Requested object: " + targetName + " , Permission granted: No");
        return false;
    }

    private boolean isPermittedPackage(String requestedAction, String role) {
        if (RoleType.PACKAGE_ADMIN.getName().equalsIgnoreCase(role)) {
            return true;
        }
        if (RoleType.PACKAGE_DEVELOPER.getName().equalsIgnoreCase(role)) {
            if (RoleType.PACKAGE_ADMIN.getName().equalsIgnoreCase(requestedAction)) {
                return false;
            }
            if (RoleType.PACKAGE_DEVELOPER.getName().equalsIgnoreCase(requestedAction)) {
                return true;
            }
            if (RoleType.PACKAGE_READONLY.getName().equalsIgnoreCase(requestedAction)) {
                return true;
            }
        } else if (RoleType.PACKAGE_READONLY.getName().equalsIgnoreCase(role)) {
            if (RoleType.PACKAGE_ADMIN.getName().equalsIgnoreCase(requestedAction)) {
                return false;
            }
            if (RoleType.PACKAGE_DEVELOPER.getName().equalsIgnoreCase(requestedAction)) {
                return false;
            }
            if (RoleType.PACKAGE_READONLY.getName().equalsIgnoreCase(requestedAction)) {
                return true;
            }
        }
        return false;
    }
}

