/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security.rules;

import java.io.Serializable;
import java.util.List;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.security.PackageUUIDType;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.rules.PackagePermissionRule;
import org.drools.guvnor.server.security.rules.PermissionRule;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageUUIDTypePermissionRule
implements PermissionRule,
Serializable {
    public boolean hasPermission(Object requestedObject, String requestedPermission, List<RoleBasedPermission> permissions) {
        String targetName;
        String targetUUID = ((PackageUUIDType)requestedObject).getUUID();
        try {
            targetName = this.fetchRulesRepository().loadPackageByUUID(targetUUID).getName();
        }
        catch (RulesRepositoryException e) {
            return false;
        }
        return new PackagePermissionRule().hasPermission((Object)targetName, requestedPermission, permissions);
    }

    private RulesRepository fetchRulesRepository() {
        return ((ServiceImplementation)Component.getInstance((String)"org.drools.guvnor.client.rpc.RepositoryService")).getRulesRepository();
    }
}

