/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.AppController;
import org.drools.guvnor.client.GuvnorDroolsEntryPoint;
import org.drools.guvnor.client.LoginWidget;
import org.drools.guvnor.client.asseteditor.drools.standalone.StandaloneEditorManager;
import org.drools.guvnor.client.configurations.ConfigurationsLoader;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.drools.ClientFactoryImpl;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.resources.DecisionTableResources;
import org.drools.guvnor.client.resources.GuvnorResources;
import org.drools.guvnor.client.resources.OperatorsResource;
import org.drools.guvnor.client.resources.RoundedCornersResource;
import org.drools.guvnor.client.resources.WizardCellListResources;
import org.drools.guvnor.client.resources.WizardResources;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;

public class GuvnorDroolsEntryPoint
implements EntryPoint {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private AppController appController;

    public void onModuleLoad() {
        this.loadStyles();
        this.hideLoadingPopup();
        this.checkLogIn();
    }

    private void loadStyles() {
        GuvnorResources.INSTANCE.headerCss().ensureInjected();
        GuvnorResources.INSTANCE.titledTextCellCss().ensureInjected();
        GuvnorResources.INSTANCE.guvnorCss().ensureInjected();
        RoundedCornersResource.INSTANCE.roundCornersCss().ensureInjected();
        OperatorsResource.INSTANCE.operatorsCss().ensureInjected();
        WizardCellListResources.INSTANCE.cellListStyle().ensureInjected();
        WizardResources.INSTANCE.style().ensureInjected();
        DecisionTableResources.INSTANCE.style().ensureInjected();
    }

    private void checkLogIn() {
        RepositoryServiceFactory.getSecurityService().getCurrentUser((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void logIn() {
        LoginWidget loginWidget = new LoginWidget();
        loginWidget.setLoggedInEvent((Command)new /* Unavailable Anonymous Inner Class!! */);
        loginWidget.show();
    }

    private void showMain(String userName) {
        Window.setStatus((String)this.constants.LoadingUserPermissions());
        this.loadConfigurations(userName);
    }

    private void loadConfigurations(String userName) {
        ConfigurationsLoader.loadPreferences((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadUserCapabilities(String userName) {
        ConfigurationsLoader.loadUserCapabilities((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setUpMain(String userName) {
        Window.setStatus((String)" ");
        this.createMain();
        this.appController.setUserName(userName);
    }

    private void createMain() {
        SimpleEventBus eventBus = new SimpleEventBus();
        SuggestionCompletionCache.getInstance().setEventBus((EventBus)eventBus);
        ClientFactoryImpl clientFactory = new ClientFactoryImpl((EventBus)eventBus);
        this.appController = new AppController((ClientFactory)clientFactory, (EventBus)eventBus);
        if (Window.Location.getPath().contains("StandaloneEditor.html")) {
            RootLayoutPanel.get().add((Widget)new StandaloneEditorManager((ClientFactory)clientFactory, (EventBus)eventBus).getBaseLayout());
        } else {
            RootLayoutPanel.get().add(this.appController.getMainPanel());
        }
    }

    private void hideLoadingPopup() {
        Element e = RootPanel.get((String)"loading").getElement();
        5 r = new /* Unavailable Anonymous Inner Class!! */;
        r.run(500);
    }

    static /* synthetic */ void access$000(GuvnorDroolsEntryPoint x0, String x1) {
        x0.showMain(x1);
    }

    static /* synthetic */ void access$100(GuvnorDroolsEntryPoint x0) {
        x0.logIn();
    }

    static /* synthetic */ void access$200(GuvnorDroolsEntryPoint x0, String x1) {
        x0.loadUserCapabilities(x1);
    }

    static /* synthetic */ void access$300(GuvnorDroolsEntryPoint x0, String x1) {
        x0.setUpMain(x1);
    }
}

