/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.changeset;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.drools.guvnor.client.asseteditor.drools.changeset.AbstractXMLResourceDefinitionCreatorWidget;
import org.drools.guvnor.client.asseteditor.drools.changeset.CreateAssetResourceWidget;
import org.drools.guvnor.client.asseteditor.drools.changeset.ResourceElementReadyCommand;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.PackageServiceAsync;
import org.drools.guvnor.client.widgets.RESTUtil;
import org.drools.guvnor.client.widgets.tables.AssetPagedTable;

public class CreateAssetResourceWidget
extends AbstractXMLResourceDefinitionCreatorWidget {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private boolean globalArea;
    private PackageServiceAsync packageService;
    private final AssetServiceAsync assetService;
    private ClientFactory clientFactory;
    private String packageUUID;
    private static CreateAssetResourceWidgetBinder uiBinder = (CreateAssetResourceWidgetBinder)GWT.create(CreateAssetResourceWidgetBinder.class);
    @UiField
    protected TextBox txtName;
    @UiField
    protected TextBox txtDescription;
    @UiField
    protected ListBox lstPackage;
    @UiField
    protected ListBox lstFormat;
    @UiField
    protected ScrollPanel sclTreePanel;
    protected AssetPagedTable assetsTable;

    public CreateAssetResourceWidget(String packageUUID, String packageName, ClientFactory clientFactory) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.globalArea = packageName.equals("globalArea");
        this.packageService = clientFactory.getPackageService();
        this.assetService = clientFactory.getAssetService();
        this.clientFactory = clientFactory;
        this.packageUUID = packageUUID;
        this.initializeFormatList();
        this.initializePackageList();
    }

    private void initializePackageList() {
        if (this.globalArea) {
            this.packageService.loadGlobalPackage((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.packageService.listPackages((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.packageService.loadPackageConfig(this.packageUUID, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.lstPackage.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initializeFormatList() {
        for (String format : AssetFormats.CHANGE_SET_RESOURCE) {
            this.lstFormat.addItem(format, format);
        }
        this.lstFormat.setSelectedIndex(0);
        this.lstFormat.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadAssetTable() {
        this.sclTreePanel.clear();
        String selectedPackageUUID = this.lstPackage.getValue(this.lstPackage.getSelectedIndex());
        ArrayList<String> selectedFormats = new ArrayList<String>();
        selectedFormats.add(this.lstFormat.getValue(this.lstFormat.getSelectedIndex()));
        this.assetsTable = new AssetPagedTable(selectedPackageUUID, selectedFormats, null, this.clientFactory);
        this.sclTreePanel.add((Widget)this.assetsTable);
        this.makeDirty();
    }

    private void handleListChanges(ChangeEvent event) {
        this.loadAssetTable();
    }

    private void populatePackageList(PackageConfigData packageConfigData) {
        this.lstPackage.addItem(packageConfigData.getName(), packageConfigData.getUuid());
        this.lstPackage.setSelectedIndex(0);
    }

    public void getResourceElement(ResourceElementReadyCommand resourceElementReadyCommand) {
        String[] selectedRowUUIDs = this.assetsTable.getSelectedRowUUIDs();
        if (selectedRowUUIDs == null || selectedRowUUIDs.length == 0) {
            throw new IllegalStateException(this.constants.NoPackageSeleced());
        }
        this.assetService.loadRuleAssets(selectedRowUUIDs, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String convertFromAssetFormatToResourceType(String format) {
        if (format.equals("brl") || format.equals("drl") || format.equals("gdst") || format.equals("template")) {
            return "DRL";
        }
        if (format.equals("dsl")) {
            return "DSL";
        }
        if (format.equals("bpmn2")) {
            return "BPMN2";
        }
        if (format.equals("changeset")) {
            return "CHANGE_SET";
        }
        return null;
    }

    private String getDownloadLink(String assetName) {
        String url = RESTUtil.getRESTBaseURL();
        url = url + "packages/";
        url = url + this.lstPackage.getItemText(this.lstPackage.getSelectedIndex());
        url = url + "/assets/";
        url = url + assetName;
        url = url + "/source";
        return url;
    }

    static /* synthetic */ void access$000(CreateAssetResourceWidget x0, PackageConfigData x1) {
        x0.populatePackageList(x1);
    }

    static /* synthetic */ void access$100(CreateAssetResourceWidget x0) {
        x0.loadAssetTable();
    }

    static /* synthetic */ void access$200(CreateAssetResourceWidget x0, ChangeEvent x1) {
        x0.handleListChanges(x1);
    }

    static /* synthetic */ String access$300(CreateAssetResourceWidget x0, String x1) {
        return x0.convertFromAssetFormatToResourceType(x1);
    }

    static /* synthetic */ Constants access$400(CreateAssetResourceWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ String access$500(CreateAssetResourceWidget x0, String x1) {
        return x0.getDownloadLink(x1);
    }
}

