/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.NoSpaceKeyPressHandler;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.messages.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationEditorPopup {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static final RegExp VALID_NAME = RegExp.compile((String)"^[a-zA-Z][a-zA-Z\\d]*$");
    private final AnnotationMetaModel annotation;
    private final List<AnnotationMetaModel> annotations;
    private final TextBox txtName = new TextBox();
    private final TextBox txtKey = new TextBox();
    private final TextBox txtValue = new TextBox();
    private Command okCommand;

    public AnnotationEditorPopup(List<AnnotationMetaModel> annotations) {
        this(new AnnotationMetaModel(), annotations);
    }

    public AnnotationEditorPopup(AnnotationMetaModel annotation, List<AnnotationMetaModel> annotations) {
        this.annotation = annotation;
        this.annotations = annotations;
    }

    public AnnotationMetaModel getAnnotation() {
        return this.annotation;
    }

    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    public void show() {
        FormStylePopup pop = new FormStylePopup();
        VerticalPanel vp = new VerticalPanel();
        Grid g = new Grid(2, 3);
        this.txtName.addKeyPressHandler((KeyPressHandler)new NoSpaceKeyPressHandler());
        this.txtKey.addKeyPressHandler((KeyPressHandler)new NoSpaceKeyPressHandler());
        g.setWidget(0, 0, (Widget)new HTML("<b>Name</b>"));
        g.setWidget(1, 0, (Widget)this.txtName);
        g.setWidget(0, 1, (Widget)new HTML("<b>Key</b>"));
        g.setWidget(1, 1, (Widget)this.txtKey);
        g.setWidget(0, 2, (Widget)new HTML("<b>Value</b>"));
        g.setWidget(1, 2, (Widget)this.txtValue);
        this.setControlValues(this.annotation);
        Button btnOK = new Button(constants.OK());
        btnOK.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        vp.add((Widget)g);
        vp.add((Widget)btnOK);
        pop.addRow((Widget)vp);
        pop.show();
    }

    private void setControlValues(AnnotationMetaModel annotation) {
        String name = annotation.name == null ? "" : annotation.name;
        String key = this.getFirstEntry(annotation.getValues().keySet());
        String value = this.getFirstEntry(annotation.getValues().values());
        this.txtName.setText(name);
        this.txtKey.setText(key);
        this.txtValue.setText(value);
    }

    private String getFirstEntry(Collection<String> values) {
        if (values.isEmpty()) {
            return "";
        }
        return values.iterator().next();
    }

    static /* synthetic */ TextBox access$000(AnnotationEditorPopup x0) {
        return x0.txtName;
    }

    static /* synthetic */ Constants access$100() {
        return constants;
    }

    static /* synthetic */ RegExp access$200() {
        return VALID_NAME;
    }

    static /* synthetic */ AnnotationMetaModel access$300(AnnotationEditorPopup x0) {
        return x0.annotation;
    }

    static /* synthetic */ TextBox access$400(AnnotationEditorPopup x0) {
        return x0.txtKey;
    }

    static /* synthetic */ TextBox access$500(AnnotationEditorPopup x0) {
        return x0.txtValue;
    }

    static /* synthetic */ Command access$600(AnnotationEditorPopup x0) {
        return x0.okCommand;
    }

    static /* synthetic */ List access$700(AnnotationEditorPopup x0) {
        return x0.annotations;
    }
}

