/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationEditor;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationEditorPopup;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactFieldEditor;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactFieldsEditor;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FieldEditorPopup;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FieldMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.ModelNameHelper;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.util.AddButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactFieldsEditor
extends Composite {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static FactFieldsEditorBinder uiBinder = (FactFieldsEditorBinder)GWT.create(FactFieldsEditorBinder.class);
    @UiField
    VerticalPanel fieldsPanel;
    @UiField
    AddButton addFieldIcon;
    @UiField
    AddButton addAnnotationIcon;
    private final ModelNameHelper modelNameHelper;
    private final List<FieldMetaModel> fields;
    private final List<AnnotationMetaModel> annotations;

    public FactFieldsEditor(List<FieldMetaModel> fields, List<AnnotationMetaModel> annotations, ModelNameHelper modelNameHelper) {
        this.fields = fields;
        this.annotations = annotations;
        this.modelNameHelper = modelNameHelper;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.addAnnotationRows();
        this.addFieldRows();
        this.addFieldIcon.setTitle(constants.AddField());
        this.addFieldIcon.setText(constants.AddField());
        this.addAnnotationIcon.setTitle(constants.AddAnnotation());
        this.addAnnotationIcon.setText(constants.AddAnnotation());
    }

    @UiHandler(value={"addFieldIcon"})
    void addNewFieldClick(ClickEvent event) {
        FieldEditorPopup popup = new FieldEditorPopup(this.fields, this.modelNameHelper);
        popup.setOkCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    @UiHandler(value={"addAnnotationIcon"})
    void addNewAnnotationClick(ClickEvent event) {
        AnnotationEditorPopup popup = new AnnotationEditorPopup(this.annotations);
        popup.setOkCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    private void addFieldRows() {
        for (FieldMetaModel fieldMetaModel : this.fields) {
            this.addFieldRow(fieldMetaModel);
        }
    }

    private void addAnnotationRows() {
        for (AnnotationMetaModel annotation : this.annotations) {
            this.addAnnotationRow(annotation);
        }
    }

    private void addFieldRow(FieldMetaModel field) {
        FactFieldEditor editor = new FactFieldEditor(field, this.fields, this.modelNameHelper);
        editor.setDeleteCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        this.fieldsPanel.add((Widget)editor);
    }

    private void addAnnotationRow(AnnotationMetaModel annotation) {
        AnnotationEditor editor = new AnnotationEditor(annotation, this.annotations);
        editor.setDeleteCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        this.fieldsPanel.insert((Widget)editor, this.findPositionOfLastAnnotation());
    }

    private int findPositionOfLastAnnotation() {
        Widget w;
        int position = 0;
        for (int i = 0; i < this.fieldsPanel.getWidgetCount() && !((w = this.fieldsPanel.getWidget(i)) instanceof FactFieldEditor); ++i) {
            position = i + 1;
        }
        return position;
    }

    static /* synthetic */ List access$000(FactFieldsEditor x0) {
        return x0.fields;
    }

    static /* synthetic */ void access$100(FactFieldsEditor x0, FieldMetaModel x1) {
        x0.addFieldRow(x1);
    }

    static /* synthetic */ List access$200(FactFieldsEditor x0) {
        return x0.annotations;
    }

    static /* synthetic */ void access$300(FactFieldsEditor x0, AnnotationMetaModel x1) {
        x0.addAnnotationRow(x1);
    }

    static /* synthetic */ Constants access$400() {
        return constants;
    }
}

