/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.factmodel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FieldMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.ModelNameHelper;
import org.drools.guvnor.client.asseteditor.drools.factmodel.NoSpaceKeyPressHandler;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.messages.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldEditorPopup {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static final RegExp VALID_NAME = RegExp.compile((String)"^[a-zA-Z][a-zA-Z\\d_$]*$");
    private static final RegExp VALID_DATATYPE = RegExp.compile((String)"^([a-zA-Z][a-zA-Z\\d_$]*\\.)*[a-zA-Z][a-zA-Z\\d_$]*$");
    private final FieldMetaModel field;
    private final List<FieldMetaModel> fields;
    private final ModelNameHelper modelNameHelper;
    private Command okCommand;

    public FieldEditorPopup(List<FieldMetaModel> fields, ModelNameHelper modelNameHelper) {
        this(new FieldMetaModel(), fields, modelNameHelper);
    }

    public FieldEditorPopup(FieldMetaModel field, List<FieldMetaModel> fields, ModelNameHelper modelNameHelper) {
        this.field = field;
        this.fields = fields;
        this.modelNameHelper = modelNameHelper;
    }

    public FieldMetaModel getField() {
        return this.field;
    }

    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    public void show() {
        FormStylePopup pop = new FormStylePopup();
        TextBox fieldName = new TextBox();
        TextBox fieldType = new TextBox();
        fieldName.addKeyPressHandler((KeyPressHandler)new NoSpaceKeyPressHandler());
        fieldType.addKeyPressHandler((KeyPressHandler)new NoSpaceKeyPressHandler());
        if (this.field != null) {
            fieldName.setText(this.field.name);
            fieldType.setText(this.field.type);
        }
        HorizontalPanel typeP = new HorizontalPanel();
        typeP.add((Widget)fieldType);
        ListBox typeChoice = new ListBox();
        typeChoice.addItem(constants.chooseType());
        for (Map.Entry entry : this.modelNameHelper.getTypeDescriptions().entrySet()) {
            typeChoice.addItem((String)entry.getValue(), (String)entry.getKey());
        }
        typeChoice.setSelectedIndex(0);
        typeChoice.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        typeP.add((Widget)typeChoice);
        pop.addAttribute(constants.FieldNameAttribute(), (Widget)fieldName);
        pop.addAttribute(constants.Type(), (Widget)typeP);
        Button ok = new Button(constants.OK());
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute("", (Widget)ok);
        pop.show();
    }

    static /* synthetic */ Constants access$000() {
        return constants;
    }

    static /* synthetic */ RegExp access$100() {
        return VALID_DATATYPE;
    }

    static /* synthetic */ RegExp access$200() {
        return VALID_NAME;
    }

    static /* synthetic */ FieldMetaModel access$300(FieldEditorPopup x0) {
        return x0.field;
    }

    static /* synthetic */ Command access$400(FieldEditorPopup x0) {
        return x0.okCommand;
    }

    static /* synthetic */ List access$500(FieldEditorPopup x0) {
        return x0.fields;
    }
}

