/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.EnumDropDown;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;

public class EnumDropDownLabel
extends Composite {
    protected Constants constants = (Constants)GWT.create(Constants.class);
    protected final Label textWidget;
    protected final EnumDropDown enumDropDown;
    protected final Button okButton;
    protected final Panel panel = new HorizontalPanel();
    protected final PopupPanel popup;
    protected Command onValueChangeCommand;
    protected FactPattern pattern;
    protected String qualifiedFieldName;
    protected SuggestionCompletionEngine sce;
    protected BaseSingleFieldConstraint constraint;
    protected boolean enabled;

    public EnumDropDownLabel(FactPattern pattern, String qualifiedFieldName, SuggestionCompletionEngine sce, BaseSingleFieldConstraint constraint, boolean enabled) {
        this.pattern = pattern;
        this.qualifiedFieldName = qualifiedFieldName;
        this.constraint = constraint;
        this.sce = sce;
        this.enabled = enabled;
        this.textWidget = this.createTextLabel();
        this.enumDropDown = this.createEnumDropDown();
        this.okButton = new Button(this.constants.OK());
        this.panel.add((Widget)this.textWidget);
        this.updateTextWidget();
        this.updateModel();
        this.popup = this.createPopup();
        this.initWidget((Widget)this.panel);
    }

    private void showPopup() {
        this.popup.setPopupPosition(this.getAbsoluteLeft(), this.getAbsoluteTop());
        if (this.constraint.getOperator().equals("in") && !this.enumDropDown.isMultipleSelect()) {
            this.enumDropDown.setMultipleSelect(true);
            this.constraint.setValue("");
        } else if (!this.constraint.getOperator().equals("in") && this.enumDropDown.isMultipleSelect()) {
            this.enumDropDown.setMultipleSelect(false);
            this.constraint.setValue("");
        }
        this.enumDropDown.setDropDownData(this.constraint.getValue(), this.getDropDownData());
        this.popup.show();
    }

    private DropDownData getDropDownData() {
        String valueType;
        String factType = this.pattern.getFactType();
        String fieldName = this.qualifiedFieldName;
        if (this.constraint instanceof SingleFieldConstraintEBLeftSide) {
            SingleFieldConstraintEBLeftSide sfexp = (SingleFieldConstraintEBLeftSide)this.constraint;
            valueType = sfexp.getExpressionLeftSide().getGenericType();
        } else if (this.constraint instanceof ConnectiveConstraint) {
            ConnectiveConstraint cc = (ConnectiveConstraint)this.constraint;
            fieldName = cc.getFieldName();
            if (fieldName != null && fieldName.contains(".")) {
                fieldName = fieldName.substring(fieldName.indexOf(".") + 1);
            }
            valueType = cc.getFieldType();
        } else {
            factType = this.pattern.getFactType();
            fieldName = this.qualifiedFieldName;
            if (fieldName != null && fieldName.contains(".")) {
                int index = fieldName.indexOf(".");
                factType = fieldName.substring(0, index);
                fieldName = fieldName.substring(index + 1);
            }
            valueType = this.sce.getFieldType(factType, fieldName);
        }
        DropDownData dropDownData = "Boolean".equals(valueType) ? DropDownData.create((String[])new String[]{"true", "false"}) : this.sce.getEnums(this.pattern, fieldName);
        return dropDownData;
    }

    private EnumDropDown createEnumDropDown() {
        EnumDropDown box = new EnumDropDown(this.constraint.getValue(), (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, this.getDropDownData(), "in".equals(this.constraint.getOperator()));
        if (box.getItemCount() > 6) {
            box.setVisibleItemCount(6);
        } else {
            box.setVisibleItemCount(box.getItemCount());
        }
        box.setEnabled(this.enabled);
        return box;
    }

    private Label createTextLabel() {
        Label label = new Label();
        label.setStyleName("form-field");
        if (this.enabled) {
            label.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return label;
    }

    private PopupPanel createPopup() {
        PopupPanel popup = new PopupPanel();
        popup.setGlassEnabled(true);
        this.okButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.add((Widget)this.enumDropDown);
        horizontalPanel.add((Widget)this.okButton);
        popup.add((Widget)horizontalPanel);
        return popup;
    }

    private void executeOnValueChangeCommand() {
        if (this.onValueChangeCommand != null) {
            this.onValueChangeCommand.execute();
        }
    }

    public void setOnValueChangeCommand(Command onValueChangeCommand) {
        this.onValueChangeCommand = onValueChangeCommand;
    }

    public void refreshDropDownData() {
        this.enumDropDown.setDropDownData(this.constraint.getValue(), this.getDropDownData());
        this.updateTextWidget();
        this.updateModel();
    }

    private void updateTextWidget() {
        this.textWidget.setText(this.enumDropDown.getSelectedItemsText());
    }

    private void updateModel() {
        this.constraint.setValue(this.enumDropDown.getSelectedValue());
    }

    static /* synthetic */ void access$000(EnumDropDownLabel x0) {
        x0.showPopup();
    }

    static /* synthetic */ void access$100(EnumDropDownLabel x0) {
        x0.executeOnValueChangeCommand();
    }
}

