/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataCellValueFactory;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataColumn;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractCellValueFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicDataRow;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.templates.InterpolationVariable;
import org.drools.ide.common.client.modeldriven.brl.templates.TemplateModel;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDataCellValueFactory
extends AbstractCellValueFactory<TemplateDataColumn, String> {
    private TemplateModel model;

    public TemplateDataCellValueFactory(SuggestionCompletionEngine sce) {
        super(sce);
    }

    public void setModel(TemplateModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
    }

    public List<String> makeRowData() {
        InterpolationVariable[] variables;
        ArrayList<String> data = new ArrayList<String>();
        for (InterpolationVariable var : variables = this.model.getInterpolationVariablesList()) {
            TemplateDataColumn column = this.makeModelColumn(var);
            String dcv = this.makeModelCellValue(column);
            data.add(dcv);
        }
        return data;
    }

    public DynamicDataRow makeUIRowData() {
        InterpolationVariable[] variables;
        DynamicDataRow data = new DynamicDataRow();
        for (InterpolationVariable var : variables = this.model.getInterpolationVariablesList()) {
            TemplateDataColumn column = this.makeModelColumn(var);
            String dcv = this.makeModelCellValue(column);
            CellValue cell = this.convertModelCellValue(column, dcv);
            data.add(cell);
        }
        return data;
    }

    public List<String> makeColumnData(TemplateDataColumn column) {
        ArrayList<String> data = new ArrayList<String>();
        for (int iRow = 0; iRow < this.model.getRowsCount(); ++iRow) {
            String cell = this.makeModelCellValue(column);
            data.add(cell);
        }
        return data;
    }

    public List<CellValue<? extends Comparable<?>>> convertColumnData(TemplateDataColumn column, List<String> columnData) {
        ArrayList data = new ArrayList();
        for (int iRow = 0; iRow < this.model.getRowsCount(); ++iRow) {
            String dcv = columnData.get(iRow);
            CellValue cell = this.convertModelCellValue(column, dcv);
            data.add(cell);
        }
        return data;
    }

    public String makeModelCellValue(TemplateDataColumn column) {
        return new String();
    }

    public CellValue<? extends Comparable<?>> convertModelCellValue(TemplateDataColumn column, String dcv) {
        DTDataTypes52 dataType = this.getDataType(column);
        CellValue cell = null;
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dataType.ordinal()]) {
            case 1: {
                Boolean b = Boolean.FALSE;
                try {
                    b = Boolean.valueOf(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewBooleanCellValue(b);
                break;
            }
            case 2: {
                Date d = null;
                try {
                    if (DATE_CONVERTOR == null) {
                        throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
                    }
                    d = DATE_CONVERTOR.parse(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewDateCellValue(d);
                break;
            }
            case 3: {
                BigDecimal bd = null;
                try {
                    bd = new BigDecimal(dcv);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewNumericCellValue(bd);
                break;
            }
            default: {
                cell = this.makeNewStringCellValue((Object)dcv);
            }
        }
        return cell;
    }

    protected DTDataTypes52 getDataType(TemplateDataColumn column) {
        String[] vals = null;
        String factType = column.getFactType();
        String factField = column.getFactField();
        if (factType != null && factField != null && (vals = this.sce.getEnumValues(factType, factField)) != null && vals.length > 0) {
            return DTDataTypes52.STRING;
        }
        String dataType = column.getDataType();
        if (dataType.equals("Boolean")) {
            return DTDataTypes52.BOOLEAN;
        }
        if (dataType.equals("Date")) {
            return DTDataTypes52.DATE;
        }
        if (dataType.equals("Numeric")) {
            return DTDataTypes52.NUMERIC;
        }
        return DTDataTypes52.STRING;
    }

    private TemplateDataColumn makeModelColumn(InterpolationVariable var) {
        return new TemplateDataColumn(var.getVarName(), var.getDataType(), var.getFactType(), var.getFactField());
    }

    public String convertToModelCell(TemplateDataColumn column, CellValue<?> cv) {
        DTDataTypes52 dataType = this.getDataType(column);
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt52$DTDataTypes52[dataType.ordinal()]) {
            case 1: {
                return this.convertBooleanValueToString(cv);
            }
            case 2: {
                return this.convertDateValueToString(cv);
            }
            case 3: {
                return this.convertNumericValueToString(cv);
            }
        }
        return this.convertStringValueToString(cv);
    }

    private String convertBooleanValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((Boolean)value.getValue()).toString();
    }

    private String convertDateValueToString(CellValue<?> value) {
        String result = null;
        if (value.getValue() != null) {
            if (DATE_CONVERTOR == null) {
                throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
            }
            result = DATE_CONVERTOR.format((Date)value.getValue());
        }
        return result;
    }

    private String convertNumericValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((BigDecimal)value.getValue()).toPlainString();
    }

    private String convertStringValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : (String)((Object)value.getValue());
    }
}

