/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataCellFactory;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataCellValueFactory;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataColumn;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.TemplateDataTableResourcesProvider;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.VerticalDecoratedTemplateDataGridWidget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.templates.events.SetTemplateDataEvent;
import org.drools.guvnor.client.util.DateConverter;
import org.drools.guvnor.client.util.GWTDateConverter;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractDecoratedGridWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.ResourcesProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.Coordinate;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.AppendRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.DeleteRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.InsertRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateModelEvent;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.templates.InterpolationVariable;
import org.drools.ide.common.client.modeldriven.brl.templates.TemplateModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDataTableWidget
extends Composite
implements InsertRowEvent.Handler,
DeleteRowEvent.Handler,
AppendRowEvent.Handler,
UpdateModelEvent.Handler {
    protected TemplateModel model;
    protected AbstractDecoratedGridWidget<TemplateModel, TemplateDataColumn, String> widget;
    protected TemplateDataCellFactory cellFactory;
    protected TemplateDataCellValueFactory cellValueFactory;
    protected SuggestionCompletionEngine sce;
    private EventBus eventBus = new SimpleEventBus();
    private EventBus globalEventBus;
    protected static final ResourcesProvider<TemplateDataColumn> resources = new TemplateDataTableResourcesProvider();

    public TemplateDataTableWidget(SuggestionCompletionEngine sce, EventBus globalEventBus) {
        if (sce == null) {
            throw new IllegalArgumentException("sce cannot be null");
        }
        if (globalEventBus == null) {
            throw new IllegalArgumentException("globalEventBus cannot be null");
        }
        this.sce = sce;
        this.globalEventBus = globalEventBus;
        this.cellFactory = new TemplateDataCellFactory(sce, this.eventBus);
        this.cellValueFactory = new TemplateDataCellValueFactory(sce);
        this.widget = new VerticalDecoratedTemplateDataGridWidget(resources, this.cellFactory, this.cellValueFactory, this.eventBus);
        TemplateDataCellValueFactory.injectDateConvertor((DateConverter)GWTDateConverter.getInstance());
        this.eventBus.addHandler(DeleteRowEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(InsertRowEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(AppendRowEvent.TYPE, (EventHandler)this);
        this.eventBus.addHandler(UpdateModelEvent.TYPE, (EventHandler)this);
        this.initWidget((Widget)this.widget);
    }

    public void appendRow() {
        AppendRowEvent are = new AppendRowEvent();
        this.eventBus.fireEvent((GwtEvent)are);
    }

    public List<List<String>> getRows() {
        return this.model.getTableAsList();
    }

    public void setModel(TemplateModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
        this.cellValueFactory.setModel(model);
        SetTemplateDataEvent sme = new SetTemplateDataEvent(model);
        this.eventBus.fireEvent((GwtEvent)sme);
    }

    public void setPixelSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        super.setPixelSize(width, height);
        this.widget.setPixelSize(width, height);
    }

    public void onDeleteRow(DeleteRowEvent event) {
        this.model.removeRow(event.getIndex());
    }

    public void onInsertRow(InsertRowEvent event) {
        List data = this.cellValueFactory.makeRowData();
        this.model.addRow(Integer.toString(event.getIndex()), data.toArray(new String[data.size()]));
    }

    public void onAppendRow(AppendRowEvent event) {
        List data = this.cellValueFactory.makeRowData();
        this.model.addRow(data.toArray(new String[data.size()]));
    }

    public void onUpdateModel(UpdateModelEvent event) {
        List changedData = event.getData();
        Coordinate originCoordinate = event.getOriginCoordinate();
        int originRowIndex = originCoordinate.getRow();
        int originColumnIndex = originCoordinate.getCol();
        InterpolationVariable[] vars = this.model.getInterpolationVariablesList();
        for (int iRow = 0; iRow < changedData.size(); ++iRow) {
            List changedRow = (List)changedData.get(iRow);
            int targetRowIndex = originRowIndex + iRow;
            for (int iCol = 0; iCol < changedRow.size(); ++iCol) {
                int targetColumnIndex = originColumnIndex + iCol;
                CellValue changedCell = (CellValue)changedRow.get(iCol);
                InterpolationVariable var = vars[targetColumnIndex];
                TemplateDataColumn col = new TemplateDataColumn(var.getVarName(), var.getDataType(), var.getFactType(), var.getFactField());
                String dcv = this.cellValueFactory.convertToModelCell(col, changedCell);
                List columnData = (List)this.model.getTable().get(var.getVarName());
                columnData.set(targetRowIndex, dcv);
            }
        }
    }
}

