/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.analysis;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.decisiontable.analysis.FieldDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFieldDetector
extends FieldDetector<DateFieldDetector> {
    private Date from = null;
    private boolean fromInclusive;
    private Date to = null;
    private boolean toInclusive;
    private List<Date> disallowedList = new ArrayList(1);

    public DateFieldDetector(Date value, String operator) {
        if (operator.equals("==")) {
            this.from = value;
            this.fromInclusive = true;
            this.to = value;
            this.toInclusive = true;
        } else if (operator.equals("!=")) {
            this.disallowedList.add(value);
        } else if (operator.equals("<")) {
            this.to = value;
            this.toInclusive = false;
        } else if (operator.equals("<=")) {
            this.to = value;
            this.toInclusive = true;
        } else if (operator.equals(">")) {
            this.from = value;
            this.fromInclusive = false;
        } else if (operator.equals(">=")) {
            this.from = value;
            this.fromInclusive = true;
        } else {
            this.hasUnrecognizedConstraint = true;
        }
    }

    public DateFieldDetector(DateFieldDetector a, DateFieldDetector b) {
        super((FieldDetector)a, (FieldDetector)b);
        int comparison;
        if (b.from == null) {
            this.from = a.from;
            this.fromInclusive = a.fromInclusive;
        } else if (a.from == null) {
            this.from = b.from;
            this.fromInclusive = b.fromInclusive;
        } else {
            comparison = a.from.compareTo(b.from);
            if (comparison < 0) {
                this.from = b.from;
                this.fromInclusive = b.fromInclusive;
            } else if (comparison == 0) {
                this.from = a.from;
                this.fromInclusive = a.fromInclusive && b.fromInclusive;
            } else {
                this.from = a.from;
                this.fromInclusive = a.fromInclusive;
            }
        }
        if (b.to == null) {
            this.to = a.to;
            this.toInclusive = a.toInclusive;
        } else if (a.to == null) {
            this.to = b.to;
            this.toInclusive = b.toInclusive;
        } else {
            comparison = a.to.compareTo(b.to);
            if (comparison < 0) {
                this.to = a.to;
                this.toInclusive = a.toInclusive;
            } else if (comparison == 0) {
                this.to = a.to;
                this.toInclusive = a.toInclusive && b.toInclusive;
            } else {
                this.to = b.to;
                this.toInclusive = b.toInclusive;
            }
        }
        this.disallowedList.addAll(a.disallowedList);
        this.disallowedList.addAll(b.disallowedList);
        this.optimizeNotList();
        this.detectImpossibleMatch();
    }

    private void optimizeNotList() {
        Iterator notIt = this.disallowedList.iterator();
        while (notIt.hasNext()) {
            int comparison;
            Date notValue = (Date)notIt.next();
            if (this.from != null) {
                comparison = notValue.compareTo(this.from);
                if (comparison <= 0) {
                    notIt.remove();
                }
                if (comparison == 0) {
                    this.fromInclusive = false;
                }
            }
            if (this.to == null) continue;
            comparison = notValue.compareTo(this.to);
            if (comparison >= 0) {
                notIt.remove();
            }
            if (comparison != 0) continue;
            this.toInclusive = false;
        }
    }

    private void detectImpossibleMatch() {
        int comparison;
        if (!(this.from == null || this.to == null || (comparison = this.from.compareTo(this.to)) <= 0 && (comparison != 0 || this.fromInclusive && this.toInclusive))) {
            this.impossibleMatch = true;
        }
    }

    public DateFieldDetector merge(DateFieldDetector other) {
        return new DateFieldDetector(this, other);
    }
}

