/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.guvnor.client.decisiontable.analysis.BooleanFieldDetector;
import org.drools.guvnor.client.decisiontable.analysis.DateFieldDetector;
import org.drools.guvnor.client.decisiontable.analysis.EnumFieldDetector;
import org.drools.guvnor.client.decisiontable.analysis.FieldDetector;
import org.drools.guvnor.client.decisiontable.analysis.NumericFieldDetector;
import org.drools.guvnor.client.decisiontable.analysis.RowDetector;
import org.drools.guvnor.client.decisiontable.analysis.StringFieldDetector;
import org.drools.guvnor.client.decisiontable.analysis.UnrecognizedFieldDetector;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.Analysis;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryCol;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTableAnalyzer {
    private SuggestionCompletionEngine sce;

    public DecisionTableAnalyzer(SuggestionCompletionEngine sce) {
        this.sce = sce;
    }

    public List<Analysis> analyze(GuidedDecisionTable52 model) {
        return this.detectImpossibleMatches(model);
    }

    private List<Analysis> detectImpossibleMatches(GuidedDecisionTable52 model) {
        List data = model.getData();
        ArrayList<Analysis> analysisData = new ArrayList<Analysis>(data.size());
        ArrayList<RowDetector> rowDetectorList = new ArrayList<RowDetector>(data.size());
        for (List row : data) {
            RowDetector rowDetector = new RowDetector(((DTCellValue52)row.get(0)).getNumericValue().longValue() - 1L);
            for (Pattern52 pattern : model.getPatterns()) {
                List conditions = pattern.getChildColumns();
                for (ConditionCol52 conditionCol : conditions) {
                    boolean cellIsNotBlank;
                    DTCellValue52 realCellValue;
                    int columnIndex = model.getAllColumns().indexOf(conditionCol);
                    DTCellValue52 visibleCellValue = (DTCellValue52)row.get(columnIndex);
                    if (conditionCol instanceof LimitedEntryCol) {
                        realCellValue = ((LimitedEntryCol)conditionCol).getValue();
                        cellIsNotBlank = visibleCellValue.getBooleanValue();
                    } else {
                        realCellValue = visibleCellValue;
                        cellIsNotBlank = visibleCellValue.hasValue();
                    }
                    if (!cellIsNotBlank) continue;
                    FieldDetector fieldDetector = this.buildDetector(model, conditionCol, realCellValue);
                    String factField = conditionCol.getFactField();
                    rowDetector.putOrMergeFieldDetector(pattern, factField, fieldDetector);
                }
            }
            rowDetectorList.add(rowDetector);
        }
        for (RowDetector rowDetector : rowDetectorList) {
            analysisData.add(rowDetector.buildAnalysis(rowDetectorList));
        }
        return analysisData;
    }

    private FieldDetector buildDetector(GuidedDecisionTable52 model, ConditionCol52 conditionCol, DTCellValue52 realCellValue) {
        String operator = conditionCol.getOperator();
        String type = model.getType((BaseColumn)conditionCol, this.sce);
        String[] allValueList = model.getValueList((BaseColumn)conditionCol, this.sce);
        Object newDetector = allValueList.length != 0 ? new EnumFieldDetector(Arrays.asList(allValueList), realCellValue.getStringValue(), operator) : (type == null ? new UnrecognizedFieldDetector(operator) : (type.equals("String") ? new StringFieldDetector(realCellValue.getStringValue(), operator) : (type.equals("Numeric") ? new NumericFieldDetector(realCellValue.getNumericValue(), operator) : (type.equals("Boolean") ? new BooleanFieldDetector(realCellValue.getBooleanValue(), operator) : (type.equals("Date") ? new DateFieldDetector(realCellValue.getDateValue(), operator) : new UnrecognizedFieldDetector(operator))))));
        return newDetector;
    }
}

