/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.analysis;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.decisiontable.analysis.FieldDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumFieldDetector
extends FieldDetector<EnumFieldDetector> {
    private final List<String> allowedValueList = new ArrayList();

    public EnumFieldDetector(List<String> allValueList, String value, String operator) {
        if (operator.equals("==")) {
            if (allValueList.contains(value)) {
                this.allowedValueList.add(value);
            } else {
                System.out.println("Warning: value (" + value + ") is not a valid enum value (" + allValueList + ").");
            }
        } else if (operator.equals("!=")) {
            this.allowedValueList.addAll(allValueList);
            this.allowedValueList.remove(value);
        } else if (operator.equals("in")) {
            String[] tokens;
            for (String token : tokens = value.split(",")) {
                if (allValueList.contains(token)) {
                    this.allowedValueList.add(token);
                    continue;
                }
                System.out.println("Warning: value (" + token + ") is not a valid enum value (" + allValueList + ").");
            }
        } else {
            this.allowedValueList.addAll(allValueList);
            this.hasUnrecognizedConstraint = true;
        }
    }

    public EnumFieldDetector(EnumFieldDetector a, EnumFieldDetector b) {
        super((FieldDetector)a, (FieldDetector)b);
        this.allowedValueList.addAll(a.allowedValueList);
        this.allowedValueList.retainAll(b.allowedValueList);
        this.detectImpossibleMatch();
    }

    private void detectImpossibleMatch() {
        if (this.allowedValueList.isEmpty()) {
            this.impossibleMatch = true;
        }
    }

    public EnumFieldDetector merge(EnumFieldDetector other) {
        return new EnumFieldDetector(this, other);
    }
}

