/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.analysis;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.decisiontable.analysis.FieldDetector;
import org.drools.ide.common.client.modeldriven.dt52.Analysis;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowDetector {
    private long rowIndex;
    private Map<Pattern52, Map<String, FieldDetector>> fieldDetectorMap = new LinkedHashMap();

    public RowDetector(long rowIndex) {
        this.rowIndex = rowIndex;
    }

    public long getRowIndex() {
        return this.rowIndex;
    }

    public FieldDetector getFieldDetector(Pattern52 pattern, String factField) {
        Map subMap = (Map)this.fieldDetectorMap.get(pattern);
        if (subMap == null) {
            return null;
        }
        return (FieldDetector)subMap.get(factField);
    }

    public void putOrMergeFieldDetector(Pattern52 pattern, String factField, FieldDetector fieldDetector) {
        FieldDetector originalFieldDetector;
        LinkedHashMap<String, FieldDetector> subMap = (LinkedHashMap<String, FieldDetector>)this.fieldDetectorMap.get(pattern);
        if (subMap == null) {
            subMap = new LinkedHashMap<String, FieldDetector>();
            this.fieldDetectorMap.put(pattern, subMap);
        }
        FieldDetector mergedFieldDetector = (originalFieldDetector = (FieldDetector)subMap.get(factField)) == null ? fieldDetector : originalFieldDetector.merge(fieldDetector);
        subMap.put(factField, mergedFieldDetector);
    }

    public Analysis buildAnalysis(List<RowDetector> rowDetectorList) {
        Analysis analysis = new Analysis();
        this.detectImpossibleMatch(analysis);
        for (RowDetector otherRowDetector : rowDetectorList) {
            if (this == otherRowDetector) continue;
            this.detectConflict(analysis, otherRowDetector);
        }
        return analysis;
    }

    private void detectImpossibleMatch(Analysis analysis) {
        for (Map.Entry entry : this.fieldDetectorMap.entrySet()) {
            Pattern52 pattern = (Pattern52)entry.getKey();
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                String factField = (String)subEntry.getKey();
                FieldDetector fieldDetector = (FieldDetector)subEntry.getValue();
                if (!fieldDetector.isImpossibleMatch()) continue;
                analysis.addImpossibleMatch("Impossible match on " + factField);
            }
        }
    }

    private void detectConflict(Analysis analysis, RowDetector otherRowDetector) {
        boolean overlapping = true;
        boolean hasUnrecognized = false;
        for (Map.Entry entry : this.fieldDetectorMap.entrySet()) {
            Pattern52 pattern = (Pattern52)entry.getKey();
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                String factField = (String)subEntry.getKey();
                FieldDetector fieldDetector = (FieldDetector)subEntry.getValue();
                FieldDetector otherFieldDetector = otherRowDetector.getFieldDetector(pattern, factField);
                if (otherFieldDetector == null) continue;
                FieldDetector mergedFieldDetector = fieldDetector.merge(otherFieldDetector);
                if (mergedFieldDetector.isImpossibleMatch()) {
                    overlapping = false;
                }
                if (!mergedFieldDetector.hasUnrecognizedConstraint()) continue;
                hasUnrecognized = true;
            }
        }
        if (overlapping) {
            if (!hasUnrecognized) {
                analysis.addConflictingMatch("Conflicting match with row " + (otherRowDetector.getRowIndex() + 1L));
            } else {
                System.out.println("Possible conflicting match with row " + (otherRowDetector.getRowIndex() + 1L));
            }
        }
    }
}

