/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractCellValueFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractMergableGridWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.ResourcesProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.Coordinate;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicData;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicDataRow;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.GroupedDynamicDataRow;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.RowMapper;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.AppendRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.CellStateChangedEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.CellValueChangedEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.ColumnResizeEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.DeleteColumnEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.DeleteRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.InsertInternalColumnEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.InsertRowEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.MoveColumnsEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.RowGroupingChangeEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SelectedCellChangeEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SetColumnVisibilityEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SetInternalModelEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.SortDataEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.ToggleMergingEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateColumnDataEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateColumnDefinitionEvent;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.UpdateModelEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractMergableGridWidget<M, T>
extends Widget
implements ToggleMergingEvent.Handler,
DeleteRowEvent.Handler,
InsertRowEvent.Handler,
AppendRowEvent.Handler,
DeleteColumnEvent.Handler,
SetInternalModelEvent.Handler<M, T>,
InsertInternalColumnEvent.Handler<T>,
SetColumnVisibilityEvent.Handler,
UpdateColumnDataEvent.Handler,
UpdateColumnDefinitionEvent.Handler,
ColumnResizeEvent.Handler,
MoveColumnsEvent.Handler,
SortDataEvent.Handler,
CellValueChangedEvent.Handler,
CellStateChangedEvent.Handler {
    protected TreeSet<CellValue<? extends Comparable<?>>> selections = new TreeSet(new /* Unavailable Anonymous Inner Class!! */);
    protected TableElement table;
    protected TableSectionElement tbody;
    protected static final Constants messages = (Constants)GWT.create(Constants.class);
    protected ResourcesProvider<T> resources;
    protected EventBus eventBus;
    protected String selectorGroupedCellsHtml;
    protected String selectorUngroupedCellsHtml;
    protected List<DynamicColumn<T>> columns;
    protected DynamicData data;
    protected RowMapper rowMapper;
    protected AbstractCellValueFactory<T, ?> cellValueFactory;
    protected CellValue<?> rangeOriginCell;
    protected CellValue<?> rangeExtentCell;
    protected MOVE_DIRECTION rangeDirection = MOVE_DIRECTION.NONE;
    protected boolean bDragOperationPrimed = false;
    protected static final RowGroupingChangeEvent ROW_GROUPING_EVENT = new RowGroupingChangeEvent();

    private static native void disableTextSelectInternal(Element var0, boolean var1);

    public AbstractMergableGridWidget(ResourcesProvider<T> resources, AbstractCellValueFactory<T, ?> cellValueFactory, EventBus eventBus) {
        this.resources = resources;
        this.cellValueFactory = cellValueFactory;
        this.eventBus = eventBus;
        ImageResource selectorGroupedCells = resources.collapseCellsIcon();
        ImageResource selectorUngroupedCells = resources.expandCellsIcon();
        this.selectorGroupedCellsHtml = AbstractMergableGridWidget.makeImageHtml((ImageResource)selectorGroupedCells);
        this.selectorUngroupedCellsHtml = AbstractMergableGridWidget.makeImageHtml((ImageResource)selectorUngroupedCells);
        this.table = Document.get().createTableElement();
        this.tbody = Document.get().createTBodyElement();
        this.table.setClassName(resources.cellTable());
        this.table.setCellPadding(0);
        this.table.setCellSpacing(0);
        this.setElement((Element)this.table);
        this.table.appendChild((Node)this.tbody);
        this.sinkEvents(Event.getTypeInt((String)"click") | Event.getTypeInt((String)"dblclick") | Event.getTypeInt((String)"mousedown") | Event.getTypeInt((String)"mouseup") | Event.getTypeInt((String)"mousemove") | Event.getTypeInt((String)"mouseout") | Event.getTypeInt((String)"change") | Event.getTypeInt((String)"keypress") | Event.getTypeInt((String)"keydown"));
        AbstractMergableGridWidget.disableTextSelectInternal((Element)this.table, (boolean)true);
        eventBus.addHandler(ToggleMergingEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(DeleteRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(InsertRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(AppendRowEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(DeleteColumnEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(SetColumnVisibilityEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(UpdateColumnDataEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(UpdateColumnDefinitionEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(ColumnResizeEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(MoveColumnsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(SortDataEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(CellValueChangedEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(CellStateChangedEvent.TYPE, (EventHandler)this);
    }

    private static String makeImageHtml(ImageResource image) {
        return AbstractImagePrototype.create((ImageResource)image).getHTML();
    }

    abstract void redraw();

    abstract void redrawColumn(int var1);

    abstract void redrawColumns(int var1, int var2);

    private void applyModelGrouping(CellValue<?> startCell, boolean bRedraw) {
        this.data.applyModelGrouping(startCell);
        if (bRedraw) {
            int startRowIndex = startCell.getCoordinate().getRow();
            GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)this.data.get(startRowIndex);
            int minRedrawRow = this.findMinRedrawRow(startRowIndex - (startRowIndex > 0 ? 1 : 0));
            int maxRedrawRow = this.findMaxRedrawRow(startRowIndex + (startRowIndex < this.data.size() - 1 ? 1 : 0));
            for (int iRow = 0; iRow < groupedRow.getChildRows().size() - 1; ++iRow) {
                this.deleteRowElement(startRowIndex);
            }
            this.redrawRows(minRedrawRow, maxRedrawRow);
            this.eventBus.fireEvent((GwtEvent)ROW_GROUPING_EVENT);
        }
    }

    private boolean equalOrNull(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        return o1.equals(o2);
    }

    private int findMaxRedrawRow(int baseRowIndex) {
        if (this.data.size() == 0) {
            return 0;
        }
        if (baseRowIndex < 0) {
            baseRowIndex = 0;
        }
        if (baseRowIndex > this.data.size() - 1) {
            baseRowIndex = this.data.size() - 1;
        }
        int maxRedrawRow = baseRowIndex;
        DynamicDataRow baseRow = this.data.get(baseRowIndex);
        for (int iCol = 0; iCol < baseRow.size(); ++iCol) {
            int iRow = baseRowIndex;
            CellValue cell = baseRow.get(iCol);
            while (cell.getRowSpan() != 1 && iRow < this.data.size() - 1) {
                DynamicDataRow row = this.data.get(++iRow);
                cell = row.get(iCol);
            }
            maxRedrawRow = iRow > maxRedrawRow ? iRow : maxRedrawRow;
        }
        return maxRedrawRow;
    }

    private Coordinate findMergedCellExtent(Coordinate c) {
        if (c.getRow() == this.data.size() - 1) {
            return c;
        }
        Coordinate nc = new Coordinate(c.getRow() + 1, c.getCol());
        CellValue newCell = this.data.get(nc);
        while (newCell.getRowSpan() == 0 && nc.getRow() < this.data.size() - 1) {
            nc = new Coordinate(nc.getRow() + 1, nc.getCol());
            newCell = this.data.get(nc);
        }
        if (newCell.getRowSpan() != 0) {
            nc = new Coordinate(nc.getRow() - 1, nc.getCol());
        }
        return nc;
    }

    private int findMinRedrawRow(int baseRowIndex) {
        if (this.data.size() == 0) {
            return 0;
        }
        if (baseRowIndex < 0) {
            baseRowIndex = 0;
        }
        if (baseRowIndex > this.data.size() - 1) {
            baseRowIndex = this.data.size() - 1;
        }
        int minRedrawRow = baseRowIndex;
        DynamicDataRow baseRow = this.data.get(baseRowIndex);
        for (int iCol = 0; iCol < baseRow.size(); ++iCol) {
            int iRow = baseRowIndex;
            CellValue cell = baseRow.get(iCol);
            while (cell.getRowSpan() != 1 && iRow > 0) {
                DynamicDataRow row = this.data.get(--iRow);
                cell = row.get(iCol);
            }
            minRedrawRow = iRow < minRedrawRow ? iRow : minRedrawRow;
        }
        return minRedrawRow;
    }

    private Coordinate getNextCell(Coordinate c, MOVE_DIRECTION dir) {
        int step = 0;
        Coordinate nc = c;
        switch (2.$SwitchMap$org$drools$guvnor$client$widgets$drools$decoratedgrid$AbstractMergableGridWidget$MOVE_DIRECTION[dir.ordinal()]) {
            case 1: {
                int n = step = c.getCol() > 0 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow(), c.getCol() - step);
                while (nc.getCol() > 0 && !((DynamicColumn)this.columns.get(nc.getCol())).isVisible()) {
                    nc = new Coordinate(c.getRow(), nc.getCol() - step);
                }
                CellValue newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0) {
                    nc = new Coordinate(nc.getRow() - 1, nc.getCol());
                    newCell = this.data.get(nc);
                }
                break;
            }
            case 2: {
                int n = step = c.getCol() < this.columns.size() - 1 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow(), c.getCol() + step);
                while (nc.getCol() < this.columns.size() - 2 && !((DynamicColumn)this.columns.get(nc.getCol())).isVisible()) {
                    nc = new Coordinate(c.getRow(), nc.getCol() + step);
                }
                CellValue newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0) {
                    nc = new Coordinate(nc.getRow() - 1, nc.getCol());
                    newCell = this.data.get(nc);
                }
                break;
            }
            case 3: {
                int n = step = c.getRow() > 0 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow() - step, c.getCol());
                CellValue newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0) {
                    nc = new Coordinate(nc.getRow() - step, nc.getCol());
                    newCell = this.data.get(nc);
                }
                break;
            }
            case 4: {
                int n = step = c.getRow() < this.data.size() - 1 ? 1 : 0;
                if (step <= 0) break;
                nc = new Coordinate(c.getRow() + step, c.getCol());
                CellValue newCell = this.data.get(nc);
                while (newCell.getRowSpan() == 0 && nc.getRow() < this.data.size() - 1) {
                    nc = new Coordinate(nc.getRow() + step, nc.getCol());
                    newCell = this.data.get(nc);
                }
                if (newCell.getRowSpan() != 0 || nc.getRow() != this.data.size() - 1) break;
                nc = c;
            }
        }
        return nc;
    }

    private void reindexColumns() {
        for (int iCol = 0; iCol < this.columns.size(); ++iCol) {
            DynamicColumn col = (DynamicColumn)this.columns.get(iCol);
            col.setColumnIndex(iCol);
        }
    }

    private void removeModelGrouping(CellValue<?> startCell, boolean bRedraw) {
        List expandedRow = this.data.removeModelGrouping(startCell);
        if (bRedraw) {
            int startRowIndex;
            int minRedrawRow = this.findMinRedrawRow(startRowIndex - ((startRowIndex = startCell.getCoordinate().getRow()) > 0 ? 1 : 0));
            int maxRedrawRow = this.findMaxRedrawRow(startRowIndex + (startRowIndex < this.data.size() - 2 ? 1 : 0));
            for (int iRow = 0; iRow < expandedRow.size() - 1; ++iRow) {
                this.createEmptyRowElement(startRowIndex);
            }
            this.redrawRows(minRedrawRow, maxRedrawRow);
            this.eventBus.fireEvent((GwtEvent)ROW_GROUPING_EVENT);
        }
    }

    protected void clearSelection() {
        for (CellValue cell : this.selections) {
            cell.removeState(CellValue.CellState.SELECTED);
            this.deselectCell(cell);
        }
        this.selections.clear();
        this.rangeDirection = MOVE_DIRECTION.NONE;
        SelectedCellChangeEvent scce = new SelectedCellChangeEvent();
        this.eventBus.fireEvent((GwtEvent)scce);
    }

    abstract void createEmptyRowElement(int var1);

    abstract void createRowElement(int var1, DynamicDataRow var2);

    abstract void deleteRowElement(int var1);

    protected boolean isGroupWidgetClicked(Event event, Element target) {
        String tagName;
        String eventType = event.getType();
        return eventType.equals("mousedown") && "img".equalsIgnoreCase(tagName = target.getTagName());
    }

    abstract void redrawRows(int var1, int var2);

    abstract void removeRowElement(int var1);

    abstract void deselectCell(CellValue<? extends Comparable<?>> var1);

    void extendSelection(Coordinate end) {
        if (this.rangeOriginCell == null) {
            throw new IllegalArgumentException("origin has not been set. Unable to extend selection");
        }
        if (end == null) {
            throw new IllegalArgumentException("end cannot be null");
        }
        this.clearSelection();
        CellValue endCell = this.data.get(end);
        this.selectRange(this.rangeOriginCell, endCell);
        if (this.rangeOriginCell.getCoordinate().getRow() > endCell.getCoordinate().getRow()) {
            this.rangeExtentCell = (CellValue)this.selections.first();
            this.rangeDirection = MOVE_DIRECTION.UP;
        } else {
            this.rangeExtentCell = (CellValue)this.selections.last();
            this.rangeDirection = MOVE_DIRECTION.DOWN;
        }
    }

    void extendSelection(MOVE_DIRECTION dir) {
        if (this.selections.size() > 0) {
            CellValue activeCell = this.rangeExtentCell == null ? this.rangeOriginCell : this.rangeExtentCell;
            Coordinate nc = this.getNextCell(activeCell.getCoordinate(), dir);
            this.clearSelection();
            this.rangeDirection = dir;
            this.rangeExtentCell = this.data.get(nc);
            this.selectRange(this.rangeOriginCell, this.rangeExtentCell);
        }
    }

    CellSelectionDetail getSelectedCellExtents(CellValue<? extends Comparable<?>> cv) {
        if (cv == null) {
            throw new IllegalArgumentException("cv cannot be null");
        }
        if (!((DynamicColumn)this.columns.get(cv.getCoordinate().getCol())).isVisible()) {
            return null;
        }
        Coordinate hc = cv.getHtmlCoordinate();
        TableRowElement tre = (TableRowElement)((TableRowElement)this.tbody.getRows().getItem(hc.getRow())).cast();
        TableCellElement tce = (TableCellElement)((TableCellElement)tre.getCells().getItem(hc.getCol())).cast();
        int offsetX = tce.getOffsetLeft();
        int offsetY = tce.getOffsetTop();
        int w = tce.getOffsetWidth();
        int h = tce.getOffsetHeight();
        CellSelectionDetail e = new CellSelectionDetail(cv.getCoordinate(), offsetX, offsetY, h, w);
        return e;
    }

    void groupCells(Coordinate start) {
        if (start == null) {
            throw new IllegalArgumentException("start cannot be null");
        }
        CellValue startCell = this.data.get(start);
        if (startCell.getRowSpan() <= 1 && !startCell.isGrouped()) {
            return;
        }
        this.clearSelection();
        if (startCell.isGrouped()) {
            this.removeModelGrouping(startCell, true);
        } else {
            this.applyModelGrouping(startCell, true);
        }
    }

    abstract void hideColumn(int var1);

    void moveSelection(MOVE_DIRECTION dir) {
        if (this.selections.size() > 0) {
            CellValue activeCell = this.rangeExtentCell == null ? this.rangeOriginCell : this.rangeExtentCell;
            Coordinate nc = this.getNextCell(activeCell.getCoordinate(), dir);
            this.startSelecting(nc);
            this.rangeDirection = dir;
        }
    }

    abstract void resizeColumn(DynamicColumn<?> var1, int var2);

    abstract void selectCell(CellValue<? extends Comparable<?>> var1);

    void selectRange(CellValue<?> startCell, CellValue<?> endCell) {
        int col = startCell.getCoordinate().getCol();
        if (startCell.getCoordinate().getRow() > endCell.getCoordinate().getRow()) {
            CellValue swap = startCell;
            startCell = endCell;
            endCell = swap;
        }
        while (startCell.getRowSpan() == 0) {
            startCell = this.data.get(startCell.getCoordinate().getRow() - 1).get(col);
        }
        Coordinate nc = this.findMergedCellExtent(endCell.getCoordinate());
        endCell = this.data.get(nc);
        for (int iRow = startCell.getCoordinate().getRow(); iRow <= endCell.getCoordinate().getRow(); ++iRow) {
            CellValue cell = this.data.get(iRow).get(col);
            this.selections.add(cell);
            cell.addState(CellValue.CellState.SELECTED);
            this.selectCell(cell);
        }
        switch (2.$SwitchMap$org$drools$guvnor$client$widgets$drools$decoratedgrid$AbstractMergableGridWidget$MOVE_DIRECTION[this.rangeDirection.ordinal()]) {
            case 4: {
                this.rangeExtentCell = (CellValue)this.selections.last();
                break;
            }
            case 3: {
                this.rangeExtentCell = (CellValue)this.selections.first();
            }
        }
    }

    abstract void showColumn(int var1);

    void startSelecting(Coordinate start) {
        if (start == null) {
            throw new IllegalArgumentException("start cannot be null");
        }
        this.clearSelection();
        CellSelectionDetail ce = this.getSelectedCellExtents(this.data.get(start));
        SelectedCellChangeEvent scce = new SelectedCellChangeEvent(ce);
        this.eventBus.fireEvent((GwtEvent)scce);
        CellValue startCell = this.data.get(start);
        this.selectRange(startCell, startCell);
        this.rangeOriginCell = startCell;
        this.rangeExtentCell = null;
    }

    public void setData(DynamicData data) {
        this.data = data;
        this.rowMapper = new RowMapper(data);
    }

    public void setColumns(List<DynamicColumn<T>> columns) {
        this.columns = columns;
        this.reindexColumns();
    }

    public void onToggleMerging(ToggleMergingEvent event) {
        this.clearSelection();
        if (event.isMerged()) {
            if (!this.data.isMerged()) {
                this.data.setMerged(true);
                this.redraw();
            }
        } else if (this.data.isMerged()) {
            this.data.setMerged(false);
            this.redraw();
            this.eventBus.fireEvent((GwtEvent)ROW_GROUPING_EVENT);
        }
    }

    public void onDeleteRow(DeleteRowEvent event) {
        int index = this.rowMapper.mapToMergedRow(event.getIndex());
        this.clearSelection();
        this.data.deleteRow(index);
        if (!this.data.isMerged()) {
            this.removeRowElement(index);
        } else {
            this.removeRowElement(index);
            if (this.data.size() > 0) {
                int minRedrawRow = this.findMinRedrawRow(index - 1);
                int maxRedrawRow = this.findMaxRedrawRow(index - 1) + 1;
                if (maxRedrawRow > this.data.size() - 1) {
                    maxRedrawRow = this.data.size() - 1;
                }
                this.redrawRows(minRedrawRow, maxRedrawRow);
            }
        }
    }

    public void onInsertRow(InsertRowEvent event) {
        int index = this.rowMapper.mapToMergedRow(event.getIndex());
        DynamicDataRow rowData = this.cellValueFactory.makeUIRowData();
        this.insertRow(index, rowData);
    }

    public void onAppendRow(AppendRowEvent event) {
        int index = this.data.size();
        DynamicDataRow rowData = this.cellValueFactory.makeUIRowData();
        this.insertRow(index, rowData);
    }

    private void insertRow(int index, DynamicDataRow rowData) {
        this.clearSelection();
        int minRedrawRow = index;
        int maxRedrawRow = index;
        if (this.data.isMerged()) {
            if (index < this.data.size()) {
                minRedrawRow = this.findMinRedrawRow(index);
                maxRedrawRow = this.findMaxRedrawRow(index) + 1;
            } else {
                minRedrawRow = this.findMinRedrawRow(index > 0 ? index - 1 : index);
                maxRedrawRow = index;
            }
        }
        this.data.addRow(index, rowData);
        if (!this.data.isMerged()) {
            this.createRowElement(index, rowData);
        } else {
            this.createEmptyRowElement(index);
            this.redrawRows(minRedrawRow, maxRedrawRow);
        }
    }

    public void onDeleteColumn(DeleteColumnEvent event) {
        int index = event.getIndex();
        boolean bRedrawSidebar = false;
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            CellValue cv = this.data.get(iRow).get(index);
            if (!cv.isGrouped()) continue;
            this.removeModelGrouping(cv, false);
            bRedrawSidebar = true;
        }
        this.clearSelection();
        this.columns.remove(index);
        this.reindexColumns();
        this.data.deleteColumn(index);
        if (event.redraw()) {
            this.redraw();
            if (bRedrawSidebar) {
                this.eventBus.fireEvent((GwtEvent)ROW_GROUPING_EVENT);
            }
        }
    }

    public void onInsertInternalColumn(InsertInternalColumnEvent<T> event) {
        DynamicColumn column = event.getColumn();
        int index = event.getIndex();
        boolean redraw = event.redraw();
        List columnData = event.getData();
        this.clearSelection();
        this.columns.add(index, column);
        this.reindexColumns();
        this.data.addColumn(index, columnData, column.isVisible());
        if (redraw) {
            this.redrawColumns(index, this.columns.size() - 1);
        }
    }

    public void onSetInternalModel(SetInternalModelEvent<M, T> event) {
        this.setColumns(event.getColumns());
        this.setData(event.getData());
        this.redraw();
    }

    public void onSetColumnVisibility(SetColumnVisibilityEvent event) {
        int index = event.getIndex();
        boolean isVisible = event.isVisible();
        if (isVisible && !((DynamicColumn)this.columns.get(index)).isVisible()) {
            ((DynamicColumn)this.columns.get(index)).setVisible(isVisible);
            this.data.setColumnVisibility(index, isVisible);
            this.showColumn(index);
        } else if (!isVisible && ((DynamicColumn)this.columns.get(index)).isVisible()) {
            ((DynamicColumn)this.columns.get(index)).setVisible(isVisible);
            this.data.setColumnVisibility(index, isVisible);
            this.hideColumn(index);
        }
    }

    public void onUpdateColumnData(UpdateColumnDataEvent event) {
        int iRowIndex = 0;
        int iColIndex = event.getIndex();
        List columnData = event.getColumnData();
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow row = this.data.get(iRow);
            CellValue cell = (CellValue)columnData.get(iRowIndex);
            if (row instanceof GroupedDynamicDataRow) {
                GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)row;
                groupedRow.get(iColIndex).setValue((Object)cell.getValue());
                for (int iGroupedRow = 0; iGroupedRow < groupedRow.getChildRows().size(); ++iGroupedRow) {
                    cell = (CellValue)columnData.get(iRowIndex);
                    ((DynamicDataRow)groupedRow.getChildRows().get(iGroupedRow)).get(iColIndex).setValue((Object)cell.getValue());
                    ++iRowIndex;
                }
                continue;
            }
            row.get(iColIndex).setValue((Object)cell.getValue());
            ++iRowIndex;
        }
        this.redrawColumn(iColIndex);
    }

    public void onUpdateColumnDefinition(UpdateColumnDefinitionEvent event) {
        int index = event.getColumnIndex();
        DynamicColumn column = (DynamicColumn)this.columns.get(index);
        column.setCell(event.getCell());
        column.setSystemControlled(event.isSystemControlled());
        column.setSortable(event.isSortable());
    }

    public void onColumnResize(ColumnResizeEvent event) {
        this.resizeColumn(event.getColumn(), event.getWidth());
    }

    public void onMoveColumns(MoveColumnsEvent event) {
        int sourceColumnIndex = event.getSourceColumnIndex();
        int targetColumnIndex = event.getTargetColumnIndex();
        int numberOfColumns = event.getNumberOfColumns();
        int startRedrawIndex = sourceColumnIndex;
        int endRedrawIndex = targetColumnIndex;
        if (targetColumnIndex < sourceColumnIndex) {
            startRedrawIndex = targetColumnIndex;
            endRedrawIndex = sourceColumnIndex + numberOfColumns - 1;
        }
        if (targetColumnIndex > sourceColumnIndex) {
            for (int iCol = 0; iCol < numberOfColumns; ++iCol) {
                this.columns.add(targetColumnIndex, this.columns.remove(sourceColumnIndex));
                for (int iRow = 0; iRow < this.data.size(); ++iRow) {
                    DynamicDataRow row = this.data.get(iRow);
                    row.add(targetColumnIndex, row.remove(sourceColumnIndex));
                }
            }
        } else if (targetColumnIndex < sourceColumnIndex) {
            for (int iCol = 0; iCol < numberOfColumns; ++iCol) {
                this.columns.add(targetColumnIndex, this.columns.remove(sourceColumnIndex));
                for (int iRow = 0; iRow < this.data.size(); ++iRow) {
                    DynamicDataRow row = this.data.get(iRow);
                    row.add(targetColumnIndex, row.remove(sourceColumnIndex));
                }
                ++sourceColumnIndex;
                ++targetColumnIndex;
            }
        }
        this.reindexColumns();
        this.data.assertModelMerging();
        this.redrawColumns(startRedrawIndex, endRedrawIndex);
    }

    public void onSortData(SortDataEvent event) {
        ToggleMergingEvent tme = new ToggleMergingEvent(false);
        this.eventBus.fireEvent((GwtEvent)tme);
        List sortConfiguration = event.getSortConfiguration();
        this.data.sort(sortConfiguration);
        this.redraw();
        ArrayList changedData = new ArrayList();
        for (DynamicDataRow row : this.data) {
            ArrayList<CellValue> changedRow = new ArrayList<CellValue>();
            changedData.add(changedRow);
            for (int iCol = 0; iCol < row.size() - 1; ++iCol) {
                CellValue changedCell = row.get(iCol);
                changedRow.add(changedCell);
            }
        }
        UpdateModelEvent dce = new UpdateModelEvent(new Coordinate(0, 0), changedData);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    public void onCellValueChanged(CellValueChangedEvent event) {
        Comparable value = event.getValue();
        boolean bUngroupCells = false;
        Coordinate selection = ((CellValue)this.selections.first()).getCoordinate();
        ArrayList changedData = new ArrayList();
        if (this.selections.size() > 1) {
            for (CellValue cell : this.selections) {
                if (!(cell instanceof CellValue.GroupedCellValue)) continue;
                bUngroupCells = true;
                break;
            }
        }
        for (CellValue cell : this.selections) {
            Coordinate c = cell.getCoordinate();
            if (((DynamicColumn)this.columns.get(c.getCol())).isSystemControlled()) continue;
            this.data.set(c, (Object)value);
            if (value != null) {
                cell.removeState(CellValue.CellState.OTHERWISE);
            }
            if (cell instanceof CellValue.GroupedCellValue) {
                CellValue.GroupedCellValue gcv = (CellValue.GroupedCellValue)cell;
                for (int iChildValueIndex = 0; iChildValueIndex < gcv.getGroupedCells().size(); ++iChildValueIndex) {
                    ArrayList<CellValue> changedRow = new ArrayList<CellValue>();
                    changedRow.add(this.data.get(c));
                    changedData.add(changedRow);
                }
                continue;
            }
            ArrayList<CellValue> changedRow = new ArrayList<CellValue>();
            changedRow.add(this.data.get(c));
            changedData.add(changedRow);
        }
        if (bUngroupCells) {
            for (CellValue cell : this.selections) {
                if (!(cell instanceof CellValue.GroupedCellValue)) continue;
                this.removeModelGrouping(cell, true);
            }
        } else {
            this.data.assertModelMerging();
            int baseRowIndex = ((CellValue)this.selections.first()).getCoordinate().getRow();
            int minRedrawRow = this.findMinRedrawRow(baseRowIndex);
            int maxRedrawRow = this.findMaxRedrawRow(baseRowIndex);
            if (maxRedrawRow < ((CellValue)this.selections.last()).getCoordinate().getRow()) {
                maxRedrawRow = ((CellValue)this.selections.last()).getCoordinate().getRow();
            }
            this.redrawRows(minRedrawRow, maxRedrawRow);
        }
        this.startSelecting(selection);
        UpdateModelEvent dce = new UpdateModelEvent(((CellValue)this.selections.first()).getCoordinate(), changedData);
        this.eventBus.fireEvent((GwtEvent)dce);
    }

    public void onCellStateChanged(CellStateChangedEvent event) {
        Set states = event.getStates();
        boolean bUngroupCells = false;
        Coordinate selection = ((CellValue)this.selections.first()).getCoordinate();
        ArrayList changedData = new ArrayList();
        if (this.selections.size() > 1) {
            for (CellValue cell : this.selections) {
                if (!(cell instanceof CellValue.GroupedCellValue)) continue;
                bUngroupCells = true;
                break;
            }
        }
        for (CellValue cell : this.selections) {
            Coordinate c = cell.getCoordinate();
            if (((DynamicColumn)this.columns.get(c.getCol())).isSystemControlled()) continue;
            CellValue cv = this.data.get(c);
            for (CellStateChangedEvent.CellStateOperation state : states) {
                switch (2.$SwitchMap$org$drools$guvnor$client$widgets$drools$decoratedgrid$events$CellStateChangedEvent$Operation[state.getOperation().ordinal()]) {
                    case 1: {
                        cv.addState(state.getState());
                        if (state.getState() != CellValue.CellState.OTHERWISE) break;
                        cv.setValue(null);
                        break;
                    }
                    case 2: {
                        cv.removeState(state.getState());
                    }
                }
            }
            if (cell instanceof CellValue.GroupedCellValue) {
                CellValue.GroupedCellValue gcv = (CellValue.GroupedCellValue)cell;
                for (int iChildValueIndex = 0; iChildValueIndex < gcv.getGroupedCells().size(); ++iChildValueIndex) {
                    ArrayList<CellValue> changedRow = new ArrayList<CellValue>();
                    changedRow.add(this.data.get(c));
                    changedData.add(changedRow);
                }
                continue;
            }
            ArrayList<CellValue> changedRow = new ArrayList<CellValue>();
            changedRow.add(this.data.get(c));
            changedData.add(changedRow);
        }
        if (bUngroupCells) {
            for (CellValue cell : this.selections) {
                if (!(cell instanceof CellValue.GroupedCellValue)) continue;
                this.removeModelGrouping(cell, true);
            }
        } else {
            this.data.assertModelMerging();
            int baseRowIndex = ((CellValue)this.selections.first()).getCoordinate().getRow();
            int minRedrawRow = this.findMinRedrawRow(baseRowIndex);
            int maxRedrawRow = this.findMaxRedrawRow(baseRowIndex);
            if (maxRedrawRow < ((CellValue)this.selections.last()).getCoordinate().getRow()) {
                maxRedrawRow = ((CellValue)this.selections.last()).getCoordinate().getRow();
            }
            this.redrawRows(minRedrawRow, maxRedrawRow);
        }
        this.startSelecting(selection);
        UpdateModelEvent dce = new UpdateModelEvent(((CellValue)this.selections.first()).getCoordinate(), changedData);
        this.eventBus.fireEvent((GwtEvent)dce);
    }
}

