/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TableSectionElement;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import java.util.Set;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractCellValueFactory;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractMergableGridWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.AbstractVerticalMergableGridWidget;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellHeightCalculatorImpl;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.DecoratedGridCellValueAdaptor;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.ResourcesProvider;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.Coordinate;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.data.DynamicDataRow;
import org.drools.guvnor.client.widgets.drools.decoratedgrid.events.CellValueChangedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVerticalMergableGridWidget<M, T>
extends AbstractMergableGridWidget<M, T> {
    private CellHeightCalculatorImpl cellHeightCalculator = (CellHeightCalculatorImpl)GWT.create(CellHeightCalculatorImpl.class);

    public AbstractVerticalMergableGridWidget(ResourcesProvider<T> resources, AbstractCellValueFactory<T, ?> cellValueFactory, EventBus eventBus) {
        super(resources, cellValueFactory, eventBus);
    }

    public void onBrowserEvent(Event event) {
        DecoratedGridCellValueAdaptor cellWidget;
        Set consumedEvents;
        String eventType = event.getType();
        EventTarget eventTarget = event.getEventTarget();
        if (!Element.is((JavaScriptObject)eventTarget)) {
            return;
        }
        Element target = (Element)event.getEventTarget().cast();
        boolean bGroupWidgetClick = this.isGroupWidgetClicked(event, target);
        TableCellElement eventTableCell = this.findNearestParentCell(target);
        if (eventTableCell == null) {
            return;
        }
        int htmlCol = eventTableCell.getCellIndex();
        Element trElem = eventTableCell.getParentElement();
        if (trElem == null) {
            return;
        }
        TableRowElement tr = TableRowElement.as((Element)trElem);
        int htmlRow = tr.getSectionRowIndex();
        CellValue htmlCell = this.data.get(htmlRow).get(htmlCol);
        Coordinate eventPhysicalCoordinate = htmlCell.getPhysicalCoordinate();
        CellValue eventPhysicalCell = this.data.get(eventPhysicalCoordinate.getRow()).get(eventPhysicalCoordinate.getCol());
        if (eventType.equals("mousedown")) {
            this.handleMousedownEvent(event, eventPhysicalCoordinate, bGroupWidgetClick);
            return;
        }
        if (eventType.equals("mousemove")) {
            this.handleMousemoveEvent(event, eventPhysicalCoordinate);
            return;
        }
        if (eventType.equals("mouseup")) {
            this.handleMouseupEvent(event, eventPhysicalCoordinate);
            return;
        }
        if (eventType.equals("keydown")) {
            this.handleKeyboardNavigationEvent(event);
            if (event.getKeyCode() == 13) {
                switch (1.$SwitchMap$org$drools$guvnor$client$widgets$drools$decoratedgrid$AbstractMergableGridWidget$MOVE_DIRECTION[this.rangeDirection.ordinal()]) {
                    case 1: {
                        eventPhysicalCell = (CellValue)this.selections.first();
                        break;
                    }
                    case 2: {
                        eventPhysicalCell = (CellValue)this.selections.last();
                    }
                }
                eventPhysicalCoordinate = eventPhysicalCell.getCoordinate();
                eventTableCell = (TableCellElement)((TableRowElement)this.tbody.getRows().getItem(eventPhysicalCell.getHtmlCoordinate().getRow())).getCells().getItem(eventPhysicalCell.getHtmlCoordinate().getCol());
            }
        }
        if ((consumedEvents = (cellWidget = ((DynamicColumn)this.columns.get(eventPhysicalCoordinate.getCol())).getCell()).getConsumedEvents()) != null && consumedEvents.contains(eventType)) {
            Cell.Context context = new Cell.Context(eventPhysicalCoordinate.getRow(), eventPhysicalCoordinate.getCol(), (Object)eventPhysicalCoordinate);
            Element parent = eventTableCell.getFirstChildElement().getFirstChildElement();
            cellWidget.onBrowserEvent(context, parent, (Object)eventPhysicalCell, (NativeEvent)event, null);
        }
    }

    protected void redraw() {
        TableSectionElement nbody = Document.get().createTBodyElement();
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow rowData = this.data.get(iRow);
            TableRowElement tre = Document.get().createTRElement();
            tre.setClassName(this.getRowStyle(iRow));
            this.populateTableRowElement(tre, rowData);
            nbody.appendChild((Node)tre);
        }
        this.table.replaceChild((Node)nbody, (Node)this.tbody);
        this.tbody = nbody;
    }

    void redrawColumn(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index cannot be less than zero.");
        }
        if (index > this.columns.size()) {
            throw new IllegalArgumentException("index cannot be greater than the number of defined columns.");
        }
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            TableRowElement tre = (TableRowElement)this.tbody.getRows().getItem(iRow);
            DynamicDataRow rowData = this.data.get(iRow);
            this.redrawTableRowElement(rowData, tre, index, index);
        }
    }

    void redrawColumns(int startRedrawIndex, int endRedrawIndex) {
        if (startRedrawIndex < 0) {
            throw new IllegalArgumentException("startRedrawIndex cannot be less than zero.");
        }
        if (startRedrawIndex > this.columns.size()) {
            throw new IllegalArgumentException("startRedrawIndex cannot be greater than the number of defined columns.");
        }
        if (endRedrawIndex < 0) {
            throw new IllegalArgumentException("endRedrawIndex cannot be less than zero.");
        }
        if (endRedrawIndex > this.columns.size()) {
            throw new IllegalArgumentException("endRedrawIndex cannot be greater than the number of defined columns.");
        }
        if (startRedrawIndex > endRedrawIndex) {
            throw new IllegalArgumentException("startRedrawIndex cannot be greater than endRedrawIndex.");
        }
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            TableRowElement tre = (TableRowElement)this.tbody.getRows().getItem(iRow);
            DynamicDataRow rowData = this.data.get(iRow);
            this.redrawTableRowElement(rowData, tre, startRedrawIndex, endRedrawIndex);
        }
    }

    public void resizeColumn(DynamicColumn<?> col, int width) {
        if (col == null) {
            throw new IllegalArgumentException("col cannot be null");
        }
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        col.setWidth(width);
        int iCol = col.getColumnIndex();
        for (DynamicDataRow row : this.data) {
            CellValue cell = row.get(iCol);
            Coordinate c = cell.getHtmlCoordinate();
            TableRowElement tre = (TableRowElement)this.tbody.getRows().getItem(c.getRow());
            TableCellElement tce = (TableCellElement)tre.getCells().getItem(c.getCol());
            DivElement div = (DivElement)tce.getFirstChild().cast();
            DivElement divText = (DivElement)tce.getFirstChild().getFirstChild().cast();
            tce.getStyle().setWidth((double)width, Style.Unit.PX);
            div.getStyle().setWidth((double)width, Style.Unit.PX);
            divText.getStyle().setWidth((double)width, Style.Unit.PX);
        }
    }

    private TableCellElement findNearestParentCell(Element elem) {
        while (elem != null && elem != this.table) {
            String tagName = elem.getTagName();
            if ("td".equalsIgnoreCase(tagName) || "th".equalsIgnoreCase(tagName)) {
                return (TableCellElement)elem.cast();
            }
            elem = elem.getParentElement();
        }
        return null;
    }

    private void fixRowStyles(int iRow) {
        while (iRow < this.tbody.getChildCount()) {
            Element e = Element.as((Node)this.tbody.getChild(iRow));
            TableRowElement tre = TableRowElement.as((Element)e);
            tre.setClassName(this.getRowStyle(iRow));
            ++iRow;
        }
    }

    private String getRowStyle(int iRow) {
        String evenRowStyle = this.resources.cellTableEvenRow();
        String oddRowStyle = this.resources.cellTableOddRow();
        boolean isEven = iRow % 2 == 0;
        String trClasses = isEven ? evenRowStyle : oddRowStyle;
        return trClasses;
    }

    private void handleKeyboardNavigationEvent(Event event) {
        if (event.getKeyCode() == 46) {
            for (CellValue cell : this.selections) {
                cell.removeState(CellValue.CellState.OTHERWISE);
            }
            this.eventBus.fireEvent((GwtEvent)new CellValueChangedEvent(null));
            return;
        }
        if (event.getKeyCode() == 39 || event.getKeyCode() == 9 && !event.getShiftKey()) {
            this.moveSelection(AbstractMergableGridWidget.MOVE_DIRECTION.RIGHT);
            event.preventDefault();
            return;
        }
        if (event.getKeyCode() == 37 || event.getKeyCode() == 9 && event.getShiftKey()) {
            this.moveSelection(AbstractMergableGridWidget.MOVE_DIRECTION.LEFT);
            event.preventDefault();
            return;
        }
        if (event.getKeyCode() == 38) {
            if (event.getShiftKey()) {
                this.extendSelection(AbstractMergableGridWidget.MOVE_DIRECTION.UP);
            } else {
                this.moveSelection(AbstractMergableGridWidget.MOVE_DIRECTION.UP);
            }
            event.preventDefault();
            return;
        }
        if (event.getKeyCode() == 40) {
            if (event.getShiftKey()) {
                this.extendSelection(AbstractMergableGridWidget.MOVE_DIRECTION.DOWN);
            } else {
                this.moveSelection(AbstractMergableGridWidget.MOVE_DIRECTION.DOWN);
            }
            event.preventDefault();
            return;
        }
    }

    private void handleMousedownEvent(Event event, Coordinate eventCoordinate, boolean bGroupWidgetClick) {
        if (event.getButton() == 1) {
            if (bGroupWidgetClick) {
                this.groupCells(eventCoordinate);
            } else {
                if (event.getShiftKey()) {
                    this.extendSelection(eventCoordinate);
                    return;
                }
                this.startSelecting(eventCoordinate);
                this.bDragOperationPrimed = true;
                return;
            }
        }
    }

    private void handleMousemoveEvent(Event event, Coordinate eventCoordinate) {
        if (event.getButton() == 1 && this.bDragOperationPrimed) {
            this.extendSelection(eventCoordinate);
            return;
        }
    }

    private void handleMouseupEvent(Event event, Coordinate eventCoordinate) {
        this.bDragOperationPrimed = false;
    }

    private TableCellElement makeTableCellElement(int iCol, DynamicDataRow rowData) {
        TableCellElement tce = null;
        DynamicColumn column = (DynamicColumn)this.columns.get(iCol);
        CellValue cellData = rowData.get(iCol);
        int rowSpan = cellData.getRowSpan();
        if (rowSpan > 0) {
            tce = Document.get().createTDElement();
            DivElement div = Document.get().createDivElement();
            DivElement divText = Document.get().createDivElement();
            tce.addClassName(this.resources.cellTableCell());
            tce.addClassName(this.resources.cellTableColumn(column.getModelColumn()));
            div.setClassName(this.resources.cellTableCellDiv());
            divText.addClassName(this.resources.cellTableTextDiv());
            int colWidth = column.getWidth();
            div.getStyle().setWidth((double)colWidth, Style.Unit.PX);
            divText.getStyle().setWidth((double)colWidth, Style.Unit.PX);
            tce.getStyle().setWidth((double)colWidth, Style.Unit.PX);
            int divHeight = this.cellHeightCalculator.calculateHeight(rowSpan);
            div.getStyle().setHeight((double)divHeight, Style.Unit.PX);
            tce.setRowSpan(rowSpan);
            if (cellData.isOtherwise()) {
                tce.addClassName(this.resources.cellTableCellOtherwise());
            } else {
                tce.removeClassName(this.resources.cellTableCellOtherwise());
            }
            if (cellData instanceof CellValue.GroupedCellValue) {
                CellValue.GroupedCellValue gcv = (CellValue.GroupedCellValue)cellData;
                if (gcv.hasMultipleValues()) {
                    tce.addClassName(this.resources.cellTableCellMultipleValues());
                }
            } else {
                tce.removeClassName(this.resources.cellTableCellMultipleValues());
            }
            if (cellData.isSelected()) {
                tce.addClassName(this.resources.cellTableCellSelected());
            } else {
                tce.removeClassName(this.resources.cellTableCellSelected());
            }
            SafeHtmlBuilder cellBuilder = new SafeHtmlBuilder();
            if (!cellData.isOtherwise()) {
                Coordinate c = cellData.getCoordinate();
                Cell.Context context = new Cell.Context(c.getRow(), c.getCol(), (Object)c);
                column.render(context, rowData, cellBuilder);
            } else {
                cellBuilder.appendEscaped("<otherwise>");
            }
            divText.setInnerHTML(cellBuilder.toSafeHtml().asString());
            tce.appendChild((Node)div);
            div.appendChild((Node)divText);
            tce.setTabIndex(0);
            if (rowSpan > 1 || cellData.isGrouped()) {
                com.google.gwt.user.client.Element de = DOM.createDiv();
                DivElement divGroup = DivElement.as((Element)de);
                divGroup.setTitle(messages.groupCells());
                divGroup.addClassName(this.resources.cellTableGroupDiv());
                if (cellData.isGrouped()) {
                    divGroup.setInnerHTML(this.selectorUngroupedCellsHtml);
                } else {
                    divGroup.setInnerHTML(this.selectorGroupedCellsHtml);
                }
                div.appendChild((Node)divGroup);
            }
        }
        return tce;
    }

    private TableRowElement populateTableRowElement(TableRowElement tre, DynamicDataRow rowData) {
        tre.getStyle().setHeight((double)this.resources.rowHeight(), Style.Unit.PX);
        for (int iCol = 0; iCol < this.columns.size(); ++iCol) {
            TableCellElement tce;
            DynamicColumn column = (DynamicColumn)this.columns.get(iCol);
            if (!column.isVisible() || (tce = this.makeTableCellElement(iCol, rowData)) == null) continue;
            tre.appendChild((Node)tce);
        }
        return tre;
    }

    private void redrawTableRowElement(DynamicDataRow rowData, TableRowElement tre, int startColIndex, int endColIndex) {
        for (int iCol = startColIndex; iCol <= endColIndex; ++iCol) {
            TableCellElement newCell;
            DynamicColumn column = (DynamicColumn)this.columns.get(iCol);
            if (!column.isVisible()) continue;
            int maxColumnIndex = tre.getCells().getLength() - 1;
            int requiredColumnIndex = rowData.get(iCol).getHtmlCoordinate().getCol();
            if (requiredColumnIndex > maxColumnIndex) {
                newCell = this.makeTableCellElement(iCol, rowData);
                if (newCell == null) continue;
                tre.appendChild((Node)newCell);
                continue;
            }
            newCell = this.makeTableCellElement(iCol, rowData);
            if (newCell == null) continue;
            TableCellElement oldCell = (TableCellElement)tre.getCells().getItem(requiredColumnIndex);
            tre.replaceChild((Node)newCell, (Node)oldCell);
        }
    }

    protected void createEmptyRowElement(int index) {
        this.tbody.insertRow(index);
        this.fixRowStyles(index);
    }

    protected void createRowElement(int index, DynamicDataRow rowData) {
        TableRowElement tre = this.tbody.insertRow(index);
        this.populateTableRowElement(tre, rowData);
        this.fixRowStyles(index);
    }

    protected void deleteRowElement(int index) {
        Node tre = this.tbody.getChild(index);
        this.tbody.removeChild(tre);
    }

    protected void redrawRows(int startRedrawIndex, int endRedrawIndex) {
        if (startRedrawIndex < 0) {
            throw new IllegalArgumentException("startRedrawIndex cannot be less than zero.");
        }
        if (startRedrawIndex > this.data.size()) {
            throw new IllegalArgumentException("startRedrawIndex cannot be greater than the number of rows in the table.");
        }
        if (endRedrawIndex < 0) {
            throw new IllegalArgumentException("endRedrawIndex cannot be less than zero.");
        }
        if (endRedrawIndex > this.data.size()) {
            throw new IllegalArgumentException("endRedrawIndex cannot be greater than the number of rows in the table.");
        }
        if (startRedrawIndex > endRedrawIndex) {
            throw new IllegalArgumentException("startRedrawIndex cannot be greater than endRedrawIndex.");
        }
        for (int iRow = startRedrawIndex; iRow <= endRedrawIndex; ++iRow) {
            DynamicDataRow rowData = this.data.get(iRow);
            TableRowElement tre = Document.get().createTRElement();
            this.populateTableRowElement(tre, rowData);
            this.tbody.replaceChild((Node)tre, this.tbody.getChild(iRow));
        }
        this.fixRowStyles(startRedrawIndex);
    }

    protected void removeRowElement(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index cannot be less than zero.");
        }
        if (index > this.data.size()) {
            throw new IllegalArgumentException("Index cannot be greater than the number of rows.");
        }
        this.tbody.deleteRow(index);
        this.fixRowStyles(index);
    }

    void deselectCell(CellValue<? extends Comparable<?>> cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell cannot be null");
        }
        Coordinate hc = cell.getHtmlCoordinate();
        TableRowElement tre = (TableRowElement)((TableRowElement)this.tbody.getRows().getItem(hc.getRow())).cast();
        TableCellElement tce = (TableCellElement)((TableCellElement)tre.getCells().getItem(hc.getCol())).cast();
        if (tce != null) {
            CellValue.GroupedCellValue gcv;
            String cellSelectedStyle = this.resources.cellTableCellSelected();
            String cellMultipleValuesStyle = this.resources.cellTableCellMultipleValues();
            String cellOtherwiseStyle = this.resources.cellTableCellOtherwise();
            tce.removeClassName(cellSelectedStyle);
            if (cell.isOtherwise()) {
                tce.addClassName(cellOtherwiseStyle);
            }
            if (cell instanceof CellValue.GroupedCellValue && (gcv = (CellValue.GroupedCellValue)cell).hasMultipleValues()) {
                tce.addClassName(cellMultipleValuesStyle);
            }
        }
    }

    void hideColumn(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index cannot be less than zero");
        }
        if (index > this.columns.size()) {
            throw new IllegalArgumentException("index cannot be greater than the number of rows");
        }
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow rowData = this.data.get(iRow);
            CellValue cell = rowData.get(index);
            if (cell.getRowSpan() <= 0) continue;
            Coordinate hc = cell.getHtmlCoordinate();
            TableRowElement tre = (TableRowElement)this.tbody.getRows().getItem(hc.getRow());
            TableCellElement tce = (TableCellElement)tre.getCells().getItem(hc.getCol());
            tre.removeChild((Node)tce);
        }
    }

    void selectCell(CellValue<? extends Comparable<?>> cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell cannot be null");
        }
        Coordinate hc = cell.getHtmlCoordinate();
        TableRowElement tre = (TableRowElement)((TableRowElement)this.tbody.getRows().getItem(hc.getRow())).cast();
        TableCellElement tce = (TableCellElement)((TableCellElement)tre.getCells().getItem(hc.getCol())).cast();
        String cellSelectedStyle = this.resources.cellTableCellSelected();
        String cellOtherwiseStyle = this.resources.cellTableCellOtherwise();
        String cellMultipleValuesStyle = this.resources.cellTableCellMultipleValues();
        tce.removeClassName(cellMultipleValuesStyle);
        tce.removeClassName(cellOtherwiseStyle);
        tce.addClassName(cellSelectedStyle);
        tce.focus();
    }

    void showColumn(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index cannot be less than zero");
        }
        if (index > this.columns.size()) {
            throw new IllegalArgumentException("index cannot be greater than the number of rows");
        }
        for (int iRow = 0; iRow < this.data.size(); ++iRow) {
            DynamicDataRow rowData = this.data.get(iRow);
            TableCellElement tce = this.makeTableCellElement(index, rowData);
            if (tce == null) continue;
            CellValue cell = rowData.get(index);
            Coordinate hc = cell.getHtmlCoordinate();
            TableRowElement tre = (TableRowElement)this.tbody.getRows().getItem(hc.getRow());
            TableCellElement ntce = tre.insertCell(hc.getCol());
            tre.replaceChild((Node)tce, (Node)ntce);
        }
    }
}

