/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.decoratedgrid;

import com.google.gwt.cell.client.AbstractEditableCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckboxCellImpl
extends AbstractEditableCell<Boolean, Boolean> {
    private static final SafeHtml INPUT_CHECKED = SafeHtmlUtils.fromSafeConstant((String)"<input type=\"checkbox\" tabindex=\"-1\" checked/>");
    private static final SafeHtml INPUT_UNCHECKED = SafeHtmlUtils.fromSafeConstant((String)"<input type=\"checkbox\" tabindex=\"-1\"/>");

    public CheckboxCellImpl() {
        super(new String[]{"change", "keydown"});
    }

    CheckboxCellImpl(String ... consumedEvents) {
        super(consumedEvents);
    }

    public boolean isEditing(Cell.Context context, Element parent, Boolean value) {
        return false;
    }

    public void onBrowserEvent(Cell.Context context, Element parent, Boolean value, NativeEvent event, ValueUpdater<Boolean> valueUpdater) {
        boolean enterPressed;
        String type = event.getType();
        boolean bl = enterPressed = "keydown".equals(type) && event.getKeyCode() == 13;
        if ("change".equals(type) || enterPressed) {
            InputElement input = (InputElement)parent.getFirstChild().cast();
            Boolean isChecked = input.isChecked();
            if (enterPressed) {
                isChecked = isChecked == false;
                input.setChecked(isChecked.booleanValue());
            }
            if (value != isChecked) {
                this.setViewData(context.getKey(), (Object)isChecked);
            }
            if (valueUpdater != null) {
                valueUpdater.update((Object)isChecked);
            }
        }
    }

    public void render(Cell.Context context, Boolean value, SafeHtmlBuilder sb) {
        Object key = context.getKey();
        Boolean viewData = (Boolean)this.getViewData(key);
        if (viewData != null && viewData.equals(value)) {
            this.clearViewData(key);
            viewData = null;
        }
        if (value != null && (viewData != null ? viewData : value).booleanValue()) {
            sb.append(INPUT_CHECKED);
        } else {
            sb.append(INPUT_UNCHECKED);
        }
    }
}

