/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.guvnor.client.decisiontable.DTCellValueWidgetFactory;
import org.drools.guvnor.client.decisiontable.Validator;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.resources.WizardCellListResources;
import org.drools.guvnor.client.resources.WizardResources;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.AvailableField;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.FactPatternConstraintsPageView;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.FactPatternConstraintsPageViewImpl;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.MinimumWidthCellList;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.cells.AvailableFieldCell;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.cells.ConditionCell;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.cells.ConditionPatternCell;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactPatternConstraintsPageViewImpl
extends Composite
implements FactPatternConstraintsPageView {
    private FactPatternConstraintsPageView.Presenter presenter;
    private Validator validator;
    private List<Pattern52> availablePatterns;
    private Pattern52 availablePatternsSelection;
    private MinimumWidthCellList<Pattern52> availablePatternsWidget;
    private Set<AvailableField> availableFieldsSelections;
    private MinimumWidthCellList<AvailableField> availableFieldsWidget;
    private List<ConditionCol52> chosenConditions;
    private ConditionCol52 chosenConditionsSelection;
    private Set<ConditionCol52> chosenConditionsSelections;
    private MinimumWidthCellList<ConditionCol52> chosenConditionsWidget;
    private boolean isOperatorValid;
    private DTCellValueWidgetFactory factory;
    private static final Constants constants = (Constants)GWT.create(Constants.class);
    private static final Images images = (Images)GWT.create(Images.class);
    @UiField
    protected ScrollPanel availablePatternsContainer;
    @UiField
    protected ScrollPanel availableFieldsContainer;
    @UiField
    protected ScrollPanel chosenConditionsContainer;
    @UiField
    protected PushButton btnAdd;
    @UiField
    protected PushButton btnRemove;
    @UiField
    VerticalPanel conditionDefinition;
    @UiField
    HorizontalPanel calculationType;
    @UiField
    RadioButton optLiteral;
    @UiField
    RadioButton optFormula;
    @UiField
    RadioButton optPredicate;
    @UiField
    TextBox txtColumnHeader;
    @UiField
    HorizontalPanel columnHeaderContainer;
    @UiField
    TextBox txtPredicateExpression;
    @UiField
    HorizontalPanel predicateExpressionContainer;
    @UiField
    HorizontalPanel operatorContainer;
    @UiField
    SimplePanel ddOperatorContainer;
    @UiField
    TextBox txtValueList;
    @UiField
    TextBox txtDefaultValue;
    @UiField
    HorizontalPanel msgDuplicateBindings;
    @UiField
    HorizontalPanel msgIncompleteConditions;
    @UiField
    VerticalPanel criteriaExtendedEntry;
    @UiField
    VerticalPanel criteriaLimitedEntry;
    @UiField
    HorizontalPanel limitedEntryValueContainer;
    @UiField
    SimplePanel limitedEntryValueWidgetContainer;
    @UiField(provided=true)
    PushButton btnMoveUp = new PushButton(AbstractImagePrototype.create((ImageResource)images.shuffleUp()).createImage());
    @UiField(provided=true)
    PushButton btnMoveDown = new PushButton(AbstractImagePrototype.create((ImageResource)images.shuffleDown()).createImage());
    private static FactPatternConstraintsPageWidgetBinder uiBinder = (FactPatternConstraintsPageWidgetBinder)GWT.create(FactPatternConstraintsPageWidgetBinder.class);

    public FactPatternConstraintsPageViewImpl(Validator validator) {
        this.validator = validator;
        this.availablePatternsWidget = new MinimumWidthCellList((Cell)new ConditionPatternCell(validator), (CellList.Resources)WizardCellListResources.INSTANCE);
        this.availableFieldsWidget = new MinimumWidthCellList((Cell)new AvailableFieldCell(), (CellList.Resources)WizardCellListResources.INSTANCE);
        this.chosenConditionsWidget = new MinimumWidthCellList((Cell)new ConditionCell(validator), (CellList.Resources)WizardCellListResources.INSTANCE);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.initialiseAvailablePatterns();
        this.initialiseAvailableFields();
        this.initialiseChosenFields();
        this.initialiseCalculationTypes();
        this.initialiseColumnHeader();
        this.initialisePredicateExpression();
        this.initialiseDefaultValue();
        this.initialiseValueList();
        this.initialiseShufflers();
    }

    private void initialiseAvailablePatterns() {
        this.availablePatternsContainer.add((Widget)this.availablePatternsWidget);
        this.availablePatternsWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.availablePatternsWidget.setMinimumWidth(175);
        Label lstEmpty = new Label(constants.DecisionTableWizardNoAvailablePatterns());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.availablePatternsWidget.setEmptyListWidget((Widget)lstEmpty);
        SingleSelectionModel selectionModel = new SingleSelectionModel();
        this.availablePatternsWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initialiseAvailableFields() {
        this.availableFieldsContainer.add((Widget)this.availableFieldsWidget);
        this.availableFieldsWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.availableFieldsWidget.setMinimumWidth(175);
        Label lstEmpty = new Label(constants.DecisionTableWizardNoAvailableFields());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.availableFieldsWidget.setEmptyListWidget((Widget)lstEmpty);
        MultiSelectionModel selectionModel = new MultiSelectionModel();
        this.availableFieldsWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initialiseChosenFields() {
        this.chosenConditionsContainer.add((Widget)this.chosenConditionsWidget);
        this.chosenConditionsWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.chosenConditionsWidget.setMinimumWidth(175);
        Label lstEmpty = new Label(constants.DecisionTableWizardNoChosenFields());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.chosenConditionsWidget.setEmptyListWidget((Widget)lstEmpty);
        MultiSelectionModel selectionModel = new MultiSelectionModel();
        this.chosenConditionsWidget.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void validateConditionHeader() {
        if (this.validator.isConditionHeaderValid(this.chosenConditionsSelection)) {
            this.columnHeaderContainer.setStyleName(WizardResources.INSTANCE.style().wizardDTableFieldContainerValid());
        } else {
            this.columnHeaderContainer.setStyleName(WizardResources.INSTANCE.style().wizardDTableFieldContainerInvalid());
        }
    }

    private void validateConditionOperator() {
        this.isOperatorValid = this.validator.isConditionOperatorValid(this.chosenConditionsSelection);
        if (this.isOperatorValid) {
            this.operatorContainer.setStyleName(WizardResources.INSTANCE.style().wizardDTableFieldContainerValid());
        } else {
            this.operatorContainer.setStyleName(WizardResources.INSTANCE.style().wizardDTableFieldContainerInvalid());
        }
    }

    private void initialiseCalculationTypes() {
        this.optLiteral.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.optFormula.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.optPredicate.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initialiseColumnHeader() {
        this.txtColumnHeader.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initialisePredicateExpression() {
        this.txtPredicateExpression.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initialiseDefaultValue() {
        this.txtDefaultValue.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initialiseValueList() {
        this.txtValueList.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initialiseShufflers() {
        this.btnMoveUp.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.btnMoveDown.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void enableMoveUpButton() {
        if (this.chosenConditions == null || this.chosenConditionsSelection == null) {
            this.btnMoveUp.setEnabled(false);
            return;
        }
        int index = this.chosenConditions.indexOf(this.chosenConditionsSelection);
        this.btnMoveUp.setEnabled(index > 0);
    }

    private void enableMoveDownButton() {
        if (this.chosenConditions == null || this.chosenConditionsSelection == null) {
            this.btnMoveDown.setEnabled(false);
            return;
        }
        int index = this.chosenConditions.indexOf(this.chosenConditionsSelection);
        this.btnMoveDown.setEnabled(index < this.chosenConditions.size() - 1);
    }

    public void setPresenter(FactPatternConstraintsPageView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void setDTCellValueWidgetFactory(DTCellValueWidgetFactory factory) {
        this.factory = factory;
    }

    public void setAreConditionsDefined(boolean areConditionsDefined) {
        this.msgIncompleteConditions.setVisible(!areConditionsDefined);
        this.chosenConditionsWidget.redraw();
        this.availablePatternsWidget.redraw();
    }

    public void setArePatternBindingsUnique(boolean arePatternBindingsUnique) {
        this.msgDuplicateBindings.setVisible(!arePatternBindingsUnique);
        this.availablePatternsWidget.redraw();
    }

    public void setAvailablePatterns(List<Pattern52> patterns) {
        this.availablePatterns = patterns;
        this.availablePatternsWidget.setRowCount(this.availablePatterns.size(), true);
        this.availablePatternsWidget.setRowData(this.availablePatterns);
        if (this.availablePatternsSelection != null) {
            if (!this.availablePatterns.contains(this.availablePatternsSelection)) {
                this.availablePatternsWidget.getSelectionModel().setSelected((Object)this.availablePatternsSelection, false);
                this.availablePatternsSelection = null;
                this.setAvailableFields(new ArrayList());
                this.availableFieldsSelections = null;
                this.setChosenConditions(new ArrayList());
                this.chosenConditionsSelection = null;
                this.conditionDefinition.setVisible(false);
                this.msgIncompleteConditions.setVisible(false);
            }
        } else {
            this.setAvailableFields(new ArrayList());
            this.setChosenConditions(new ArrayList());
        }
    }

    public void setAvailableFields(List<AvailableField> fields) {
        this.availableFieldsWidget.setRowCount(fields.size(), true);
        this.availableFieldsWidget.setRowData(fields);
    }

    public void setChosenConditions(List<ConditionCol52> conditions) {
        this.chosenConditions = conditions;
        this.chosenConditionsWidget.setRowCount(conditions.size(), true);
        this.chosenConditionsWidget.setRowData(conditions);
        this.conditionDefinition.setVisible(conditions.contains(this.chosenConditionsSelection));
        this.enableMoveUpButton();
        this.enableMoveDownButton();
        this.presenter.stateChanged();
    }

    @UiHandler(value={"btnAdd"})
    public void btnAddClick(ClickEvent event) {
        for (AvailableField f : this.availableFieldsSelections) {
            this.chosenConditions.add(this.makeNewConditionColumn(f));
        }
        this.setChosenConditions(this.chosenConditions);
        this.availablePatternsSelection.setChildColumns(this.chosenConditions);
        this.presenter.stateChanged();
    }

    private ConditionCol52 makeNewConditionColumn(AvailableField f) {
        GuidedDecisionTable52.TableFormat format = this.presenter.getTableFormat();
        if (format == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            ConditionCol52 c = new ConditionCol52();
            c.setFactField(f.getName());
            c.setFieldType(f.getType());
            c.setConstraintValueType(f.getCalculationType());
            return c;
        }
        LimitedEntryConditionCol52 c = new LimitedEntryConditionCol52();
        c.setFactField(f.getName());
        c.setFieldType(f.getType());
        c.setConstraintValueType(1);
        return c;
    }

    @UiHandler(value={"btnRemove"})
    public void btnRemoveClick(ClickEvent event) {
        for (ConditionCol52 c : this.chosenConditionsSelections) {
            this.chosenConditions.remove(c);
        }
        this.chosenConditionsSelections.clear();
        this.setChosenConditions(this.chosenConditions);
        this.availablePatternsSelection.setChildColumns(this.chosenConditions);
        this.presenter.stateChanged();
        this.txtColumnHeader.setText("");
        this.txtValueList.setText("");
        this.txtDefaultValue.setText("");
        this.conditionDefinition.setVisible(false);
        this.btnRemove.setEnabled(false);
    }

    static /* synthetic */ Pattern52 access$002(FactPatternConstraintsPageViewImpl x0, Pattern52 x1) {
        x0.availablePatternsSelection = x1;
        return x0.availablePatternsSelection;
    }

    static /* synthetic */ Pattern52 access$000(FactPatternConstraintsPageViewImpl x0) {
        return x0.availablePatternsSelection;
    }

    static /* synthetic */ FactPatternConstraintsPageView.Presenter access$100(FactPatternConstraintsPageViewImpl x0) {
        return x0.presenter;
    }

    static /* synthetic */ Set access$202(FactPatternConstraintsPageViewImpl x0, Set x1) {
        x0.availableFieldsSelections = x1;
        return x0.availableFieldsSelections;
    }

    static /* synthetic */ Set access$200(FactPatternConstraintsPageViewImpl x0) {
        return x0.availableFieldsSelections;
    }

    static /* synthetic */ Set access$302(FactPatternConstraintsPageViewImpl x0, Set x1) {
        x0.chosenConditionsSelections = x1;
        return x0.chosenConditionsSelections;
    }

    static /* synthetic */ Set access$300(FactPatternConstraintsPageViewImpl x0) {
        return x0.chosenConditionsSelections;
    }

    static /* synthetic */ ConditionCol52 access$402(FactPatternConstraintsPageViewImpl x0, ConditionCol52 x1) {
        x0.chosenConditionsSelection = x1;
        return x0.chosenConditionsSelection;
    }

    static /* synthetic */ void access$500(FactPatternConstraintsPageViewImpl x0) {
        x0.validateConditionHeader();
    }

    static /* synthetic */ void access$600(FactPatternConstraintsPageViewImpl x0) {
        x0.validateConditionOperator();
    }

    static /* synthetic */ void access$700(FactPatternConstraintsPageViewImpl x0) {
        x0.enableMoveUpButton();
    }

    static /* synthetic */ void access$800(FactPatternConstraintsPageViewImpl x0) {
        x0.enableMoveDownButton();
    }

    static /* synthetic */ ConditionCol52 access$400(FactPatternConstraintsPageViewImpl x0) {
        return x0.chosenConditionsSelection;
    }

    static /* synthetic */ Validator access$1000(FactPatternConstraintsPageViewImpl x0) {
        return x0.validator;
    }

    static /* synthetic */ DTCellValueWidgetFactory access$1100(FactPatternConstraintsPageViewImpl x0) {
        return x0.factory;
    }

    static /* synthetic */ MinimumWidthCellList access$1200(FactPatternConstraintsPageViewImpl x0) {
        return x0.chosenConditionsWidget;
    }

    static /* synthetic */ List access$1300(FactPatternConstraintsPageViewImpl x0) {
        return x0.chosenConditions;
    }
}

