/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.builder.AssemblyErrorLogger;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.server.util.BRDRLPersistence;
import org.drools.ide.common.server.util.BRLPersistence;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.repository.AssetItem;

public class BRLContentHandler
extends ContentHandler
implements IRuleAsset {
    public void retrieveAssetContent(RuleAsset asset, AssetItem item) throws SerializationException {
        RuleModel ruleModel = this.getBrlXmlPersistence().unmarshal(item.getContent());
        ruleModel.name = asset.getName();
        asset.setContent((PortableObject)ruleModel);
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializationException {
        RuleModel data = (RuleModel)asset.getContent();
        if (data.name == null) {
            data.name = repoAsset.getName();
        }
        repoAsset.updateContent(this.getBrlXmlPersistence().marshal(data));
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, AssemblyErrorLogger logger) throws DroolsParserException, IOException {
        builder.addPackageFromDrl((Reader)new StringReader(this.getSourceDRL(this.buildModelFromAsset(asset), builder)));
    }

    public void assembleDRL(BRMSPackageBuilder builder, RuleAsset asset, StringBuilder stringBuilder) {
        String drl = this.getSourceDRL((RuleModel)asset.getContent(), builder);
        stringBuilder.append(drl);
    }

    public void assembleDRL(BRMSPackageBuilder builder, AssetItem asset, StringBuilder stringBuilder) {
        String drl = this.getSourceDRL(this.buildModelFromAsset(asset), builder);
        stringBuilder.append(drl);
    }

    private String getSourceDRL(RuleModel model, BRMSPackageBuilder builder) {
        String drl = this.getBrlDrlPersistence().marshal(model);
        if (builder.hasDSL() && model.hasDSLSentences()) {
            drl = builder.getDSLExpander().expand(drl);
        }
        return drl;
    }

    protected RuleModel buildModelFromAsset(AssetItem asset) {
        RuleModel model = this.getBrlXmlPersistence().unmarshal(asset.getContent());
        model.name = asset.getName();
        model.parentName = this.parentNameFromCategory(asset, model.parentName);
        return model;
    }

    public String getRawDRL(AssetItem asset) {
        RuleModel model = this.getBrlXmlPersistence().unmarshal(asset.getContent());
        return this.getBrlDrlPersistence().marshal(model);
    }

    protected BRLPersistence getBrlDrlPersistence() {
        return BRDRLPersistence.getInstance();
    }

    protected BRLPersistence getBrlXmlPersistence() {
        return BRXMLPersistence.getInstance();
    }
}

