/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.server.contenthandler.IHasCustomValidator;
import org.drools.guvnor.server.contenthandler.PlainTextContentHandler;
import org.drools.guvnor.server.contenthandler.SpringContextValidator;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;

public class ChangeSetContentHandler
extends PlainTextContentHandler
implements IHasCustomValidator {
    public void retrieveAssetContent(RuleAsset asset, PackageItem pkg, AssetItem item) throws SerializationException {
        if (item.getContent() != null) {
            RuleContentText text = new RuleContentText();
            text.content = item.getContent();
            asset.setContent((PortableObject)text);
        }
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializationException {
        RuleContentText text = (RuleContentText)asset.getContent();
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(text.content.getBytes("UTF-8"));
            repoAsset.updateBinaryContentAttachment((InputStream)input);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public BuilderResult validateAsset(AssetItem asset) {
        String message = this.validate(asset.getContent());
        return this.createBuilderResult(message, asset.getName(), asset.getFormat(), asset.getUUID());
    }

    private BuilderResult createBuilderResult(String message, String name, String format, String uuid) {
        if (message.length() == 0) {
            return new BuilderResult();
        }
        ArrayList<BuilderResultLine> errors = new ArrayList<BuilderResultLine>();
        BuilderResultLine result = new BuilderResultLine().setAssetName(name).setAssetFormat(format).setUuid(uuid).setMessage(message);
        errors.add(result);
        BuilderResult builderResult = new BuilderResult();
        builderResult.addLines(errors);
        return builderResult;
    }

    private String validate(String content) {
        SpringContextValidator contextValidator = new SpringContextValidator();
        contextValidator.setContentAsString(content);
        return contextValidator.validate();
    }
}

