/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.server.builder.AssemblyErrorLogger;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.contenthandler.drools.DRLFileContentHandler;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.lang.ExpanderException;
import org.drools.lang.dsl.DefaultExpander;
import org.drools.repository.AssetItem;

public class DSLRuleContentHandler
extends ContentHandler
implements IRuleAsset {
    public void retrieveAssetContent(RuleAsset asset, AssetItem item) throws SerializationException {
        RuleContentText text = new RuleContentText();
        text.content = item.getContent();
        asset.setContent((PortableObject)text);
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializationException {
        RuleContentText text = (RuleContentText)asset.getContent();
        repoAsset.updateContent(text.content);
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, AssemblyErrorLogger logger) throws DroolsParserException, IOException {
        DefaultExpander expander = this.getExpander(builder, asset, logger);
        String source = this.getRawDRL(asset);
        String drl = expander.expand(source);
        if (expander.hasErrors()) {
            List exErrs = expander.getErrors();
            for (ExpanderException ex : exErrs) {
                logger.logError(new ContentAssemblyError(ex.getMessage(), asset.getFormat(), asset.getName(), asset.getUUID(), false, true));
            }
            return;
        }
        builder.addPackageFromDrl((Reader)new StringReader(drl));
    }

    private DefaultExpander getExpander(BRMSPackageBuilder builder, AssetItem asset, AssemblyErrorLogger logger) {
        if (!builder.hasDSL()) {
            logger.logError(new ContentAssemblyError("This rule asset requires a DSL, yet none were configured in the package.", asset.getFormat(), asset.getName(), asset.getUUID(), false, true));
        }
        return builder.getDSLExpander();
    }

    public void assembleDRL(BRMSPackageBuilder builder, RuleAsset asset, StringBuilder stringBuilder) {
        RuleContentText text = (RuleContentText)asset.getContent();
        String source = text.content;
        source = this.getDRL(source, asset.getName(), null);
        DefaultExpander expander = builder.getDSLExpander();
        stringBuilder.append(expander.expand(source));
    }

    public void assembleDRL(BRMSPackageBuilder builder, AssetItem asset, StringBuilder stringBuilder) {
        String source = this.getRawDRL(asset);
        DefaultExpander expander = builder.getDSLExpander();
        stringBuilder.append(expander.expand(source));
    }

    private String wrapRule(String assetName, String parentName, String source) {
        if (parentName == null || "".equals(parentName)) {
            return "rule '" + assetName + "' \n" + source + "\nend";
        }
        return "rule '" + assetName + "' extends " + parentName + " \n" + source + "\nend";
    }

    public String getRawDRL(AssetItem asset) {
        String source = asset.getContent();
        String parentName = this.parentNameFromCategory(asset, "");
        source = this.getDRL(source, asset.getName(), parentName);
        return source;
    }

    public String getDRL(String source, String assetName, String parentName) {
        if (DRLFileContentHandler.isStandAloneRule((String)source)) {
            source = this.wrapRule(assetName, parentName, source);
        }
        return source;
    }
}

