/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactModels;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FieldMetaModel;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ICanRenderSource;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.lang.descr.AnnotationDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.repository.AssetItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactModelContentHandler
extends ContentHandler
implements ICanRenderSource {
    private static final LoggingHelper log = LoggingHelper.getLogger(FactModelContentHandler.class);

    public void retrieveAssetContent(RuleAsset asset, AssetItem item) throws SerializationException {
        try {
            List models = this.toModel(item.getContent());
            FactModels ms = new FactModels();
            ms.models = models;
            asset.setContent((PortableObject)ms);
        }
        catch (DroolsParserException e) {
            log.error("Unable to parse the DRL for the model - falling back to text (" + e.getMessage() + ")");
            RuleContentText text = new RuleContentText();
            text.content = item.getContent();
            asset.setContent((PortableObject)text);
        }
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializationException {
        if (asset.getContent() instanceof FactModels) {
            FactModels fm = (FactModels)asset.getContent();
            repoAsset.updateContent(this.toDRL(fm.models));
        } else {
            RuleContentText text = (RuleContentText)asset.getContent();
            repoAsset.updateContent(text.content);
        }
    }

    public void assembleSource(PortableObject assetContent, StringBuilder stringBuilder) {
        FactModels fms = (FactModels)assetContent;
        for (FactMetaModel fm : fms.models) {
            stringBuilder.append(this.toDRL(fm));
            stringBuilder.append("\n\n");
        }
    }

    String toDRL(FactMetaModel mm) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("declare ").append(mm.getName());
        if (mm.hasSuperType()) {
            sb.append(" extends ");
            sb.append(mm.getSuperType());
        }
        for (i = 0; i < mm.getAnnotations().size(); ++i) {
            AnnotationMetaModel a = (AnnotationMetaModel)mm.getAnnotations().get(i);
            sb.append("\n\t");
            sb.append((CharSequence)this.buildAnnotationDRL(a));
        }
        for (i = 0; i < mm.getFields().size(); ++i) {
            FieldMetaModel f = (FieldMetaModel)mm.getFields().get(i);
            sb.append("\n\t");
            sb.append(f.name).append(": ").append(f.type);
        }
        sb.append("\nend");
        return sb.toString();
    }

    List<FactMetaModel> toModel(String drl) throws DroolsParserException {
        if (drl != null && drl.startsWith("#advanced")) {
            throw new DroolsParserException("Using advanced editor");
        }
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(drl);
        if (parser.hasErrors()) {
            throw new DroolsParserException("The model drl " + drl + " is not valid");
        }
        if (pkg == null) {
            return new ArrayList<FactMetaModel>();
        }
        List types = pkg.getTypeDeclarations();
        ArrayList<FactMetaModel> list = new ArrayList<FactMetaModel>(types.size());
        for (TypeDeclarationDescr td : types) {
            FactMetaModel mm = new FactMetaModel();
            mm.setName(td.getTypeName());
            mm.setSuperType(td.getSuperTypeName());
            Map fields = td.getFields();
            for (Map.Entry en : fields.entrySet()) {
                String fieldName = (String)en.getKey();
                TypeFieldDescr descr = (TypeFieldDescr)en.getValue();
                FieldMetaModel fm = new FieldMetaModel(fieldName, descr.getPattern().getObjectType());
                mm.getFields().add(fm);
            }
            Map annotations = td.getAnnotations();
            for (Map.Entry en : annotations.entrySet()) {
                String annotationName = (String)en.getKey();
                AnnotationDescr descr = (AnnotationDescr)en.getValue();
                Map values = descr.getValues();
                AnnotationMetaModel am = new AnnotationMetaModel(annotationName, values);
                mm.getAnnotations().add(am);
            }
            list.add(mm);
        }
        return list;
    }

    String toDRL(List<FactMetaModel> models) {
        StringBuilder sb = new StringBuilder();
        for (FactMetaModel factMetaModel : models) {
            String drl = this.toDRL(factMetaModel);
            sb.append(drl).append("\n\n");
        }
        return sb.toString().trim();
    }

    private StringBuilder buildAnnotationDRL(AnnotationMetaModel a) {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(a.name);
        sb.append("(");
        for (Map.Entry e : a.getValues().entrySet()) {
            if (e.getKey() != null && ((String)e.getKey()).length() > 0) {
                sb.append((String)e.getKey());
                sb.append(" = ");
            }
            if (e.getValue() != null && ((String)e.getValue()).length() > 0) {
                sb.append((String)e.getValue());
            }
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append(")");
        return sb;
    }
}

