/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.drools.ChoiceList;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;

public class DSLRuleEditor
extends DirtyableComposite {
    private TextArea text;
    private final RuleContentText data;
    private DSLSentence[] conditions;
    private DSLSentence[] actions;

    public DSLRuleEditor(Asset asset, RuleViewer viewer) {
        this(asset);
    }

    public DSLRuleEditor(Asset asset) {
        RuleContentText cont;
        this.data = cont = (RuleContentText)asset.getContent();
        this.text = new TextArea();
        this.text.setWidth("100%");
        this.text.setVisibleLines(16);
        this.text.setText(this.data.content);
        SuggestionCompletionEngine eng = SuggestionCompletionCache.getInstance().getEngineFromCache(asset.getMetaData().getModuleName());
        this.actions = eng.actionDSLSentences;
        this.conditions = eng.conditionDSLSentences;
        this.text.setStyleName("dsl-text-Editor");
        FlexTable layout = new FlexTable();
        layout.setWidget(0, 0, (Widget)this.text);
        this.text.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.text.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        VerticalPanel vert = new VerticalPanel();
        ImageButton lhsOptions = new ImageButton(DroolsGuvnorImages.INSTANCE.newDSLPattern());
        String msg = Constants.INSTANCE.AddANewCondition();
        lhsOptions.setTitle(msg);
        lhsOptions.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        ImageButton rhsOptions = new ImageButton(DroolsGuvnorImages.INSTANCE.newDSLAction());
        String msg2 = Constants.INSTANCE.AddAnAction();
        rhsOptions.setTitle(msg2);
        rhsOptions.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        vert.add((Widget)lhsOptions);
        vert.add((Widget)rhsOptions);
        layout.setWidget(0, 1, (Widget)vert);
        layout.getCellFormatter().setWidth(0, 0, "95%");
        layout.getFlexCellFormatter().setAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_TOP);
        layout.getCellFormatter().setWidth(0, 1, "5%");
        layout.getFlexCellFormatter().setAlignment(0, 1, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        layout.setWidth("100%");
        layout.setHeight("100%");
        this.initWidget((Widget)layout);
    }

    protected void showInTextOptions() {
        String prev = this.text.getText().substring(0, this.text.getCursorPos());
        if (prev.indexOf("then") > -1) {
            this.showSuggestions(this.actions);
        } else {
            this.showSuggestions(this.conditions);
        }
    }

    private void showSuggestions(DSLSentence[] items) {
        ChoiceList choice = new ChoiceList(items, this);
        choice.setPopupPosition(this.text.getAbsoluteLeft() + 20, this.text.getAbsoluteTop() + 20);
        choice.show();
    }

    void insertText(String ins) {
        int i = this.text.getCursorPos();
        String left = this.text.getText().substring(0, i);
        String right = this.text.getText().substring(i, this.text.getText().length());
        this.text.setText(left + ins + right);
        this.data.content = this.text.getText();
    }

    static /* synthetic */ RuleContentText access$000(DSLRuleEditor x0) {
        return x0.data;
    }

    static /* synthetic */ TextArea access$100(DSLRuleEditor x0) {
        return x0.text;
    }

    static /* synthetic */ DSLSentence[] access$200(DSLRuleEditor x0) {
        return x0.conditions;
    }

    static /* synthetic */ void access$300(DSLRuleEditor x0, DSLSentence[] x1) {
        x0.showSuggestions(x1);
    }

    static /* synthetic */ DSLSentence[] access$400(DSLRuleEditor x0) {
        return x0.actions;
    }
}

