/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FiredRulesPanel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;

public class ExecutionWidget
extends Composite {
    private final ExecutionTrace executionTrace;

    public ExecutionWidget(ExecutionTrace executionTrace, boolean showResults) {
        this.executionTrace = executionTrace;
        HorizontalPanel simulDatePanel = this.simulDate();
        simulDatePanel.setVisible(this.isScenarioSimulatedDateSet());
        ListBox choice = new ListBox();
        choice.addItem(Constants.INSTANCE.UseRealDateAndTime());
        choice.addItem(Constants.INSTANCE.UseASimulatedDateAndTime());
        choice.setSelectedIndex(executionTrace.getScenarioSimulatedDate() == null ? 0 : 1);
        choice.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel layout = new HorizontalPanel();
        layout.add((Widget)new Image(DroolsGuvnorImages.INSTANCE.executionTrace()));
        layout.add((Widget)choice);
        layout.add((Widget)simulDatePanel);
        if (showResults && this.isResultNotNullAndHaveRulesFired()) {
            VerticalPanel replacingLayout = new VerticalPanel();
            replacingLayout.add((Widget)new FiredRulesPanel(executionTrace));
            replacingLayout.add((Widget)layout);
            this.initWidget((Widget)replacingLayout);
        } else {
            this.initWidget((Widget)layout);
        }
    }

    private boolean isResultNotNullAndHaveRulesFired() {
        return this.executionTrace.getExecutionTimeResult() != null && this.executionTrace.getNumberOfRulesFired() != null;
    }

    private boolean isScenarioSimulatedDateSet() {
        return this.executionTrace.getScenarioSimulatedDate() != null;
    }

    private HorizontalPanel simulDate() {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        String format = "yyyy-MM-dd HH:mm";
        TextBox textBox = new TextBox();
        if (this.executionTrace.getScenarioSimulatedDate() == null) {
            textBox.setText("<yyyy-MM-dd HH:mm>");
        } else {
            textBox.setText(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(this.executionTrace.getScenarioSimulatedDate()));
        }
        SmallLabel dateHint = new SmallLabel();
        textBox.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        textBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        horizontalPanel.add((Widget)textBox);
        horizontalPanel.add((Widget)dateHint);
        return horizontalPanel;
    }

    static /* synthetic */ ExecutionTrace access$000(ExecutionWidget x0) {
        return x0.executionTrace;
    }
}

