/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.toolbar;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.place.shared.Place;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;
import org.drools.guvnor.client.asseteditor.BusinessProcessEditor;
import org.drools.guvnor.client.asseteditor.RefreshAssetEditorEvent;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.asseteditor.drools.WorkingSetSelectorPopup;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.common.StatusChangePopup;
import org.drools.guvnor.client.explorer.AssetEditorPlace;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.PackageBuilderWidget;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.moduleeditor.drools.WorkingSetManager;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.VerificationService;
import org.drools.guvnor.client.rpc.VerificationServiceAsync;
import org.drools.guvnor.client.widgets.CheckinPopup;
import org.drools.guvnor.client.widgets.drools.toolbar.AssetEditorActionToolbar;
import org.drools.guvnor.client.widgets.toolbar.ActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.client.widgets.toolbar.DefaultActionToolbarButtonsConfigurationProvider;

public class AssetEditorActionToolbar
extends Composite {
    private static ActionToolbarBinder uiBinder = (ActionToolbarBinder)GWT.create(ActionToolbarBinder.class);
    @UiField
    MenuItem saveChanges;
    @UiField
    MenuItem saveChangesAndClose;
    @UiField
    MenuItem archive;
    @UiField
    MenuItem delete;
    @UiField
    MenuItem copy;
    @UiField
    MenuItem rename;
    @UiField
    MenuItem promoteToGlobal;
    @UiField
    MenuItem selectWorkingSets;
    @UiField
    MenuItem validate;
    @UiField
    MenuItem verify;
    @UiField
    MenuItem viewSource;
    @UiField
    MenuItem changeStatus;
    @UiField
    Label status;
    @UiField
    MenuItem sourceMenu;
    private ActionToolbarButtonsConfigurationProvider actionToolbarButtonsConfigurationProvider;
    protected Asset asset;
    final Widget editor;
    private final EventBus eventBus;
    private final ClientFactory clientFactory;
    private Command afterCheckinEvent;
    private boolean readOnly;

    public AssetEditorActionToolbar(Asset asset, Widget editor, ClientFactory clientFactory, EventBus eventBus, boolean readOnly) {
        this.asset = asset;
        this.editor = editor;
        this.eventBus = eventBus;
        this.clientFactory = clientFactory;
        this.readOnly = readOnly;
        this.actionToolbarButtonsConfigurationProvider = new DefaultActionToolbarButtonsConfigurationProvider(asset);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setState(asset.getState());
        this.applyToolBarConfiguration();
        this.status.setVisible(this.actionToolbarButtonsConfigurationProvider.showStateLabel());
        this.initActionToolBar();
    }

    public void setState(String newStatus) {
        this.status.setText(Constants.INSTANCE.statusIs(newStatus));
    }

    private void applyToolBarConfiguration() {
        this.saveChanges.setVisible(this.actionToolbarButtonsConfigurationProvider.showSaveButton());
        this.saveChangesAndClose.setVisible(this.actionToolbarButtonsConfigurationProvider.showSaveAndCloseButton());
        this.validate.setVisible(this.actionToolbarButtonsConfigurationProvider.showValidateButton());
        this.verify.setVisible(this.actionToolbarButtonsConfigurationProvider.showVerifyButton());
        this.viewSource.setVisible(this.actionToolbarButtonsConfigurationProvider.showViewSourceButton());
        this.copy.setVisible(this.actionToolbarButtonsConfigurationProvider.showCopyButton());
        this.rename.setVisible(this.actionToolbarButtonsConfigurationProvider.showRenameButton());
        this.promoteToGlobal.setVisible(this.actionToolbarButtonsConfigurationProvider.showPromoteToGlobalButton());
        this.archive.setVisible(this.actionToolbarButtonsConfigurationProvider.showArchiveButton());
        this.delete.setVisible(this.actionToolbarButtonsConfigurationProvider.showDeleteButton());
        this.changeStatus.setVisible(this.actionToolbarButtonsConfigurationProvider.showChangeStatusButton());
        this.selectWorkingSets.setVisible(this.actionToolbarButtonsConfigurationProvider.showSelectWorkingSetsButton());
        this.sourceMenu.setVisible(this.areSourceMenuChildrenVisible());
    }

    private boolean areSourceMenuChildrenVisible() {
        return this.validate.isVisible() || this.verify.isVisible() || this.viewSource.isVisible();
    }

    public void setSelectWorkingSetsCommand(Command command) {
        this.selectWorkingSets.setCommand(command);
    }

    public void setViewSourceCommand(Command command) {
        this.viewSource.setCommand(command);
    }

    public void setVerifyCommand(Command command) {
        this.verify.setCommand(command);
    }

    public void setValidateCommand(Command command) {
        this.validate.setCommand(command);
    }

    public void setSaveChangesCommand(Command command) {
        this.saveChanges.setCommand(command);
    }

    public void setSaveChangesAndCloseCommand(Command command) {
        this.saveChangesAndClose.setCommand(command);
    }

    public void setChangeStatusCommand(Command command) {
        this.changeStatus.setCommand(command);
    }

    public void setDeleteVisible(boolean b) {
        this.delete.setVisible(b);
    }

    public void setArchiveVisible(boolean b) {
        this.archive.setVisible(b);
    }

    public void setArchiveCommand(Command archiveCommand) {
        this.archive.setCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setCopyCommand(Command command) {
        this.copy.setCommand(command);
    }

    public void setRenameCommand(Command command) {
        this.rename.setCommand(command);
    }

    public void setDeleteCommand(Command deleteCommand) {
        this.delete.setCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setPromtToGlobalCommand(Command command) {
        this.promoteToGlobal.setCommand(command);
    }

    private void initActionToolBar() {
        if (this.readOnly) {
            this.setVisible(false);
        } else {
            this.setPromtToGlobalCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setDeleteCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setCopyCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setRenameCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setArchiveCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.afterCheckinEvent = new /* Unavailable Anonymous Inner Class!! */;
            this.setSelectWorkingSetsCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setViewSourceCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setVerifyCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setValidateCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setSaveChangesCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setSaveChangesAndCloseCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.setChangeStatusCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void showStatusChanger() {
        StatusChangePopup pop = new StatusChangePopup(this.asset.getUuid(), false);
        pop.setChangeStatusEvent((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    protected void verifyAndDoCheckinConfirm(boolean closeAfter) {
        if (this.editor instanceof RuleModeller) {
            ((RuleModeller)this.editor).verifyRule((Command)new /* Unavailable Anonymous Inner Class!! */);
        } else if (this.editor instanceof BusinessProcessEditor) {
            if (((BusinessProcessEditor)this.editor).hasErrors()) {
                return;
            }
            this.doCheckinConfirm(closeAfter);
        } else {
            this.doCheckinConfirm(closeAfter);
        }
    }

    protected void doCheckinConfirm(boolean closeAfter) {
        CheckinPopup pop = new CheckinPopup(Constants.INSTANCE.CheckInChanges());
        pop.setCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    public void doCheckin(String comment, boolean closeAfter) {
        if (this.editor instanceof SaveEventListener) {
            ((SaveEventListener)this.editor).onSave();
        }
        this.performCheckIn(comment, closeAfter);
        if (closeAfter) {
            this.close();
        }
    }

    private void doVerify() {
        this.onSave();
        LoadingPopup.showMessage((String)Constants.INSTANCE.VerifyingItemPleaseWait());
        Set activeWorkingSets = null;
        activeWorkingSets = WorkingSetManager.getInstance().getActiveAssetUUIDs(this.asset.getMetaData().getModuleName());
        VerificationServiceAsync verificationService = (VerificationServiceAsync)GWT.create(VerificationService.class);
        verificationService.verifyAsset(this.asset, activeWorkingSets, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showSource(String src) {
        PackageBuilderWidget.showSource((String)src, (String)this.asset.getName());
        LoadingPopup.close();
    }

    private void onSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onSave();
        }
    }

    protected void showWorkingSetsSelection(RuleModeller modeller) {
        new WorkingSetSelectorPopup(modeller, this.asset).show();
    }

    protected boolean hasDirty() {
        return false;
    }

    private void close() {
        this.eventBus.fireEvent((GwtEvent)new ClosePlaceEvent((Place)new AssetEditorPlace(this.asset.getUuid())));
    }

    void doDelete() {
        this.readOnly = true;
        RepositoryServiceFactory.getService().deleteUncheckedRule(this.asset.getUuid(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doArchive() {
        RepositoryServiceFactory.getAssetService().archiveAsset(this.asset.getUuid(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void performCheckIn(String comment, boolean closeAfter) {
        this.asset.setCheckinComment(comment);
        boolean[] saved = new boolean[]{false};
        if (!saved[0]) {
            LoadingPopup.showMessage((String)Constants.INSTANCE.SavingPleaseWait());
        }
        RepositoryServiceFactory.getAssetService().checkinVersion(this.asset, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void flushSuggestionCompletionCache(String moduleName, String uuid) {
        if (AssetFormats.isPackageDependency((String)this.asset.getFormat())) {
            LoadingPopup.showMessage((String)Constants.INSTANCE.RefreshingContentAssistance());
            SuggestionCompletionCache.getInstance().loadPackage(moduleName, (Command)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.eventBus.fireEvent((GwtEvent)new RefreshAssetEditorEvent(moduleName, uuid));
        }
    }

    protected void doCloseUnsavedWarning() {
        FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.warningLarge(), Constants.INSTANCE.WARNINGUnCommittedChanges());
        Button dis = new Button(Constants.INSTANCE.Discard());
        Button can = new Button(Constants.INSTANCE.Cancel());
        HorizontalPanel hor = new HorizontalPanel();
        hor.add((Widget)dis);
        hor.add((Widget)can);
        pop.addRow((Widget)new HTML(Constants.INSTANCE.AreYouSureYouWantToDiscardChanges()));
        pop.addRow((Widget)hor);
        dis.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        can.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void doCopy() {
        FormStylePopup form = new FormStylePopup(DroolsGuvnorImages.INSTANCE.ruleAsset(), Constants.INSTANCE.CopyThisItem());
        TextBox newName = new TextBox();
        form.addAttribute(Constants.INSTANCE.NewName(), (IsWidget)newName);
        RulePackageSelector sel = new RulePackageSelector();
        form.addAttribute(Constants.INSTANCE.NewPackage(), (IsWidget)sel);
        Button ok = new Button(Constants.INSTANCE.CreateCopy());
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute("", (IsWidget)ok);
        form.show();
    }

    private void doRename() {
        FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.packageLarge(), Constants.INSTANCE.RenameThisItem());
        TextBox box = new TextBox();
        box.setText(this.asset.getName());
        pop.addAttribute(Constants.INSTANCE.NewNameAsset(), (IsWidget)box);
        Button ok = new Button(Constants.INSTANCE.RenameItem());
        pop.addAttribute("", (IsWidget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void doPromptToGlobal() {
        if (this.asset.getMetaData().getModuleName().equals("globalArea")) {
            Window.alert((String)Constants.INSTANCE.ItemAlreadyInGlobalArea());
            return;
        }
        if (Window.confirm((String)Constants.INSTANCE.PromoteAreYouSure())) {
            RepositoryServiceFactory.getAssetService().promoteAssetToGlobalArea(this.asset.getUuid(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void completedCopying(String name, String pkg, String newAssetUUID) {
        Window.alert((String)Constants.INSTANCE.CreatedANewItemSuccess(name, pkg));
        this.clientFactory.getPlaceController().goTo((Place)new AssetEditorPlace(newAssetUUID));
    }

    static /* synthetic */ void access$000(AssetEditorActionToolbar x0) {
        x0.doPromptToGlobal();
    }

    static /* synthetic */ void access$100(AssetEditorActionToolbar x0) {
        x0.doCopy();
    }

    static /* synthetic */ void access$200(AssetEditorActionToolbar x0) {
        x0.doRename();
    }

    static /* synthetic */ void access$300(AssetEditorActionToolbar x0) {
        x0.doArchive();
    }

    static /* synthetic */ void access$400(AssetEditorActionToolbar x0) {
        x0.onSave();
    }

    static /* synthetic */ void access$500(AssetEditorActionToolbar x0, String x1) {
        x0.showSource(x1);
    }

    static /* synthetic */ void access$600(AssetEditorActionToolbar x0) {
        x0.doVerify();
    }

    static /* synthetic */ void access$700(AssetEditorActionToolbar x0) {
        x0.showStatusChanger();
    }

    static /* synthetic */ EventBus access$800(AssetEditorActionToolbar x0) {
        return x0.eventBus;
    }

    static /* synthetic */ void access$900(AssetEditorActionToolbar x0) {
        x0.close();
    }

    static /* synthetic */ Command access$1000(AssetEditorActionToolbar x0) {
        return x0.afterCheckinEvent;
    }

    static /* synthetic */ void access$1100(AssetEditorActionToolbar x0, String x1, String x2, String x3) {
        x0.completedCopying(x1, x2, x3);
    }
}

