/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPOperatorsDropdown;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPWindowOperatorsDropdown;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ConstraintValueEditor;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ExpressionBuilder;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.ExpressionTypeChangeHandler;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.FactPatternWidget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.factPattern.Connectives;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.factPattern.PopupCreator;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.HasCEPWindow;
import org.drools.ide.common.client.modeldriven.brl.HasConstraints;
import org.drools.ide.common.client.modeldriven.brl.HasParameterizedOperator;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;

public class FactPatternWidget
extends RuleModellerWidget {
    private FactPattern pattern;
    private DirtyableFlexTable layout = new DirtyableFlexTable();
    private Connectives connectives;
    private PopupCreator popupCreator;
    private boolean bindable;
    private boolean isAll0WithLabel;
    private boolean readOnly;
    private final List<ConstraintValueEditor> constraintValueEditors = new ArrayList();

    public FactPatternWidget(RuleModeller mod, EventBus eventBus, IPattern p, boolean canBind) {
        this(mod, eventBus, p, false, canBind, null);
    }

    public FactPatternWidget(RuleModeller ruleModeller, EventBus eventBus, IPattern pattern, boolean canBind, Boolean readOnly) {
        this(ruleModeller, eventBus, pattern, false, canBind, readOnly);
    }

    public FactPatternWidget(RuleModeller mod, EventBus eventBus, IPattern p, boolean isAll0WithLabel, boolean canBind, Boolean readOnly) {
        super(mod, eventBus);
        this.pattern = (FactPattern)p;
        this.bindable = canBind;
        this.popupCreator = new PopupCreator();
        this.popupCreator.setBindable(this.bindable);
        this.popupCreator.setCompletions(mod.getSuggestionCompletions());
        this.popupCreator.setModeller(mod);
        this.popupCreator.setPattern(this.pattern);
        this.isAll0WithLabel = isAll0WithLabel;
        this.readOnly = readOnly == null ? !mod.getSuggestionCompletions().containsFactType(this.pattern.getFactType()) : readOnly;
        this.connectives = new Connectives(mod, eventBus, this.pattern, Boolean.valueOf(this.readOnly));
        this.layout.setWidget(0, 0, this.getPatternLabel(this.pattern));
        FlexTable.FlexCellFormatter formatter = this.layout.getFlexCellFormatter();
        formatter.setAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_BOTTOM);
        formatter.setStyleName(0, 0, "modeller-fact-TypeHeader");
        List sortedConst = this.sortConstraints(this.pattern.getFieldConstraints());
        this.pattern.setFieldConstraints(sortedConst);
        this.drawConstraints(sortedConst, (HasConstraints)this.pattern);
        int row = this.layout.getRowCount() + 1;
        this.layout.setWidget(row, 0, this.createCEPWindowWidget(mod, (HasCEPWindow)this.pattern));
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        if (this.bindable) {
            this.layout.addStyleName("modeller-fact-pattern-Widget");
        }
        this.initWidget((Widget)this.layout);
    }

    private void drawConstraints(List<FieldConstraint> sortedConst, HasConstraints hasConstraints) {
        DirtyableFlexTable table = new DirtyableFlexTable();
        this.layout.setWidget(1, 0, (Widget)table);
        ArrayList parents = new ArrayList();
        for (int i = 0; i < sortedConst.size(); ++i) {
            this.traverseSingleFieldConstraints(sortedConst, table, parents, hasConstraints, i);
            int currentRow = i;
            ImageButton clear = new ImageButton(DroolsGuvnorImages.INSTANCE.deleteItemSmall());
            clear.setTitle(Constants.INSTANCE.RemoveThisWholeRestriction());
            clear.addClickHandler(this.createClickHandlerForClearImageButton(currentRow));
            if (this.readOnly) continue;
            table.setWidget(currentRow, 6, (Widget)clear);
        }
    }

    private ClickHandler createClickHandlerForClearImageButton(int currentRow) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void traverseSingleFieldConstraints(List<FieldConstraint> sortedConst, DirtyableFlexTable table, List<FieldConstraint> parents, HasConstraints hasConstraints, int i) {
        int tabs = -1;
        FieldConstraint current = sortedConst.get(i);
        if (current instanceof SingleFieldConstraint) {
            SingleFieldConstraint single = (SingleFieldConstraint)current;
            FieldConstraint parent = single.getParent();
            for (int j = 0; j < parents.size(); ++j) {
                FieldConstraint storedParent = parents.get(j);
                if (storedParent == null || !storedParent.equals(parent)) continue;
                tabs = j + 1;
                this.traverseForRemoval(parents, j);
                parents.add(current);
                break;
            }
            if (tabs < 0) {
                tabs = 0;
                parents.add(current);
            }
        }
        this.renderFieldConstraint(table, i, current, hasConstraints, true, tabs);
    }

    private void traverseForRemoval(List<FieldConstraint> parents, int j) {
        for (int k = j + 1; k < parents.size(); ++k) {
            parents.remove(j + 1);
        }
    }

    private List<FieldConstraint> sortConstraints(FieldConstraint[] constraints) {
        ArrayList<FieldConstraint> sortedConst = new ArrayList<FieldConstraint>(constraints.length);
        for (int i = 0; i < constraints.length; ++i) {
            FieldConstraint current = constraints[i];
            if (current instanceof SingleFieldConstraint) {
                SingleFieldConstraint single = (SingleFieldConstraint)current;
                int index = sortedConst.indexOf(single.getParent());
                if (single.getParent() == null) {
                    sortedConst.add((FieldConstraint)single);
                    continue;
                }
                if (index >= 0) {
                    sortedConst.add(index + 1, (FieldConstraint)single);
                    continue;
                }
                this.insertSingleFieldConstraint(single, sortedConst);
                continue;
            }
            sortedConst.add(current);
        }
        return sortedConst;
    }

    private void insertSingleFieldConstraint(SingleFieldConstraint fieldConst, List<FieldConstraint> sortedConst) {
        if (fieldConst.getParent() instanceof SingleFieldConstraint) {
            this.insertSingleFieldConstraint((SingleFieldConstraint)fieldConst.getParent(), sortedConst);
        }
        sortedConst.add((FieldConstraint)fieldConst);
    }

    private void renderFieldConstraint(DirtyableFlexTable inner, int row, FieldConstraint constraint, HasConstraints hasConstraints, boolean showBinding, int tabs) {
        if (constraint instanceof SingleFieldConstraint) {
            this.renderSingleFieldConstraint(this.getModeller(), inner, row, (SingleFieldConstraint)constraint, hasConstraints, showBinding, tabs);
        } else if (constraint instanceof CompositeFieldConstraint) {
            inner.setWidget(row, 1, this.compositeFieldConstraintEditor((CompositeFieldConstraint)constraint));
            inner.getFlexCellFormatter().setColSpan(row, 1, 5);
            inner.setWidget(row, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        }
    }

    private Widget compositeFieldConstraintEditor(CompositeFieldConstraint constraint) {
        FlexTable t = new FlexTable();
        String desc = null;
        2 click = new /* Unavailable Anonymous Inner Class!! */;
        desc = constraint.compositeJunctionType.equals("&&") ? Constants.INSTANCE.AllOf() + ":" : Constants.INSTANCE.AnyOf() + ":";
        t.setWidget(0, 0, (Widget)new ClickableLabel(desc, (ClickHandler)click, !this.readOnly));
        t.getFlexCellFormatter().setColSpan(0, 0, 2);
        FieldConstraint[] nested = constraint.constraints;
        DirtyableFlexTable inner = new DirtyableFlexTable();
        if (nested != null) {
            for (int i = 0; i < nested.length; ++i) {
                this.renderFieldConstraint(inner, i, nested[i], (HasConstraints)constraint, true, 0);
                int currentRow = i;
                ImageButton clear = new ImageButton(DroolsGuvnorImages.INSTANCE.deleteItemSmall());
                clear.setTitle(Constants.INSTANCE.RemoveThisNestedRestriction());
                clear.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                if (this.readOnly) continue;
                inner.setWidget(i, 6, (Widget)clear);
            }
        }
        t.setWidget(1, 1, (Widget)inner);
        t.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        return t;
    }

    private void renderSingleFieldConstraint(RuleModeller modeller, DirtyableFlexTable inner, int row, SingleFieldConstraint constraint, HasConstraints hasConstraints, boolean showBinding, int tabs) {
        boolean col = true;
        inner.setWidget(row, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        if (constraint.getConstraintValueType() != 5) {
            HorizontalPanel ebContainer = null;
            if (constraint instanceof SingleFieldConstraintEBLeftSide) {
                ebContainer = this.expressionBuilderLS((SingleFieldConstraintEBLeftSide)constraint, showBinding, tabs * 20);
                inner.setWidget(row, 1, (Widget)ebContainer);
            } else {
                inner.setWidget(row, 1, this.fieldLabel(constraint, hasConstraints, showBinding, tabs * 20));
            }
            inner.setWidget(row, 2, this.operatorDropDown(constraint, inner, row, 3));
            inner.setWidget(row, 3, this.valueEditor(constraint));
            inner.setWidget(row, 4, this.connectives.connectives(constraint, constraint.getFieldType()));
            if (ebContainer != null && ebContainer.getWidgetCount() > 0 && ebContainer.getWidget(0) instanceof ExpressionBuilder) {
                this.associateExpressionWithChangeHandler(inner, row, constraint, 1, ebContainer);
            }
            if (!this.readOnly) {
                inner.setWidget(row, 5, (Widget)this.createAddConnectiveImageButton(modeller, constraint));
            }
        } else if (constraint.getConstraintValueType() == 5) {
            inner.setWidget(row, 1, this.predicateEditor(constraint));
            inner.getFlexCellFormatter().setColSpan(row, 1, 5);
        }
    }

    private Image createAddConnectiveImageButton(RuleModeller modeller, SingleFieldConstraint constraint) {
        ImageButton addConnective = new ImageButton(DroolsGuvnorImages.INSTANCE.addConnective());
        addConnective.setTitle(Constants.INSTANCE.AddMoreOptionsToThisFieldsValues());
        addConnective.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return addConnective;
    }

    private Widget createCEPWindowWidget(RuleModeller modeller, HasCEPWindow c) {
        if (modeller.getSuggestionCompletions().isFactTypeAnEvent(this.pattern.getFactType())) {
            HorizontalPanel hp = new HorizontalPanel();
            Label lbl = new Label(Constants.INSTANCE.OverCEPWindow());
            lbl.setStyleName("paddedLabel");
            hp.add((Widget)lbl);
            CEPWindowOperatorsDropdown cwo = new CEPWindowOperatorsDropdown(c, this.readOnly);
            if (!this.isReadOnly()) {
                cwo.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            }
            hp.add((Widget)cwo);
            return hp;
        }
        return new HTML();
    }

    private void associateExpressionWithChangeHandler(DirtyableFlexTable inner, int row, SingleFieldConstraint constraint, int col, HorizontalPanel ebContainer) {
        ExpressionBuilder eb = (ExpressionBuilder)ebContainer.getWidget(0);
        eb.addExpressionTypeChangeHandler((ExpressionTypeChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget predicateEditor(SingleFieldConstraint c) {
        HorizontalPanel pred = new HorizontalPanel();
        pred.setWidth("100%");
        Image img = new Image(DroolsGuvnorImages.INSTANCE.functionAssets());
        img.setTitle(Constants.INSTANCE.FormulaBooleanTip());
        pred.add((Widget)img);
        if (c.getValue() == null) {
            c.setValue("");
        }
        TextBox box = new TextBox();
        box.setText(c.getValue());
        if (!this.readOnly) {
            box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            box.setWidth("100%");
            pred.add((Widget)box);
        } else {
            pred.add((Widget)new SmallLabel(c.getValue()));
        }
        return pred;
    }

    private Widget getPatternLabel(FactPattern fp) {
        String desc;
        String patternName;
        8 click = new /* Unavailable Anonymous Inner Class!! */;
        String string = patternName = this.pattern.isBound() ? this.pattern.getFactType() + " <b>[" + this.pattern.getBoundName() + "]</b>" : this.pattern.getFactType();
        if (this.isAll0WithLabel) {
            desc = Constants.INSTANCE.All0with(patternName);
        } else {
            desc = this.pattern.getNumberOfConstraints() > 0 ? Constants.INSTANCE.ThereIsAAn0With(patternName) : Constants.INSTANCE.ThereIsAAn0(patternName);
            desc = this.anA(desc, patternName);
        }
        return new ClickableLabel(desc, (ClickHandler)click, !this.readOnly);
    }

    private String anA(String desc, String patternName) {
        if (desc.startsWith("There is a/an")) {
            String vowel = patternName.substring(0, 1);
            if (vowel.equalsIgnoreCase("A") || vowel.equalsIgnoreCase("E") || vowel.equalsIgnoreCase("I") || vowel.equalsIgnoreCase("O") || vowel.equalsIgnoreCase("U")) {
                return desc.replace("There is a/an", "There is an");
            }
            return desc.replace("There is a/an", "There is a");
        }
        return desc;
    }

    private Widget valueEditor(SingleFieldConstraint c) {
        ConstraintValueEditor constraintValueEditor = new ConstraintValueEditor((BaseSingleFieldConstraint)c, this.pattern.constraintList, this.getModeller(), this.getEventBus(), this.readOnly);
        constraintValueEditor.setOnValueChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        this.constraintValueEditors.add(constraintValueEditor);
        return constraintValueEditor;
    }

    private Widget operatorDropDown(SingleFieldConstraint c, DirtyableFlexTable inner, int row, int col) {
        if (!this.readOnly) {
            String fieldName;
            String factType;
            if (c instanceof SingleFieldConstraintEBLeftSide) {
                SingleFieldConstraintEBLeftSide sfexp = (SingleFieldConstraintEBLeftSide)c;
                factType = sfexp.getExpressionLeftSide().getPreviousGenericType();
                if (factType == null) {
                    factType = sfexp.getExpressionLeftSide().getGenericType();
                }
                fieldName = sfexp.getExpressionLeftSide().getFieldName();
            } else {
                factType = c.getFactType();
                fieldName = c.getFieldName();
            }
            String[] operators = this.connectives.getCompletions().getOperatorCompletions(factType, fieldName);
            CEPOperatorsDropdown w = new CEPOperatorsDropdown(operators, (HasParameterizedOperator)c);
            w.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            return w;
        }
        SmallLabel sl = new SmallLabel("<b>" + (c.getOperator() == null ? Constants.INSTANCE.pleaseChoose() : HumanReadable.getOperatorDisplayName((String)c.getOperator())) + "</b>");
        return sl;
    }

    private HorizontalPanel expressionBuilderLS(SingleFieldConstraintEBLeftSide con, boolean showBinding, int padding) {
        HorizontalPanel ab = new HorizontalPanel();
        ab.setStyleName("modeller-field-Label");
        if (!con.isBound()) {
            if (this.bindable && showBinding && !this.readOnly) {
                ab.add((Widget)new ExpressionBuilder(this.getModeller(), this.getEventBus(), con.getExpressionLeftSide()));
            } else {
                ab.add((Widget)new SmallLabel(con.getExpressionLeftSide().getText()));
            }
        } else {
            ab.add((Widget)new ExpressionBuilder(this.getModeller(), this.getEventBus(), con.getExpressionLeftSide()));
        }
        return ab;
    }

    private Widget fieldLabel(SingleFieldConstraint con, HasConstraints hasConstraints, boolean showBinding, int padding) {
        HorizontalPanel ab = new HorizontalPanel();
        ab.setStyleName("modeller-field-Label");
        StringBuilder bindingLabel = new StringBuilder();
        if (con.isBound()) {
            bindingLabel.append("<b>[");
            bindingLabel.append(con.getFieldBinding());
            bindingLabel.append("]</b>&nbsp;");
        }
        String fieldName = con.getFieldName();
        bindingLabel.append(fieldName);
        if (this.bindable && showBinding && !this.readOnly) {
            11 click = new /* Unavailable Anonymous Inner Class!! */;
            ClickableLabel cl = new ClickableLabel(bindingLabel.toString(), (ClickHandler)click, !this.readOnly);
            DOM.setStyleAttribute((Element)cl.getElement(), (String)"marginLeft", (String)("" + padding + "pt"));
            ab.add((Widget)cl);
        } else {
            ab.add((Widget)new SmallLabel(bindingLabel.toString()));
        }
        return ab;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void refreshConstraintValueEditorsDropDownData() {
        for (ConstraintValueEditor cve : this.constraintValueEditors) {
            cve.refreshDropDownData();
        }
    }

    static /* synthetic */ FactPattern access$000(FactPatternWidget x0) {
        return x0.pattern;
    }

    static /* synthetic */ PopupCreator access$100(FactPatternWidget x0) {
        return x0.popupCreator;
    }

    static /* synthetic */ Widget access$200(FactPatternWidget x0, SingleFieldConstraint x1, DirtyableFlexTable x2, int x3, int x4) {
        return x0.operatorDropDown(x1, x2, x3, x4);
    }

    static /* synthetic */ Widget access$300(FactPatternWidget x0, SingleFieldConstraint x1) {
        return x0.valueEditor(x1);
    }

    static /* synthetic */ void access$400(FactPatternWidget x0) {
        x0.refreshConstraintValueEditorsDropDownData();
    }

    static /* synthetic */ Connectives access$500(FactPatternWidget x0) {
        return x0.connectives;
    }
}

