/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.SelectionCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AdvancedKBaseConfigWidget;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.AssetReference;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.KBaseConfigPanel;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfigEditor;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKBaseConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.SessionType;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.guvnor.client.util.Preconditions;
import org.drools.guvnor.client.widgets.drools.explorer.AssetResourceExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.ExplorerRenderMode;
import org.drools.guvnor.client.widgets.drools.explorer.PackageDisplayMode;

public class KBaseConfigPanel
extends DirtyableComposite {
    private static DroolsGuvnorImages images = (DroolsGuvnorImages)GWT.create(DroolsGuvnorImages.class);
    private static KBaseConfigEditorBinder uiBinder = (KBaseConfigEditorBinder)GWT.create(KBaseConfigEditorBinder.class);
    public static final Map<String, ImageResource> FORMAT_IMAGES = new /* Unavailable Anonymous Inner Class!! */;
    private final String assetPackageUUID;
    private final String assetPackageName;
    private final ClientFactory clientFactory;
    @UiField
    protected Button btnAssetResource;
    @UiField
    protected Button btnRemoveSelected;
    @UiField
    protected Button btnRename;
    @UiField
    protected Button btnAdvancedOptions;
    @UiField
    protected Tree resourceTree;
    @UiField(provided=true)
    final CellTable<ServiceKSessionConfig> cellTable;
    @UiField(provided=true)
    final SimplePager pager;
    private final ListDataProvider<ServiceKSessionConfig> dataProvider = new ListDataProvider();
    private final ServiceConfig config;
    private final ServiceConfigEditor.UpdateTabEvent updateTab;
    private ServiceKBaseConfig kbase;
    private final TreeItem root;
    private final Map<String, Map<String, TreeItem>> resourcesIndex = new HashMap();
    private final Map<String, TreeItem> packageIndex = new HashMap();
    public static final ProvidesKey<ServiceKSessionConfig> KEY_PROVIDER = new /* Unavailable Anonymous Inner Class!! */;

    public KBaseConfigPanel(ServiceConfig config, ServiceKBaseConfig kbase, ServiceConfigEditor.UpdateTabEvent updateTab, String assetPackageUUID, String assetPackageName, ClientFactory clientFactory) {
        this.kbase = (ServiceKBaseConfig)Preconditions.checkNotNull((String)"kbase", (Object)kbase);
        this.config = (ServiceConfig)Preconditions.checkNotNull((String)"config", (Object)config);
        this.updateTab = (ServiceConfigEditor.UpdateTabEvent)Preconditions.checkNotNull((String)"updateTab", (Object)updateTab);
        this.clientFactory = clientFactory;
        this.assetPackageUUID = assetPackageUUID;
        this.assetPackageName = assetPackageName;
        this.cellTable = new CellTable(KEY_PROVIDER);
        this.cellTable.setWidth("100%", false);
        SimplePager.Resources pagerResources = (SimplePager.Resources)GWT.create(SimplePager.Resources.class);
        this.pager = new SimplePager(SimplePager.TextLocation.CENTER, pagerResources, false, 0, true);
        this.pager.setDisplay((HasRows)this.cellTable);
        this.initTableColumns(this.cellTable);
        this.dataProvider.addDataDisplay((HasData)this.cellTable);
        this.dataProvider.getList().addAll(kbase.getKsessions());
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.root = this.resourceTree.addItem(this.treeItemFormat(kbase.getName(), images.enumeration()));
        this.loadContent();
    }

    private void initTableColumns(CellTable<ServiceKSessionConfig> cellTable) {
        MyClickableImageCell addRowCell = new MyClickableImageCell((MyClickableImageCell.ImageCellClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        4 imageColumn = new /* Unavailable Anonymous Inner Class!! */;
        cellTable.addColumn((Column)imageColumn, SafeHtmlUtils.fromSafeConstant((String)"<br/>"));
        cellTable.setColumnWidth((Column)imageColumn, "16px");
        MyClickableImageCell removeRowCell = new MyClickableImageCell((MyClickableImageCell.ImageCellClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        6 imageColumn2 = new /* Unavailable Anonymous Inner Class!! */;
        cellTable.addColumn((Column)imageColumn2, SafeHtmlUtils.fromSafeConstant((String)"<br/>"));
        cellTable.setColumnWidth((Column)imageColumn, "16px");
        EditTextCell textCell = new EditTextCell();
        7 nameColumn = new /* Unavailable Anonymous Inner Class!! */;
        cellTable.addColumn((Column)nameColumn, Constants.INSTANCE.Name());
        nameColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        cellTable.setColumnWidth((Column)nameColumn, "40%");
        ArrayList<String> sessionTypes = new ArrayList<String>(SessionType.values().length);
        for (SessionType activeType : SessionType.values()) {
            sessionTypes.add(activeType.toString().toLowerCase());
        }
        SelectionCell typeCell = new SelectionCell(sessionTypes);
        9 typeColumn = new /* Unavailable Anonymous Inner Class!! */;
        cellTable.addColumn((Column)typeColumn, Constants.INSTANCE.Type());
        typeColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        cellTable.setColumnWidth((Column)typeColumn, "40%");
        11 configAdvanced = new /* Unavailable Anonymous Inner Class!! */;
        cellTable.addColumn((Column)configAdvanced, Constants.INSTANCE.Config());
        configAdvanced.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        cellTable.setColumnWidth((Column)configAdvanced, "20%");
    }

    private void loadContent() {
        for (AssetReference assetReference : this.kbase.getResources()) {
            this.addResource(assetReference);
        }
        for (AssetReference modelReference : this.kbase.getModels()) {
            this.addResource(modelReference);
        }
    }

    @UiHandler(value={"btnRemoveSelected"})
    public void removeSelectedElements(ClickEvent e) {
        ArrayList result = new ArrayList();
        this.buildExcludedList(this.root, result);
        for (TreeItem item : result) {
            if (item.getUserObject() != null) {
                this.removeFromIndexes((AssetReference)item.getUserObject());
            }
            if (item.getUserObject() == null) continue;
            item.remove();
        }
    }

    private void removeFromIndexes(AssetReference userObject) {
        this.removeFromIndex(userObject, this.packageIndex);
        for (Map pkgItem : this.resourcesIndex.values()) {
            this.removeFromIndex(userObject, pkgItem);
        }
    }

    private void removeFromIndex(AssetReference userObject, Map<String, TreeItem> index) {
        for (Map.Entry<String, TreeItem> element : index.entrySet()) {
            AssetReference activeAsset;
            if (element.getValue().getUserObject() == null || !(activeAsset = (AssetReference)element.getValue().getUserObject()).getUuid().equals(userObject.getUuid())) continue;
            index.remove(element.getKey());
            break;
        }
    }

    private void buildExcludedList(TreeItem item, List<TreeItem> result) {
        if (item.getWidget() != null && ((CheckBox)item.getWidget()).getValue().booleanValue()) {
            result.add(item);
        }
        if (item.getChildCount() > 0) {
            for (int i = 0; i < item.getChildCount(); ++i) {
                this.buildExcludedList(item.getChild(i), result);
            }
        }
    }

    @UiHandler(value={"btnAssetResource"})
    public void addNewAssetResource(ClickEvent e) {
        AssetResourceExplorerWidget widget = new AssetResourceExplorerWidget(this.assetPackageUUID, this.assetPackageName, this.clientFactory, AssetFormats.SERVICE_CONFIG_RESOURCE, ExplorerRenderMode.HIDE_NAME_AND_DESCRIPTION, PackageDisplayMode.ALL_PACKAGES);
        InternalPopup popup = new InternalPopup(this, widget.asWidget(), Constants.INSTANCE.AddNewAsset());
        popup.addOkButtonClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    private void addResource(AssetReference asset) {
        if (!this.resourcesIndex.containsKey(asset.getPackageRef())) {
            this.packageIndex.put(asset.getPackageRef(), this.buildTreeItem(this.root, asset.getPackageRef(), images.packageImage(), null));
            this.resourcesIndex.put(asset.getPackageRef(), new HashMap());
        }
        TreeItem pkg = (TreeItem)this.packageIndex.get(asset.getPackageRef());
        if (!((Map)this.resourcesIndex.get(asset.getPackageRef())).containsKey(asset.getFormat())) {
            TreeItem newFormat = this.buildTreeItem(pkg, asset.getFormat(), (ImageResource)FORMAT_IMAGES.get(asset.getFormat()), null);
            ((Map)this.resourcesIndex.get(asset.getPackageRef())).put(asset.getFormat(), newFormat);
        }
        TreeItem parent = (TreeItem)((Map)this.resourcesIndex.get(asset.getPackageRef())).get(asset.getFormat());
        this.buildTreeItem(parent, asset.getName(), images.rules(), asset);
        this.makeDirty();
    }

    private TreeItem buildTreeItem(TreeItem parent, String text, ImageResource image, AssetReference asset) {
        if (asset != null) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                AssetReference currentAsset;
                if (parent.getChild(i).getUserObject() == null || !(currentAsset = (AssetReference)parent.getChild(i).getUserObject()).getName().equals(text)) continue;
                return parent.getChild(i);
            }
        }
        CheckBox checkBox = new CheckBox(this.treeItemFormat(text, image));
        TreeItem newTreeItem = parent.addItem((Widget)checkBox);
        newTreeItem.setUserObject((Object)asset);
        checkBox.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        parent.setState(true, false);
        newTreeItem.setState(true, false);
        return newTreeItem;
    }

    private SafeHtml treeItemFormat(String text, ImageResource image) {
        return new SafeHtmlBuilder().append(SafeHtmlUtils.fromTrustedString((String)AbstractImagePrototype.create((ImageResource)image).getHTML())).appendEscaped(" ").appendEscaped(text).toSafeHtml();
    }

    @UiHandler(value={"btnRename"})
    public void doRename(ClickEvent e) {
        FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.packageLarge(), Constants.INSTANCE.RenameThisKBase());
        TextBox box = new TextBox();
        box.setText(this.kbase.getName());
        pop.addAttribute(Constants.INSTANCE.NewNameAsset(), (IsWidget)box);
        Button ok = new Button(Constants.INSTANCE.RenameKBase());
        pop.addAttribute("", (IsWidget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    public void onSave() {
        ArrayList<AssetReference> resources = new ArrayList<AssetReference>();
        ArrayList<AssetReference> models = new ArrayList<AssetReference>();
        Iterator iterator = this.resourceTree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = (TreeItem)iterator.next();
            if (item.getUserObject() == null) continue;
            AssetReference assetReference = (AssetReference)item.getUserObject();
            if (assetReference.getFormat().equals("jar")) {
                models.add(assetReference);
                continue;
            }
            resources.add(assetReference);
        }
        this.kbase.setModels(models);
        this.kbase.setResources(resources);
    }

    @UiHandler(value={"btnAdvancedOptions"})
    public void advancedOptions(ClickEvent e) {
        AdvancedKBaseConfigWidget widget = new AdvancedKBaseConfigWidget(this.kbase);
        InternalPopup popup = new InternalPopup(this, widget.asWidget(), Constants.INSTANCE.KBaseAdvancedOptions());
        popup.addOkButtonClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    public ServiceKBaseConfig getKBase() {
        return this.kbase;
    }

    static /* synthetic */ DroolsGuvnorImages access$000() {
        return images;
    }

    static /* synthetic */ ServiceKBaseConfig access$100(KBaseConfigPanel x0) {
        return x0.kbase;
    }

    static /* synthetic */ ListDataProvider access$200(KBaseConfigPanel x0) {
        return x0.dataProvider;
    }

    static /* synthetic */ void access$300(KBaseConfigPanel x0, AssetReference x1) {
        x0.addResource(x1);
    }

    static /* synthetic */ ServiceConfig access$400(KBaseConfigPanel x0) {
        return x0.config;
    }

    static /* synthetic */ ServiceKBaseConfig access$102(KBaseConfigPanel x0, ServiceKBaseConfig x1) {
        x0.kbase = x1;
        return x0.kbase;
    }

    static /* synthetic */ ServiceConfigEditor.UpdateTabEvent access$500(KBaseConfigPanel x0) {
        return x0.updateTab;
    }

    static /* synthetic */ SafeHtml access$600(KBaseConfigPanel x0, String x1, ImageResource x2) {
        return x0.treeItemFormat(x1, x2);
    }

    static /* synthetic */ TreeItem access$700(KBaseConfigPanel x0) {
        return x0.root;
    }
}

