/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.EnumDropDown;
import org.drools.guvnor.client.common.DatePickerTextBox;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.TextBoxFactory;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FieldConstraintHelper;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.FieldSelectorWidget;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioParentWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Fact;
import org.drools.ide.common.client.modeldriven.testing.Field;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Scenario;

public class FieldDataConstraintEditor
extends DirtyableComposite
implements HasValueChangeHandlers<String>,
ScenarioParentWidget {
    private FieldData field;
    private IsWidget valueEditorWidget;
    private final Panel panel = new SimplePanel();
    private final FieldConstraintHelper helper;
    private List<FieldDataConstraintEditor> dependentEnumEditors = null;

    public FieldDataConstraintEditor(String factType, FieldData field, Fact givenFact, SuggestionCompletionEngine sce, Scenario scenario, ExecutionTrace executionTrace) {
        this.field = field;
        this.helper = new FieldConstraintHelper(scenario, executionTrace, sce, factType, (Field)field, givenFact);
        this.renderEditor();
        this.initWidget((Widget)this.panel);
    }

    public void renderEditor() {
        String flType = this.helper.getFieldType();
        this.panel.clear();
        if (flType != null && flType.equals("Boolean")) {
            this.valueEditorWidget = this.booleanEditor();
            this.panel.add(this.valueEditorWidget);
        } else if (flType != null && flType.equals("Date")) {
            this.valueEditorWidget = this.dateEditor();
            this.panel.add(this.valueEditorWidget);
        } else {
            DropDownData dropDownData = this.helper.getEnums();
            if (dropDownData != null) {
                this.field.setNature(4L);
                this.dependentEnumEditors = new ArrayList();
                this.valueEditorWidget = this.dropDownEditor(dropDownData);
                this.panel.add(this.valueEditorWidget);
            } else {
                if (this.field.getValue() != null && this.field.getValue().length() > 0 && this.field.getNature() == 0L) {
                    if (this.field.getValue().length() > 1 && this.field.getValue().charAt(1) == '[' && this.field.getValue().charAt(0) == '=') {
                        this.field.setNature(1L);
                    } else if (this.field.getValue().charAt(0) == '=') {
                        this.field.setNature(2L);
                    } else {
                        this.field.setNature(1L);
                    }
                }
                if (this.field.getNature() == 0L && (this.helper.isThereABoundVariableToSet() || this.helper.isItAList())) {
                    this.valueEditorWidget = new FieldSelectorWidget((Field)this.field, this.helper, (ScenarioParentWidget)this);
                    this.panel.add(this.valueEditorWidget);
                } else if (this.field.getNature() == 2L) {
                    this.valueEditorWidget = this.variableEditor();
                    this.panel.add(this.valueEditorWidget);
                } else if (this.field.getNature() == 6L) {
                    this.valueEditorWidget = this.listEditor();
                    this.panel.add(this.valueEditorWidget);
                } else {
                    this.valueEditorWidget = this.textBoxEditor((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */, flType, this.field.getName(), this.field.getValue());
                    this.panel.add(this.valueEditorWidget);
                }
            }
        }
    }

    private EnumDropDown booleanEditor() {
        return new EnumDropDown(this.field.getValue(), (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, DropDownData.create((String[])new String[]{"true", "false"}));
    }

    private EnumDropDown dropDownEditor(DropDownData dropDownData) {
        return new EnumDropDown(this.field.getValue(), (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, dropDownData);
    }

    private DatePickerTextBox dateEditor() {
        DatePickerTextBox editor = new DatePickerTextBox(this.field.getValue());
        editor.setTitle(Constants.INSTANCE.ValueFor0(this.field.getName()));
        editor.addValueChanged((ValueChanged)new /* Unavailable Anonymous Inner Class!! */);
        return editor;
    }

    private TextBox textBoxEditor(ValueChangeHandler<String> valueChangeHandler, String dataType, String fieldName, String initialValue) {
        TextBox tb = TextBoxFactory.getTextBox((String)dataType);
        tb.setText(initialValue);
        tb.setTitle(Constants.INSTANCE.ValueFor0(fieldName));
        tb.addValueChangeHandler(valueChangeHandler);
        return tb;
    }

    private Widget variableEditor() {
        List vars = this.helper.getFactNamesInScope();
        ListBox box = new ListBox();
        if (this.field.getValue() == null) {
            box.addItem(Constants.INSTANCE.Choose());
        }
        int j = 0;
        for (String var : vars) {
            if (!this.helper.getFactTypeByVariableName(var).getType().equals(this.helper.resolveFieldType())) continue;
            if (box.getItemCount() == 0) {
                box.addItem("...");
                ++j;
            }
            box.addItem("=" + var);
            if (this.field.getValue() != null && this.field.getValue().equals("=" + var)) {
                box.setSelectedIndex(j);
            }
            ++j;
        }
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private Widget listEditor() {
        VerticalPanel panel = new VerticalPanel();
        int i = 0;
        for (FieldData f : this.field.collectionFieldList) {
            DirtyableHorizontalPane hpanel = new DirtyableHorizontalPane();
            FieldDataConstraintEditor fieldDataConstraintEditor = this.helper.createFieldDataConstraintEditor(f);
            fieldDataConstraintEditor.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)fieldDataConstraintEditor);
            int index = i++;
            hpanel.add((Widget)new ImageButton(DroolsGuvnorImages.INSTANCE.deleteItemSmall(), Constants.INSTANCE.AElementToDelInCollectionList(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
            ImageButton addPattern = new ImageButton(DroolsGuvnorImages.INSTANCE.newItemBelow());
            addPattern.setTitle(Constants.INSTANCE.AddElementBelow());
            addPattern.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)addPattern);
            ImageButton moveDown = new ImageButton(DroolsGuvnorImages.INSTANCE.shuffleDown());
            moveDown.setTitle(Constants.INSTANCE.MoveDownListMove());
            moveDown.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)moveDown);
            ImageButton moveUp = new ImageButton(DroolsGuvnorImages.INSTANCE.shuffleUp());
            moveUp.setTitle(Constants.INSTANCE.MoveUpList());
            moveUp.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            hpanel.add((Widget)moveUp);
            panel.add((Widget)hpanel);
        }
        if (this.field.collectionFieldList.size() == 0) {
            ImageButton add = new ImageButton(DroolsGuvnorImages.INSTANCE.newItem(), Constants.INSTANCE.AElementToAddInCollectionList(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            panel.add((Widget)add);
        }
        return panel;
    }

    private void calculateValueFromList() {
        if (this.field.collectionFieldList == null || this.field.collectionFieldList.isEmpty()) {
            this.field.setValue("=[]");
            return;
        }
        StringBuilder listContent = new StringBuilder();
        for (FieldData f : this.field.collectionFieldList) {
            listContent.append(',');
            if (f.getValue() == null) continue;
            listContent.append(f.getValue());
        }
        this.field.setValue("=[" + listContent.substring(1) + "]");
    }

    private void valueHasChanged(String newValue) {
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)newValue);
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> stringValueChangeHandler) {
        return this.addHandler(stringValueChangeHandler, ValueChangeEvent.getType());
    }

    public void addIfDependentEnumEditor(FieldDataConstraintEditor candidateDependentEnumEditor) {
        if (this.helper.isDependentEnum(candidateDependentEnumEditor.helper)) {
            this.dependentEnumEditors.add(candidateDependentEnumEditor);
        }
    }

    private void refreshDropDownData() {
        if (this.valueEditorWidget instanceof EnumDropDown) {
            EnumDropDown dropdown = (EnumDropDown)this.valueEditorWidget;
            dropdown.setDropDownData(this.field.getValue(), this.helper.getEnums());
        }
    }

    static /* synthetic */ void access$000(FieldDataConstraintEditor x0, String x1) {
        x0.valueHasChanged(x1);
    }

    static /* synthetic */ List access$100(FieldDataConstraintEditor x0) {
        return x0.dependentEnumEditors;
    }

    static /* synthetic */ void access$200(FieldDataConstraintEditor x0) {
        x0.refreshDropDownData();
    }

    static /* synthetic */ FieldData access$300(FieldDataConstraintEditor x0) {
        return x0.field;
    }

    static /* synthetic */ void access$400(FieldDataConstraintEditor x0) {
        x0.calculateValueFromList();
    }
}

