/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.server.contenthandler.drools.ServiceConfigPersistence;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.generators.ServiceWarGenerator;
import org.drools.repository.AssetItem;
import org.drools.repository.RulesRepository;

public class ServiceWarBuilderAndDownloadHandler
extends RepositoryServlet {
    @Inject
    private RulesRepository repository;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        AssetItem asset;
        String uuid = req.getParameter("uuid");
        if (uuid == null) {
            res.sendError(400);
        }
        if ((asset = this.repository.loadAssetByUUID(uuid)) == null) {
            res.sendError(204);
            return;
        }
        ServiceConfig serviceConfig = ServiceConfigPersistence.getInstance().unmarshal(asset.getContent());
        try {
            res.setContentType("application/x-download");
            res.setHeader("Content-Disposition", "attachment; filename=drools-service.war;");
            ServiceWarGenerator.buildWar((ServiceConfig)serviceConfig, (RulesRepository)this.repository, (OutputStream)res.getOutputStream());
        }
        catch (Throwable e) {
            res.getOutputStream().close();
            res.sendError(500, e.getMessage());
        }
    }
}

