/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.SuggestionCompletionEngineService;
import org.drools.guvnor.server.SuggestionCompletionEngineLoaderInitializer;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.remoting.annotations.WebRemote;
import org.jboss.seam.security.annotations.LoggedIn;

public class SuggestionCompletionEngineServiceImplementation
implements SuggestionCompletionEngineService {
    private static final LoggingHelper log = LoggingHelper.getLogger(SuggestionCompletionEngineService.class);
    @Inject
    private RulesRepository rulesRepository;

    @WebRemote
    @LoggedIn
    public SuggestionCompletionEngine loadSuggestionCompletionEngine(String packageName) throws SerializationException {
        SuggestionCompletionEngine suggestionCompletionEngine = null;
        try {
            ModuleItem packageItem = this.rulesRepository.loadModule(packageName);
            suggestionCompletionEngine = new SuggestionCompletionEngineLoaderInitializer().loadFor(packageItem);
        }
        catch (RulesRepositoryException e) {
            log.error("An error occurred loadSuggestionCompletionEngine: " + e.getMessage());
            throw new SerializationException(e.getMessage());
        }
        return suggestionCompletionEngine;
    }
}

