/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.shared.simulation;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Random;
import java.util.TreeMap;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.guvnor.shared.simulation.SimulationStepModel;

/*
 * Exception performing whole class analysis ignored.
 */
@XStreamAlias(value="SimulationPathModel")
public class SimulationPathModel
implements PortableObject {
    private String name;
    private TreeMap<Long, SimulationStepModel> steps = new TreeMap();

    public static SimulationPathModel createNew() {
        SimulationPathModel path = new SimulationPathModel();
        path.addStep(SimulationStepModel.createNew((SimulationPathModel)path));
        SimulationPathModel.todoCreateTestdata((SimulationPathModel)path);
        return path;
    }

    private static void todoCreateTestdata(SimulationPathModel path) {
        long nextDistanceMillis = 1000L;
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            nextDistanceMillis += (long)(random.nextInt(2000) + 1000);
            if (!random.nextBoolean()) continue;
            SimulationStepModel step = SimulationStepModel.createNew((SimulationPathModel)path);
            step.setDistanceMillis(Long.valueOf(nextDistanceMillis));
            path.addStep(step);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TreeMap<Long, SimulationStepModel> getSteps() {
        return this.steps;
    }

    public void addStep(SimulationStepModel step) {
        if (step.getPath() != this) {
            throw new IllegalArgumentException("The simulation step's path (" + step.getPath() + ") is not this path (" + this + ").");
        }
        if (step.getDistanceMillis() == null) {
            this.generateStepDistanceMillis(step);
        }
        if (this.steps.containsKey(step.getDistanceMillis())) {
            throw new IllegalArgumentException("The simulation step's distanceMillis (" + step.getDistanceMillis() + ") is not unique.");
        }
        this.steps.put(step.getDistanceMillis(), step);
    }

    public void removeStep(SimulationStepModel step) {
        if (step.getPath() != this) {
            throw new IllegalArgumentException("The simulation step's path (" + step.getPath() + ") is not this path (" + this + ").");
        }
        Long distanceMillis = step.getDistanceMillis();
        if (!this.steps.containsKey(distanceMillis)) {
            throw new IllegalArgumentException("The simulation step's distanceMillis (" + distanceMillis + ") is not known. It probably changed while it was in the Map.");
        }
        this.steps.remove(distanceMillis);
    }

    private void generateStepDistanceMillis(SimulationStepModel step) {
        Long stepDistanceMillis = this.steps.isEmpty() ? Long.valueOf(0L) : Long.valueOf((Long)this.steps.lastKey() + 1000L);
        step.setDistanceMillis(stepDistanceMillis);
    }

    public long getMaximumDistanceMillis() {
        if (this.steps.isEmpty()) {
            return 0L;
        }
        return (Long)this.steps.lastKey();
    }
}

