/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.Set;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.VerificationService;
import org.drools.guvnor.client.rpc.WorkingSetConfigData;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.verification.AssetVerifier;
import org.drools.guvnor.server.verification.PackageVerifier;
import org.drools.guvnor.server.verification.TemporalBRLAssetVerifier;
import org.drools.guvnor.server.verification.VerifierConfigurationFactory;
import org.drools.repository.AssetItem;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.builder.VerifierBuilderFactory;
import org.jboss.seam.remoting.annotations.WebRemote;
import org.jboss.seam.security.annotations.LoggedIn;

public class VerificationServiceImplementation
extends RemoteServiceServlet
implements VerificationService {
    private static final long serialVersionUID = 510L;
    private static final LoggingHelper log = LoggingHelper.getLogger(VerificationService.class);
    private final Verifier defaultVerifier = VerifierBuilderFactory.newVerifierBuilder().newVerifier();
    @Inject
    protected ServiceSecurity serviceSecurity;
    @Inject
    protected RulesRepository rulesRepository;
    @Inject
    protected RepositoryAssetService repositoryAssetService;

    @WebRemote
    @LoggedIn
    public AnalysisReport analysePackage(String packageUUID) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(packageUUID);
        AnalysisReport report = new PackageVerifier(this.defaultVerifier, this.rulesRepository.loadModuleByUUID(packageUUID)).verify();
        this.defaultVerifier.flushKnowledgeSession();
        return report;
    }

    @WebRemote
    @LoggedIn
    public AnalysisReport verifyAsset(Asset asset, Set<String> activeWorkingSetIds) throws SerializationException {
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        return this.verify(asset, VerifierConfigurationFactory.getDefaultConfigurationWithWorkingSetConstraints((Asset[])this.loadWorkingSets(activeWorkingSetIds)));
    }

    @WebRemote
    @LoggedIn
    public AnalysisReport verifyAssetWithoutVerifiersRules(Asset asset, Set<WorkingSetConfigData> activeWorkingSets) throws SerializationException {
        this.serviceSecurity.checkIsPackageDeveloperOrAnalyst(asset);
        return this.verify(asset, VerifierConfigurationFactory.getPlainWorkingSetVerifierConfiguration(activeWorkingSets));
    }

    private Asset[] loadWorkingSets(Set<String> activeWorkingSets) throws SerializationException {
        if (activeWorkingSets == null) {
            return new Asset[0];
        }
        return this.repositoryAssetService.loadRuleAssets(activeWorkingSets.toArray(new String[activeWorkingSets.size()]));
    }

    private AnalysisReport verify(Asset asset, VerifierConfiguration verifierConfiguration) throws SerializationException {
        long startTime = System.currentTimeMillis();
        AnalysisReport report = null;
        report = asset.getState().equals("temporal") ? this.getTemporalBRLAssetVerifier(verifierConfiguration, asset).verify() : this.getAssetVerifier(verifierConfiguration, this.getAssetItem(asset)).verify();
        log.debug("Asset verification took: " + (System.currentTimeMillis() - startTime));
        return report;
    }

    private AssetItem getAssetItem(Asset asset) throws SerializationException {
        AssetItem assetItem = this.rulesRepository.loadAssetByUUID(asset.getUuid());
        ContentHandler contentHandler = ContentManager.getHandler((String)asset.getFormat());
        contentHandler.storeAssetContent(asset, assetItem);
        return assetItem;
    }

    private AssetVerifier getAssetVerifier(VerifierConfiguration verifierConfiguration, AssetItem assetItem) throws SerializationException {
        return new AssetVerifier(VerifierBuilderFactory.newVerifierBuilder().newVerifier(verifierConfiguration), assetItem);
    }

    private TemporalBRLAssetVerifier getTemporalBRLAssetVerifier(VerifierConfiguration verifierConfiguration, Asset ruleAsset) throws SerializationException {
        ModuleItem pkg = this.repositoryAssetService.getRulesRepository().loadModule(ruleAsset.getMetaData().moduleName);
        return new TemporalBRLAssetVerifier(VerifierBuilderFactory.newVerifierBuilder().newVerifier(verifierConfiguration), ruleAsset, pkg);
    }
}

