/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.Iterator;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.DroolsService;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.util.BRMSSuggestionCompletionLoader;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.repository.RulesRepository;
import org.jboss.seam.remoting.annotations.WebRemote;
import org.jboss.seam.security.annotations.LoggedIn;

@ApplicationScoped
public class DroolsServiceImplementation
implements DroolsService {
    private static final LoggingHelper log = LoggingHelper.getLogger(DroolsService.class);
    private RulesRepository rulesRepository;
    private ServiceSecurity serviceSecurity;

    public DroolsServiceImplementation() {
    }

    @Inject
    public DroolsServiceImplementation(@Preferred RulesRepository rulesRepository, ServiceSecurity serviceSecurity) {
        this.rulesRepository = rulesRepository;
        this.serviceSecurity = serviceSecurity;
    }

    @WebRemote
    @LoggedIn
    public ValidatedResponse validateModule(Module data) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(data.getUuid());
        log.info("USER:" + this.getCurrentUserName() + " validateModule module [" + data.getName() + "]");
        RuleBaseCache.getInstance().remove(data.getUuid());
        BRMSSuggestionCompletionLoader loader = this.createBRMSSuggestionCompletionLoader();
        loader.getSuggestionEngine(this.rulesRepository.loadModule(data.getName()), data.getHeader());
        return this.validateBRMSSuggestionCompletionLoaderResponse(loader);
    }

    BRMSSuggestionCompletionLoader createBRMSSuggestionCompletionLoader() {
        return new BRMSSuggestionCompletionLoader();
    }

    private ValidatedResponse validateBRMSSuggestionCompletionLoaderResponse(BRMSSuggestionCompletionLoader loader) {
        ValidatedResponse res = new ValidatedResponse();
        if (loader.hasErrors()) {
            res.hasErrors = true;
            String err = "";
            Iterator iter = loader.getErrors().iterator();
            while (iter.hasNext()) {
                err = err + (String)iter.next();
                if (!iter.hasNext()) continue;
                err = err + "\n";
            }
            res.errorHeader = "Package validation errors";
            res.errorMessage = err;
        }
        return res;
    }

    private String getCurrentUserName() {
        return this.rulesRepository.getSession().getUserID();
    }
}

