/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.analysis.condition;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.decisiontable.analysis.condition.ConditionDetector;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class EnumConditionDetector
extends ConditionDetector<EnumConditionDetector> {
    private final List<String> allowedValueList = new ArrayList();

    public EnumConditionDetector(Pattern52 pattern, String factField, List<String> allValueList, String value, String operator) {
        super(pattern, factField);
        if (operator.equals("==")) {
            if (allValueList.contains(value)) {
                this.allowedValueList.add(value);
            } else {
                System.out.println("Warning: value (" + value + ") is not a valid enum value (" + allValueList + ").");
            }
        } else if (operator.equals("!=")) {
            this.allowedValueList.addAll(allValueList);
            this.allowedValueList.remove(value);
        } else if (operator.equals("in")) {
            String[] tokens;
            for (String token : tokens = value.split(",")) {
                if (allValueList.contains(token)) {
                    this.allowedValueList.add(token);
                    continue;
                }
                System.out.println("Warning: value (" + token + ") is not a valid enum value (" + allValueList + ").");
            }
        } else {
            this.allowedValueList.addAll(allValueList);
            this.hasUnrecognizedConstraint = true;
        }
    }

    public EnumConditionDetector(EnumConditionDetector a, EnumConditionDetector b) {
        super((ConditionDetector)a, (ConditionDetector)b);
        this.allowedValueList.addAll(a.allowedValueList);
        this.allowedValueList.retainAll(b.allowedValueList);
        this.detectImpossibleMatch();
    }

    private void detectImpossibleMatch() {
        if (this.allowedValueList.isEmpty()) {
            this.impossibleMatch = true;
        }
    }

    public EnumConditionDetector merge(EnumConditionDetector other) {
        return new EnumConditionDetector(this, other);
    }
}

