/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.drools.ClockType;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.WorkingMemory;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.BinaryRuleBaseLoader;
import org.drools.event.AgendaEventListener;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;
import org.drools.guvnor.client.rpc.ScenarioRunResult;
import org.drools.guvnor.client.rpc.SingleScenarioResult;
import org.drools.guvnor.client.rpc.TestScenarioService;
import org.drools.guvnor.client.rpc.WorkItemService;
import org.drools.guvnor.server.RepositoryAssetOperations;
import org.drools.guvnor.server.RepositoryModuleOperations;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.builder.AuditLogReporter;
import org.drools.guvnor.server.builder.ClassLoaderBuilder;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.server.testscenarios.RuleCoverageListener;
import org.drools.ide.common.server.testscenarios.ScenarioRunner;
import org.drools.ide.common.shared.workitems.PortableWorkDefinition;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.rule.Package;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.rule.ConsequenceException;
import org.drools.util.CompositeClassLoader;
import org.jboss.seam.remoting.annotations.WebRemote;
import org.jboss.seam.security.annotations.LoggedIn;

public class TestScenarioServiceImplementation
implements TestScenarioService {
    private static final LoggingHelper log = LoggingHelper.getLogger(TestScenarioService.class);
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    private ServiceSecurity serviceSecurity;
    @Inject
    private RepositoryAssetOperations repositoryAssetOperations;
    @Inject
    private WorkItemService workItemService;
    @Inject
    private ServiceImplementation serviceImplementation;
    @Inject
    private RepositoryModuleOperations repositoryModuleOperations;

    @WebRemote
    @LoggedIn
    public SingleScenarioResult runScenario(String packageName, Scenario scenario) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(packageName);
        return this.runScenario(packageName, scenario, null);
    }

    private SingleScenarioResult runScenario(String packageName, Scenario scenario, RuleCoverageListener coverage) throws SerializationException {
        try {
            return this.runScenario(scenario, this.rulesRepository.loadModule(packageName), coverage);
        }
        catch (Exception e) {
            if (e instanceof DetailedSerializationException) {
                DetailedSerializationException exception = (DetailedSerializationException)((Object)e);
                if (exception.getErrs() != null) {
                    return new SingleScenarioResult(new ScenarioRunResult(exception.getErrs()));
                }
                throw exception;
            }
            throw new DetailedSerializationException("Unable to run the scenario.", e.getMessage());
        }
    }

    private SingleScenarioResult runScenario(Scenario scenario, ModuleItem item, RuleCoverageListener coverage) throws DetailedSerializationException {
        RuleBase ruleBase = this.loadCacheRuleBase(item);
        Package aPackage = ruleBase.getPackages()[0];
        SessionConfiguration sessionConfiguration = new SessionConfiguration();
        sessionConfiguration.setClockType(ClockType.PSEUDO_CLOCK);
        sessionConfiguration.setKeepReference(false);
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession(sessionConfiguration, null);
        if (coverage != null) {
            workingMemory.addEventListener((AgendaEventListener)coverage);
        }
        WorkItemHandler workItemHandlerStub = this.getWorkItemHandlerStub();
        for (PortableWorkDefinition portableWorkDefinition : this.workItemService.loadWorkItemDefinitions(item.getUUID())) {
            workingMemory.getWorkItemManager().registerWorkItemHandler(portableWorkDefinition.getName(), workItemHandlerStub);
        }
        try {
            AuditLogReporter logger = new AuditLogReporter((WorkingMemory)workingMemory);
            CompositeClassLoader classLoader = ((InternalRuleBase)ruleBase).getRootClassLoader();
            new ScenarioRunner((TypeResolver)new ClassTypeResolver(this.getAllImports(aPackage), (ClassLoader)classLoader), (ClassLoader)classLoader, workingMemory).run(scenario);
            return new SingleScenarioResult(new ScenarioRunResult(scenario), logger.buildReport());
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load a required class.", (Throwable)e);
            throw new DetailedSerializationException("Unable to load a required class.", e.getMessage());
        }
        catch (ConsequenceException e) {
            String messageShort = "There was an error executing the consequence of rule [" + e.getRule().getName() + "]";
            String messageLong = e.getMessage();
            if (e.getCause() != null) {
                messageLong = messageLong + "\nCAUSED BY " + e.getCause().getMessage();
            }
            log.error(messageShort + ": " + messageLong, (Throwable)e);
            throw new DetailedSerializationException(messageShort, messageLong);
        }
        catch (Exception e) {
            log.error("Unable to run the scenario.", (Throwable)e);
            throw new DetailedSerializationException("Unable to run the scenario.", e.getMessage());
        }
    }

    private Set<String> getAllImports(Package aPackage) {
        HashSet<String> allImports = new HashSet<String>(aPackage.getImports().keySet());
        if (aPackage.getGlobals() != null) {
            for (String o : aPackage.getGlobals().keySet()) {
                allImports.add((String)aPackage.getGlobals().get(o));
            }
        }
        allImports.add(aPackage.getName() + ".*");
        return allImports;
    }

    private RuleBase loadCacheRuleBase(ModuleItem packageItem) throws DetailedSerializationException {
        if (packageItem.isBinaryUpToDate() && RuleBaseCache.getInstance().contains(packageItem.getUUID())) {
            return RuleBaseCache.getInstance().get(packageItem.getUUID());
        }
        if (packageItem.isBinaryUpToDate()) {
            RuleBase ruleBase = this.loadRuleBase(packageItem);
            RuleBaseCache.getInstance().put(packageItem.getUUID(), ruleBase);
            return ruleBase;
        }
        this.repositoryModuleOperations.buildModuleWithoutErrors(packageItem, false);
        RuleBase ruleBase = this.loadRuleBase(packageItem);
        RuleBaseCache.getInstance().put(packageItem.getUUID(), ruleBase);
        return ruleBase;
    }

    public BulkTestRunResult runScenariosInPackage(ModuleItem packageItem) throws SerializationException {
        if (!packageItem.isBinaryUpToDate() || !RuleBaseCache.getInstance().contains(packageItem.getUUID())) {
            if (packageItem.isBinaryUpToDate()) {
                RuleBaseCache.getInstance().put(packageItem.getUUID(), this.loadRuleBase(packageItem));
            } else {
                BuilderResult result = this.repositoryModuleOperations.buildModule(packageItem, false);
                if (result == null || result.getLines().size() == 0) {
                    RuleBaseCache.getInstance().put(packageItem.getUUID(), this.loadRuleBase(packageItem));
                } else {
                    return new BulkTestRunResult(result, null, 0, null);
                }
            }
        }
        AssetItemIterator it = packageItem.listAssetsByFormat(new String[]{"scenario"});
        ArrayList<ScenarioResultSummary> resultSummaries = new ArrayList<ScenarioResultSummary>();
        RuleBase rb = RuleBaseCache.getInstance().get(packageItem.getUUID());
        Package bin = rb.getPackages()[0];
        RuleCoverageListener coverage = new RuleCoverageListener(this.expectedRules(bin));
        while (it.hasNext()) {
            AssetItem as = it.next();
            if (as.getDisabled()) continue;
            Asset asset = this.repositoryAssetOperations.loadAsset(as);
            Scenario sc = (Scenario)asset.getContent();
            this.runScenario(packageItem.getName(), sc, coverage);
            int[] totals = sc.countFailuresTotal();
            resultSummaries.add(new ScenarioResultSummary(totals[0], totals[1], asset.getName(), asset.getDescription(), asset.getUuid()));
        }
        ScenarioResultSummary[] summaries = resultSummaries.toArray(new ScenarioResultSummary[resultSummaries.size()]);
        return new BulkTestRunResult(null, resultSummaries.toArray(summaries), coverage.getPercentCovered(), coverage.getUnfiredRules());
    }

    private HashSet<String> expectedRules(Package bin) {
        HashSet<String> h = new HashSet<String>();
        for (int i = 0; i < bin.getRules().length; ++i) {
            h.add(bin.getRules()[i].getName());
        }
        return h;
    }

    private WorkItemHandler getWorkItemHandlerStub() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private RuleBase loadRuleBase(ModuleItem item) throws DetailedSerializationException {
        try {
            return this.deserKnowledgebase(item, (ClassLoader)this.createClassLoaderBuilder(item).buildClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load rule base.", (Throwable)e);
            throw new DetailedSerializationException("A required class was not found.", e.getMessage());
        }
        catch (Exception e) {
            log.error("Unable to load rule base.", (Throwable)e);
            log.info("...but trying to rebuild binaries...");
            try {
                BuilderResult builderResult = this.repositoryModuleOperations.buildModule(item, true);
                if (builderResult != null && builderResult.getLines().size() > 0) {
                    log.error("There were errors when rebuilding the knowledgebase.");
                    throw new DetailedSerializationException("There were errors when rebuilding the knowledgebase.", "");
                }
            }
            catch (Exception e1) {
                log.error("Unable to rebuild the rulebase: " + e.getMessage());
                throw new DetailedSerializationException("Unable to rebuild the rulebase.", e.getMessage());
            }
            try {
                return this.deserKnowledgebase(item, (ClassLoader)this.createClassLoaderBuilder(item).buildClassLoader());
            }
            catch (Exception e2) {
                log.error("Unable to reload knowledgebase: " + e.getMessage());
                throw new DetailedSerializationException("Unable to reload knowledgebase.", e.getMessage());
            }
        }
    }

    private ClassLoaderBuilder createClassLoaderBuilder(ModuleItem packageItem) {
        return new ClassLoaderBuilder(packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"jar"}));
    }

    private RuleBase deserKnowledgebase(ModuleItem item, ClassLoader classloader) throws IOException, ClassNotFoundException {
        RuleBase rulebase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)new RuleBaseConfiguration(new ClassLoader[]{classloader}));
        BinaryRuleBaseLoader rbl = new BinaryRuleBaseLoader(rulebase, classloader);
        rbl.addPackage((InputStream)new ByteArrayInputStream(item.getCompiledBinaryBytes()));
        return rulebase;
    }

    @WebRemote
    @LoggedIn
    public BulkTestRunResult runScenariosInPackage(String packageUUID) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(packageUUID);
        ModuleItem item = this.rulesRepository.loadModuleByUUID(packageUUID);
        return this.runScenariosInPackage(item);
    }
}

