/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.definition.process.WorkflowProcess;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.server.builder.AssemblyErrorLogger;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.RuleFlowContentModelBuilder;
import org.drools.guvnor.server.builder.RuleFlowProcessBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ICanHasAttachment;
import org.drools.guvnor.server.contenthandler.ICompilable;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.repository.AssetItem;
import org.drools.xml.SemanticModule;
import org.jbpm.compiler.xml.ProcessSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.compiler.xml.XmlRuleFlowProcessDumper;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class RuleFlowHandler
extends ContentHandler
implements ICompilable,
ICanHasAttachment {
    private static final LoggingHelper log = LoggingHelper.getLogger(RuleFlowHandler.class);

    public void retrieveAssetContent(Asset asset, AssetItem item) throws SerializationException {
        RuleFlowProcess process = this.readProcess((InputStream)new ByteArrayInputStream(item.getContent().getBytes()));
        if (process != null) {
            RuleFlowContentModel content = RuleFlowContentModelBuilder.createModel((RuleFlowProcess)process);
            content.setXml(item.getContent());
            asset.setContent((PortableObject)content);
        } else if (process == null && !"".equals(item.getContent())) {
            asset.setContent((PortableObject)new RuleFlowContentModel());
            ((RuleFlowContentModel)asset.getContent()).setXml(item.getContent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuleFlowProcess readProcess(InputStream is) {
        RuleFlowProcess process;
        block19: {
            List processes = null;
            process = null;
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(is);
                PackageBuilderConfiguration configuration = new PackageBuilderConfiguration();
                configuration.initSemanticModules();
                configuration.addSemanticModule((SemanticModule)new ProcessSemanticModule());
                XmlProcessReader xmlReader = new XmlProcessReader(configuration.getSemanticModules(), RuleFlowHandler.getClassLoader());
                processes = xmlReader.read((Reader)reader);
                if (processes.size() == 0) {
                    String message = "RuleFlowProcess not found.";
                    log.error("RuleFlowProcess not found.");
                    throw new RuntimeException("RuleFlowProcess not found.");
                }
                if (processes.size() > 1) {
                    String message = "An asset can only contain one RuleFlowProcess. Multiple were detected.";
                    log.error("An asset can only contain one RuleFlowProcess. Multiple were detected.");
                    throw new RuntimeException("An asset can only contain one RuleFlowProcess. Multiple were detected.");
                }
                if (processes.get(0) instanceof RuleFlowProcess) {
                    process = (RuleFlowProcess)processes.get(0);
                    break block19;
                }
                String message = "The asset does not contain a RuleFlowProcess. Unable to process.";
                log.error("The asset does not contain a RuleFlowProcess. Unable to process.");
                throw new RuntimeException("The asset does not contain a RuleFlowProcess. Unable to process.");
            }
            catch (SAXException se) {
                log.error(se.getMessage());
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage());
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ioe) {
                        log.error(ioe.getMessage());
                    }
                }
            }
        }
        return process;
    }

    public void storeAssetContent(Asset asset, AssetItem repoAsset) throws SerializationException {
        RuleFlowContentModel content = (RuleFlowContentModel)asset.getContent();
        if (content != null && content.getXml() != null) {
            RuleFlowProcess process = this.readProcess((InputStream)new ByteArrayInputStream(content.getXml().getBytes()));
            if (process != null) {
                RuleFlowProcessBuilder.updateProcess((RuleFlowProcess)process, (Collection)content.getNodes());
                XmlRuleFlowProcessDumper dumper = XmlRuleFlowProcessDumper.INSTANCE;
                String out = dumper.dump((WorkflowProcess)process);
                repoAsset.updateContent(out);
            } else {
                repoAsset.updateContent(content.getXml());
            }
        }
    }

    public void onAttachmentAdded(AssetItem item) {
        String originalPackageName;
        String packageName;
        RuleFlowProcess process;
        String content = item.getContent();
        if (content != null && !content.equals("") && (process = this.readProcess((InputStream)new ByteArrayInputStream(content.getBytes()))) != null && !(packageName = item.getModuleName()).equals(originalPackageName = process.getPackageName())) {
            process.setPackageName(packageName);
            XmlRuleFlowProcessDumper dumper = XmlRuleFlowProcessDumper.INSTANCE;
            String out = dumper.dump((WorkflowProcess)process);
            item.updateContent(out);
            item.checkin("Changed rule flow package from " + originalPackageName + " to " + packageName);
        }
    }

    public void onAttachmentRemoved(AssetItem item) throws IOException {
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, AssemblyErrorLogger logger) throws DroolsParserException, IOException {
        InputStream ins = asset.getBinaryContentAttachment();
        if (ins != null) {
            builder.addRuleFlow((Reader)new InputStreamReader(asset.getBinaryContentAttachment()));
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = RuleFlowHandler.class.getClassLoader();
        }
        return cl;
    }
}

