/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.simulation;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.fluent.session.StatefulKnowledgeSessionSimFluent;
import org.drools.fluent.simulation.impl.DefaultSimulationFluent;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.server.RepositoryModuleService;
import org.drools.guvnor.shared.simulation.SimulationModel;
import org.drools.guvnor.shared.simulation.SimulationTestService;
import org.drools.guvnor.shared.simulation.command.AbstractCommandModel;
import org.drools.guvnor.shared.simulation.command.AssertRuleFiredCommandModel;
import org.drools.guvnor.shared.simulation.command.FireAllRulesCommandModel;
import org.drools.guvnor.shared.simulation.command.InsertBulkDataCommandModel;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.jboss.seam.security.annotations.LoggedIn;

@ApplicationScoped
public class SimulationTestServiceImpl
implements SimulationTestService {
    @Inject
    private RulesRepository rulesRepository;
    @Inject
    private RepositoryModuleService repositoryModuleService;

    @LoggedIn
    public void runSimulation(String moduleName, SimulationModel simulation) throws DetailedSerializationException {
        ModuleItem moduleItem = this.rulesRepository.loadModule(moduleName);
        this.repositoryModuleService.ensureBinaryUpToDate(moduleItem);
        DefaultSimulationFluent simulationFluent = new DefaultSimulationFluent();
        simulationFluent.runSimulation();
    }

    private void addCommand(StatefulKnowledgeSessionSimFluent session, AbstractCommandModel abstractCommand) {
        InsertBulkDataCommandModel command;
        if (abstractCommand instanceof InsertBulkDataCommandModel) {
            command = (InsertBulkDataCommandModel)abstractCommand;
            session.insert((Object)"Hello world");
        }
        if (abstractCommand instanceof FireAllRulesCommandModel) {
            command = (FireAllRulesCommandModel)abstractCommand;
            session.fireAllRules();
            for (AssertRuleFiredCommandModel assertRuleFiredCommand : command.getAssertRuleFiredCommands()) {
                session.assertRuleFired(assertRuleFiredCommand.getRuleName(), assertRuleFiredCommand.getFireCount());
            }
        } else {
            throw new IllegalStateException("The AbstractCommandModel class (" + abstractCommand.getClass() + ") is not implemented on the server side.");
        }
    }
}

