/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler.drools;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.dmg.pmml.pmml_4_1.descr.Characteristic;
import org.dmg.pmml.pmml_4_1.descr.Characteristics;
import org.dmg.pmml.pmml_4_1.descr.Extension;
import org.dmg.pmml.pmml_4_1.descr.FIELDUSAGETYPE;
import org.dmg.pmml.pmml_4_1.descr.INVALIDVALUETREATMENTMETHOD;
import org.dmg.pmml.pmml_4_1.descr.MiningField;
import org.dmg.pmml.pmml_4_1.descr.MiningSchema;
import org.dmg.pmml.pmml_4_1.descr.Output;
import org.dmg.pmml.pmml_4_1.descr.PMML;
import org.dmg.pmml.pmml_4_1.descr.Scorecard;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.server.builder.AssemblyErrorLogger;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.IHasCustomValidator;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.ide.common.client.modeldriven.scorecards.Attribute;
import org.drools.ide.common.client.modeldriven.scorecards.ScorecardModel;
import org.drools.ide.common.server.util.ScorecardsXMLPersistence;
import org.drools.repository.AssetItem;
import org.drools.scorecards.ScorecardCompiler;
import org.drools.scorecards.pmml.PMMLGenerator;
import org.drools.scorecards.pmml.ScorecardPMMLUtils;

public class ScorecardsContentHandler
extends ContentHandler
implements IRuleAsset,
IHasCustomValidator {
    public void retrieveAssetContent(Asset asset, AssetItem item) throws SerializationException {
        ScorecardModel model = ScorecardsXMLPersistence.getInstance().unmarshall(item.getContent());
        asset.setContent((PortableObject)model);
    }

    public void storeAssetContent(Asset asset, AssetItem repoAsset) throws SerializationException {
        ScorecardModel model = (ScorecardModel)asset.getContent();
        repoAsset.updateContent(ScorecardsXMLPersistence.getInstance().marshal(model));
    }

    public void assembleDRL(BRMSPackageBuilder builder, AssetItem assetItem, StringBuilder stringBuilder) {
        ScorecardModel model = ScorecardsXMLPersistence.getInstance().unmarshall(assetItem.getContent());
        BuilderResult validationResult = this.validateScorecard(model);
        if (!validationResult.hasLines()) {
            String drl = this.getDrlFromScorecardModel(model);
            stringBuilder.append(drl);
        }
    }

    public void assembleDRL(BRMSPackageBuilder builder, Asset asset, StringBuilder stringBuilder) {
        ScorecardModel model = (ScorecardModel)asset.getContent();
        BuilderResult validationResult = this.validateScorecard(model);
        if (validationResult.hasLines()) {
            if (StringUtils.isBlank((String)model.getName())) {
                stringBuilder.append("//Guided Scorecard has errors, Click on Source->Validate to view exact errors!");
            } else {
                stringBuilder.append("//Guided Scorecard ('" + model.getName() + "') has errors, Click on Source->Validate to view exact errors!");
            }
            return;
        }
        String drl = this.getDrlFromScorecardModel(model);
        stringBuilder.append(drl);
    }

    public String getRawDRL(AssetItem assetItem) {
        ScorecardModel model = ScorecardsXMLPersistence.getInstance().unmarshall(assetItem.getContent());
        BuilderResult validationResult = this.validateScorecard(model);
        if (!validationResult.hasLines()) {
            return this.getDrlFromScorecardModel(model);
        }
        return "";
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, AssemblyErrorLogger logger) throws DroolsParserException, IOException {
        System.out.println(">>>compile() method called!");
    }

    protected String getDrlFromScorecardModel(ScorecardModel model) {
        PMML pmml = this.createPMMLDocument(model);
        return ScorecardCompiler.convertToDRL((PMML)pmml, (ScorecardCompiler.DrlType)ScorecardCompiler.DrlType.EXTERNAL_OBJECT_MODEL);
    }

    private PMML createPMMLDocument(ScorecardModel model) {
        Scorecard pmmlScorecard = ScorecardPMMLUtils.createScorecard();
        Output output = new Output();
        Characteristics characteristics = new Characteristics();
        MiningSchema miningSchema = new MiningSchema();
        Extension extension = new Extension();
        extension.setName("externalClass");
        extension.setValue(model.getFactName());
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
        extension = new Extension();
        extension.setName("importsFromDelimitedString");
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(model.getFactName());
        StringBuilder importBuilder = new StringBuilder();
        importBuilder.append(model.getFactName());
        for (org.drools.ide.common.client.modeldriven.scorecards.Characteristic characteristic : model.getCharacteristics()) {
            if (imports.contains(characteristic.getFact())) continue;
            imports.add(characteristic.getFact());
            importBuilder.append(",").append(characteristic.getFact());
        }
        imports.clear();
        extension.setValue(importBuilder.toString());
        extension = new Extension();
        extension.setName("final");
        extension.setValue(model.getFieldName());
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
        extension = new Extension();
        extension.setName("scorecardPackage");
        extension.setValue(model.getPackageName());
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(extension);
        String modelName = this.convertToJavaIdentifier(model.getName());
        pmmlScorecard.setModelName(modelName);
        pmmlScorecard.setInitialScore(Double.valueOf(model.getInitialScore()));
        pmmlScorecard.setUseReasonCodes(Boolean.valueOf(model.isUseReasonCodes()));
        if (model.isUseReasonCodes()) {
            pmmlScorecard.setBaselineScore(Double.valueOf(model.getBaselineScore()));
            pmmlScorecard.setReasonCodeAlgorithm(model.getReasonCodesAlgorithm());
        }
        for (org.drools.ide.common.client.modeldriven.scorecards.Characteristic characteristic : model.getCharacteristics()) {
            Characteristic _characteristic = new Characteristic();
            characteristics.getCharacteristics().add(_characteristic);
            extension = new Extension();
            extension.setName("externalClass");
            extension.setValue(characteristic.getFact());
            _characteristic.getExtensions().add(extension);
            extension = new Extension();
            extension.setName("dataType");
            if ("string".equalsIgnoreCase(characteristic.getDataType())) {
                extension.setValue("Text");
            } else if ("int".equalsIgnoreCase(characteristic.getDataType()) || "double".equalsIgnoreCase(characteristic.getDataType())) {
                extension.setValue("Number");
            } else if ("boolean".equalsIgnoreCase(characteristic.getDataType())) {
                extension.setValue("Boolean");
            } else {
                System.out.println(">>>> Found unknown data type :: " + characteristic.getDataType());
            }
            _characteristic.getExtensions().add(extension);
            if (model.isUseReasonCodes()) {
                _characteristic.setBaselineScore(Double.valueOf(characteristic.getBaselineScore()));
                _characteristic.setReasonCode(characteristic.getReasonCode());
            }
            _characteristic.setName(characteristic.getName());
            MiningField miningField = new MiningField();
            miningField.setName(characteristic.getField());
            miningField.setUsageType(FIELDUSAGETYPE.ACTIVE);
            miningField.setInvalidValueTreatment(INVALIDVALUETREATMENTMETHOD.RETURN_INVALID);
            miningSchema.getMiningFields().add(miningField);
            extension = new Extension();
            extension.setName("externalClass");
            extension.setValue(characteristic.getFact());
            miningField.getExtensions().add(extension);
            Object[] numericOperators = new String[]{"=", ">", "<", ">=", "<="};
            for (Attribute attribute : characteristic.getAttributes()) {
                org.dmg.pmml.pmml_4_1.descr.Attribute _attribute = new org.dmg.pmml.pmml_4_1.descr.Attribute();
                _characteristic.getAttributes().add(_attribute);
                extension = new Extension();
                extension.setName("field");
                extension.setValue(characteristic.getField());
                _attribute.getExtensions().add(extension);
                if (model.isUseReasonCodes()) {
                    _attribute.setReasonCode(attribute.getReasonCode());
                }
                _attribute.setPartialScore(Double.valueOf(attribute.getPartialScore()));
                String operator = attribute.getOperator();
                String dataType = characteristic.getDataType();
                String predicateResolver = "boolean".equalsIgnoreCase(dataType) ? operator.toUpperCase() : ("String".equalsIgnoreCase(dataType) ? (operator.contains("=") ? operator + attribute.getValue() : attribute.getValue() + ",") : (ArrayUtils.contains((Object[])numericOperators, (Object)operator) ? operator + " " + attribute.getValue() : attribute.getValue().replace(",", "-")));
                extension = new Extension();
                extension.setName("predicateResolver");
                extension.setValue(predicateResolver);
                _attribute.getExtensions().add(extension);
            }
        }
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(miningSchema);
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(output);
        pmmlScorecard.getExtensionsAndCharacteristicsAndMiningSchemas().add(characteristics);
        return new PMMLGenerator().generateDocument(pmmlScorecard);
    }

    private String convertToJavaIdentifier(String modelName) {
        StringBuilder sb = new StringBuilder();
        if (!Character.isJavaIdentifierStart(modelName.charAt(0))) {
            sb.append("_");
        }
        for (char c : modelName.toCharArray()) {
            if (!Character.isJavaIdentifierPart(c)) {
                sb.append("_");
                continue;
            }
            sb.append(c);
        }
        modelName = sb.toString();
        return modelName;
    }

    public BuilderResult validateAsset(AssetItem assetItem) {
        System.out.println(">>> validateAsset() method.");
        ScorecardModel model = ScorecardsXMLPersistence.getInstance().unmarshall(assetItem.getContent());
        BuilderResult builderResult = this.validateScorecard(model);
        return builderResult;
    }

    private BuilderResult validateScorecard(ScorecardModel model) {
        BuilderResult builderResult = new BuilderResult();
        if (StringUtils.isBlank((String)model.getFactName())) {
            builderResult.addLine(this.createBuilderResultLine("Fact Name is empty.", "Setup Parameters"));
        }
        if (StringUtils.isBlank((String)model.getFieldName())) {
            builderResult.addLine(this.createBuilderResultLine("Resultant Score Field is empty.", "Setup Parameters"));
        }
        if (model.getCharacteristics().size() == 0) {
            builderResult.addLine(this.createBuilderResultLine("No Characteristics Found.", "Characteristics"));
        }
        int ctr = 1;
        for (org.drools.ide.common.client.modeldriven.scorecards.Characteristic c : model.getCharacteristics()) {
            String characteristicName = "Characteristic ('#" + ctr + "')";
            if (StringUtils.isBlank((String)c.getName())) {
                builderResult.addLine(this.createBuilderResultLine("Name is empty.", characteristicName));
            } else {
                characteristicName = "Characteristic ('" + c.getName() + "')";
            }
            if (StringUtils.isBlank((String)c.getFact())) {
                builderResult.addLine(this.createBuilderResultLine("Fact is empty.", characteristicName));
            }
            if (StringUtils.isBlank((String)c.getField())) {
                builderResult.addLine(this.createBuilderResultLine("Characteristic Field is empty.", characteristicName));
            } else if (StringUtils.isBlank((String)c.getDataType())) {
                builderResult.addLine(this.createBuilderResultLine("Internal Error (missing datatype).", characteristicName));
            }
            if (c.getAttributes().size() == 0) {
                builderResult.addLine(this.createBuilderResultLine("No Attributes Found.", characteristicName));
            }
            if (model.isUseReasonCodes()) {
                if (StringUtils.isBlank((String)model.getReasonCodeField())) {
                    builderResult.addLine(this.createBuilderResultLine("Resultant Reason Codes Field is empty.", characteristicName));
                }
                if (!"none".equalsIgnoreCase(model.getReasonCodesAlgorithm())) {
                    builderResult.addLine(this.createBuilderResultLine("Baseline Score is not specified.", characteristicName));
                }
            }
            int attrCtr = 1;
            for (Attribute attribute : c.getAttributes()) {
                String attributeName = "Attribute ('#" + attrCtr + "')";
                if (StringUtils.isBlank((String)attribute.getOperator())) {
                    builderResult.addLine(this.createBuilderResultLine("Attribute Operator is empty.", attributeName));
                }
                if (StringUtils.isBlank((String)attribute.getValue())) {
                    builderResult.addLine(this.createBuilderResultLine("Attribute Value is empty.", attributeName));
                }
                if (model.isUseReasonCodes() && StringUtils.isBlank((String)c.getReasonCode()) && StringUtils.isBlank((String)attribute.getReasonCode())) {
                    builderResult.addLine(this.createBuilderResultLine("Reasoncode must be set at either attribute or characteristic.", attributeName));
                }
                ++attrCtr;
            }
            ++ctr;
        }
        return builderResult;
    }

    public boolean validate(AssetItem assetItem) {
        System.out.println(">>> validate() method;");
        return true;
    }

    public BuilderResultLine createBuilderResultLine(String msg, String name) {
        return new BuilderResultLine().setMessage(msg).setAssetFormat(this.getFormat()).setAssetName(name);
    }

    public String getFormat() {
        return "scgd";
    }
}

